/*

 Chart.js

 http://chartjs.org/

 Version: 2.7.2



 Copyright 2018 Chart.js Contributors

 Released under the MIT license

 https://github.com/chartjs/Chart.js/blob/master/LICENSE.md



 This is the re-minified Chart.bundle.js file with the fix 

 for the conflict with the Color plugin

 https://github.com/chartjs/Chart.js/issues/3168

*/

(function(n){"object"===typeof exports&&"undefined"!==typeof module?module.exports=n():"function"===typeof define&&define.amd?define([],n):("undefined"!==typeof window?window:"undefined"!==typeof global?global:"undefined"!==typeof self?self:this).Chart=n()})(function(){return function(){function n(u,t,l){function h(a,d){if(!t[a]){if(!u[a]){var c="function"==typeof require&&require;if(!d&&c)return c(a,!0);if(f)return f(a,!0);c=Error("Cannot find module '"+a+"'");throw c.code="MODULE_NOT_FOUND",c;}c=

t[a]={exports:{}};u[a][0].call(c.exports,function(c){var d=u[a][1][c];return h(d?d:c)},c,c.exports,n,u,t,l)}return t[a].exports}for(var f="function"==typeof require&&require,a=0;a<l.length;a++)h(l[a]);return h}return n}()({1:[function(n,u,t){function l(a){if(a){var d=/^#([a-fA-F0-9]{6})$/i,k=/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,e=/^rgba?\(\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,m=/(\w+)/,

p=[0,0,0],f=1,h=a.match(/^#([a-fA-F0-9]{3})$/i);if(h)for(h=h[1],a=0;a<p.length;a++)p[a]=parseInt(h[a]+h[a],16);else if(h=a.match(d))for(h=h[1],a=0;a<p.length;a++)p[a]=parseInt(h.slice(2*a,2*a+2),16);else if(h=a.match(k)){for(a=0;a<p.length;a++)p[a]=parseInt(h[a+1]);f=parseFloat(h[4])}else if(h=a.match(e)){for(a=0;a<p.length;a++)p[a]=Math.round(2.55*parseFloat(h[a+1]));f=parseFloat(h[4])}else if(h=a.match(m)){if("transparent"==h[1])return[0,0,0,0];p=C[h[1]];if(!p)return}for(a=0;a<p.length;a++)p[a]=

c(p[a],0,255);f=f||0==f?c(f,0,1):1;p[3]=f;return p}}function h(a){if(a){var d=a.match(/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(d){var k=parseFloat(d[4]);a=c(parseInt(d[1]),0,360);var e=c(parseFloat(d[2]),0,100);d=c(parseFloat(d[3]),0,100);k=c(isNaN(k)?1:k,0,1);return[a,e,d,k]}}}function f(a){if(a){var d=a.match(/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(d){var k=

parseFloat(d[4]);a=c(parseInt(d[1]),0,360);var e=c(parseFloat(d[2]),0,100);d=c(parseFloat(d[3]),0,100);k=c(isNaN(k)?1:k,0,1);return[a,e,d,k]}}}function a(a,c){void 0===c&&(c=void 0!==a[3]?a[3]:1);return"rgba("+a[0]+", "+a[1]+", "+a[2]+", "+c+")"}function e(a,c){return"rgba("+Math.round(a[0]/255*100)+"%, "+Math.round(a[1]/255*100)+"%, "+Math.round(a[2]/255*100)+"%, "+(c||a[3]||1)+")"}function d(a,c){void 0===c&&(c=void 0!==a[3]?a[3]:1);return"hsla("+a[0]+", "+a[1]+"%, "+a[2]+"%, "+c+")"}function c(a,

c,d){return Math.min(Math.max(c,a),d)}function k(a){a=a.toString(16).toUpperCase();return 2>a.length?"0"+a:a}var C=n(5);u.exports={getRgba:l,getHsla:h,getRgb:function(a){return(a=l(a))&&a.slice(0,3)},getHsl:function(a){return(a=h(a))&&a.slice(0,3)},getHwb:f,getAlpha:function(a){var c=l(a);if(c||(c=h(a))||(c=f(a)))return c[3]},hexString:function(a){return"#"+k(a[0])+k(a[1])+k(a[2])},rgbString:function(c,d){return 1>d||c[3]&&1>c[3]?a(c,d):"rgb("+c[0]+", "+c[1]+", "+c[2]+")"},rgbaString:a,percentString:function(a,

c){return 1>c||a[3]&&1>a[3]?e(a,c):"rgb("+Math.round(a[0]/255*100)+"%, "+Math.round(a[1]/255*100)+"%, "+Math.round(a[2]/255*100)+"%)"},percentaString:e,hslString:function(a,c){return 1>c||a[3]&&1>a[3]?d(a,c):"hsl("+a[0]+", "+a[1]+"%, "+a[2]+"%)"},hslaString:d,hwbString:function(a,c){void 0===c&&(c=void 0!==a[3]?a[3]:1);return"hwb("+a[0]+", "+a[1]+"%, "+a[2]+"%"+(void 0!==c&&1!==c?", "+c:"")+")"},keyword:function(a){return v[a.slice(0,3)]}};var v={},m;for(m in C)v[C[m]]=m},{5:5}],2:[function(n,u,t){var l=

n(4),h=n(1),f=function(a){if(a instanceof f)return a;if(!(this instanceof f))return new f(a);this.valid=!1;this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1};var e;"string"===typeof a?(e=h.getRgba(a))?this.setValues("rgb",e):(e=h.getHsla(a))?this.setValues("hsl",e):(e=h.getHwb(a))&&this.setValues("hwb",e):"object"===typeof a&&(e=a,void 0!==e.r||void 0!==e.red?this.setValues("rgb",e):void 0!==e.l||void 0!==e.lightness?this.setValues("hsl",e):void 0!==e.v||void 0!==

e.value?this.setValues("hsv",e):void 0!==e.w||void 0!==e.whiteness?this.setValues("hwb",e):(void 0!==e.c||void 0!==e.cyan)&&this.setValues("cmyk",e))};f.prototype={isValid:function(){return this.valid},rgb:function(){return this.setSpace("rgb",arguments)},hsl:function(){return this.setSpace("hsl",arguments)},hsv:function(){return this.setSpace("hsv",arguments)},hwb:function(){return this.setSpace("hwb",arguments)},cmyk:function(){return this.setSpace("cmyk",arguments)},rgbArray:function(){return this.values.rgb},

hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){var a=this.values;return 1!==a.alpha?a.hwb.concat([a.alpha]):a.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var a=this.values;return a.rgb.concat([a.alpha])},hslaArray:function(){var a=this.values;return a.hsl.concat([a.alpha])},alpha:function(a){if(void 0===a)return this.values.alpha;this.setValues("alpha",a);return this},red:function(a){return this.setChannel("rgb",

0,a)},green:function(a){return this.setChannel("rgb",1,a)},blue:function(a){return this.setChannel("rgb",2,a)},hue:function(a){a&&(a%=360,a=0>a?360+a:a);return this.setChannel("hsl",0,a)},saturation:function(a){return this.setChannel("hsl",1,a)},lightness:function(a){return this.setChannel("hsl",2,a)},saturationv:function(a){return this.setChannel("hsv",1,a)},whiteness:function(a){return this.setChannel("hwb",1,a)},blackness:function(a){return this.setChannel("hwb",2,a)},value:function(a){return this.setChannel("hsv",

2,a)},cyan:function(a){return this.setChannel("cmyk",0,a)},magenta:function(a){return this.setChannel("cmyk",1,a)},yellow:function(a){return this.setChannel("cmyk",2,a)},black:function(a){return this.setChannel("cmyk",3,a)},hexString:function(){return h.hexString(this.values.rgb)},rgbString:function(){return h.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return h.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return h.percentString(this.values.rgb,this.values.alpha)},

hslString:function(){return h.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return h.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return h.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return h.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){var a=this.values.rgb;return a[0]<<16|a[1]<<8|a[2]},luminosity:function(){for(var a=this.values.rgb,e=[],d=0;d<a.length;d++){var c=a[d]/255;e[d]=.03928>=c?c/12.92:Math.pow((c+.055)/

1.055,2.4)}return.2126*e[0]+.7152*e[1]+.0722*e[2]},contrast:function(a){var e=this.luminosity();a=a.luminosity();return e>a?(e+.05)/(a+.05):(a+.05)/(e+.05)},level:function(a){a=this.contrast(a);return 7.1<=a?"AAA":4.5<=a?"AA":""},dark:function(){var a=this.values.rgb;return 128>(299*a[0]+587*a[1]+114*a[2])/1E3},light:function(){return!this.dark()},negate:function(){for(var a=[],e=0;3>e;e++)a[e]=255-this.values.rgb[e];this.setValues("rgb",a);return this},lighten:function(a){var e=this.values.hsl;e[2]+=

e[2]*a;this.setValues("hsl",e);return this},darken:function(a){var e=this.values.hsl;e[2]-=e[2]*a;this.setValues("hsl",e);return this},saturate:function(a){var e=this.values.hsl;e[1]+=e[1]*a;this.setValues("hsl",e);return this},desaturate:function(a){var e=this.values.hsl;e[1]-=e[1]*a;this.setValues("hsl",e);return this},whiten:function(a){var e=this.values.hwb;e[1]+=e[1]*a;this.setValues("hwb",e);return this},blacken:function(a){var e=this.values.hwb;e[2]+=e[2]*a;this.setValues("hwb",e);return this},

greyscale:function(){var a=this.values.rgb;a=.3*a[0]+.59*a[1]+.11*a[2];this.setValues("rgb",[a,a,a]);return this},clearer:function(a){var e=this.values.alpha;this.setValues("alpha",e-e*a);return this},opaquer:function(a){var e=this.values.alpha;this.setValues("alpha",e+e*a);return this},rotate:function(a){var e=this.values.hsl;a=(e[0]+a)%360;e[0]=0>a?360+a:a;this.setValues("hsl",e);return this},mix:function(a,e){var d=void 0===e?.5:e,c=2*d-1,k=this.alpha()-a.alpha();c=((-1===c*k?c:(c+k)/(1+c*k))+

1)/2;k=1-c;return this.rgb(c*this.red()+k*a.red(),c*this.green()+k*a.green(),c*this.blue()+k*a.blue()).alpha(this.alpha()*d+a.alpha()*(1-d))},toJSON:function(){return this.rgb()},clone:function(){var a=new f,e=this.values,d=a.values,c;for(c in e)if(e.hasOwnProperty(c)){var k=e[c];var h={}.toString.call(k);"[object Array]"===h?d[c]=k.slice(0):"[object Number]"===h?d[c]=k:console.error("unexpected color value:",k)}return a}};f.prototype.spaces={rgb:["red","green","blue"],hsl:["hue","saturation","lightness"],

hsv:["hue","saturation","value"],hwb:["hue","whiteness","blackness"],cmyk:["cyan","magenta","yellow","black"]};f.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]};f.prototype.getValues=function(a){for(var e=this.values,d={},c=0;c<a.length;c++)d[a.charAt(c)]=e[a][c];1!==e.alpha&&(d.a=e.alpha);return d};f.prototype.setValues=function(a,e){var d=this.values,c=this.spaces,k=this.maxes,h=1;this.valid=!0;if("alpha"===a)h=e;else if(e.length)d[a]=

e.slice(0,a.length),h=e[a.length];else if(void 0!==e[a.charAt(0)]){for(h=0;h<a.length;h++)d[a][h]=e[a.charAt(h)];h=e.a}else if(void 0!==e[c[a][0]]){var f=c[a];for(h=0;h<a.length;h++)d[a][h]=e[f[h]];h=e.alpha}d.alpha=Math.max(0,Math.min(1,void 0===h?d.alpha:h));if("alpha"===a)return!1;for(h=0;h<a.length;h++)f=Math.max(0,Math.min(k[a][h],d[a][h])),d[a][h]=Math.round(f);for(var m in c)m!==a&&(d[m]=l[a][m](d[a]));return!0};f.prototype.setSpace=function(a,e){var d=e[0];if(void 0===d)return this.getValues(a);

"number"===typeof d&&(d=Array.prototype.slice.call(e));this.setValues(a,d);return this};f.prototype.setChannel=function(a,e,d){var c=this.values[a];if(void 0===d)return c[e];if(d===c[e])return this;c[e]=d;this.setValues(a,c);return this};"undefined"!==typeof window&&(window.Chart=window.Chart||{},window.Chart.Color=f,"undefined"===typeof window.Color&&(window.Color=f));u.exports=f},{1:1,4:4}],3:[function(n,u,t){function l(a){var c=a[0]/255,d=a[1]/255,k=a[2]/255;a=Math.min(c,d,k);var e=Math.max(c,

d,k),h=e-a,m;e==a?m=0:c==e?m=(d-k)/h:d==e?m=2+(k-c)/h:k==e&&(m=4+(c-d)/h);m=Math.min(60*m,360);0>m&&(m+=360);c=(a+e)/2;return[m,100*(e==a?0:.5>=c?h/(e+a):h/(2-e-a)),100*c]}function h(a){var c=a[0],d=a[1];a=a[2];var k=Math.min(c,d,a),e=Math.max(c,d,a),h=e-k,m;e==k?m=0:c==e?m=(d-a)/h:d==e?m=2+(a-c)/h:a==e&&(m=4+(c-d)/h);m=Math.min(60*m,360);0>m&&(m+=360);return[m,0==e?0:h/e*1E3/10,e/255*1E3/10]}function f(a){var c=a[0],d=a[1],e=a[2];a=l(a)[0];var k=1/255*Math.min(c,Math.min(d,e));e=1-1/255*Math.max(c,

Math.max(d,e));return[a,100*k,100*e]}function a(a){var c=a[0]/255,d=a[1]/255;a=a[2]/255;var e=Math.min(1-c,1-d,1-a);return[100*((1-c-e)/(1-e)||0),100*((1-d-e)/(1-e)||0),100*((1-a-e)/(1-e)||0),100*e]}function e(a){return K[JSON.stringify(a)]}function d(a){var c=a[0]/255,d=a[1]/255;a=a[2]/255;c=.04045<c?Math.pow((c+.055)/1.055,2.4):c/12.92;d=.04045<d?Math.pow((d+.055)/1.055,2.4):d/12.92;a=.04045<a?Math.pow((a+.055)/1.055,2.4):a/12.92;return[100*(.4124*c+.3576*d+.1805*a),100*(.2126*c+.7152*d+.0722*a),

100*(.0193*c+.1192*d+.9505*a)]}function c(a){var c=d(a);a=c[0];var e=c[1];c=c[2];a/=95.047;e/=100;c/=108.883;a=.008856<a?Math.pow(a,1/3):7.787*a+16/116;e=.008856<e?Math.pow(e,1/3):7.787*e+16/116;c=.008856<c?Math.pow(c,1/3):7.787*c+16/116;return[116*e-16,500*(a-e),200*(e-c)]}function k(a){var c=a[0]/360,d=a[1]/100;a=a[2]/100;if(0==d){var e=255*a;return[e,e,e]}d=.5>a?a*(1+d):a+d-a*d;a=2*a-d;var k=[0,0,0];for(var m=0;3>m;m++)e=c+1/3*-(m-1),0>e&&e++,1<e&&e--,e=1>6*e?a+6*(d-a)*e:1>2*e?d:2>3*e?a+(d-a)*

(2/3-e)*6:a,k[m]=255*e;return k}function C(a){var c=a[0]/60,d=a[1]/100;a=a[2]/100;var e=Math.floor(c)%6,k=c-Math.floor(c);c=255*a*(1-d);var m=255*a*(1-d*k);d=255*a*(1-d*(1-k));a*=255;switch(e){case 0:return[a,d,c];case 1:return[m,a,c];case 2:return[c,a,d];case 3:return[c,m,a];case 4:return[d,c,a];case 5:return[a,c,m]}}function v(a){var c=a[0]/360,d=a[1]/100,e=a[2]/100;a=d+e;1<a&&(d/=a,e/=a);a=Math.floor(6*c);e=1-e;c=6*c-a;0!=(a&1)&&(c=1-c);c=d+c*(e-d);switch(a){default:case 6:case 0:r=e;g=c;b=d;break;

case 1:r=c;g=e;b=d;break;case 2:r=d;g=e;b=c;break;case 3:r=d;g=c;b=e;break;case 4:r=c;g=d;b=e;break;case 5:r=e,g=d,b=c}return[255*r,255*g,255*b]}function m(a){var c=a[3]/100;return[255*(1-Math.min(1,a[0]/100*(1-c)+c)),255*(1-Math.min(1,a[1]/100*(1-c)+c)),255*(1-Math.min(1,a[2]/100*(1-c)+c))]}function p(a){var c=a[0]/100,d=a[1]/100,e=a[2]/100;a=3.2406*c+-1.5372*d+-.4986*e;var k=-.9689*c+1.8758*d+.0415*e;c=.0557*c+-.204*d+1.057*e;a=.0031308<a?1.055*Math.pow(a,1/2.4)-.055:a*=12.92;k=.0031308<k?1.055*

Math.pow(k,1/2.4)-.055:k*=12.92;c=.0031308<c?1.055*Math.pow(c,1/2.4)-.055:c*=12.92;a=Math.min(Math.max(0,a),1);k=Math.min(Math.max(0,k),1);c=Math.min(Math.max(0,c),1);return[255*a,255*k,255*c]}function q(a){var c=a[0],d=a[1];a=a[2];c/=95.047;d/=100;a/=108.883;c=.008856<c?Math.pow(c,1/3):7.787*c+16/116;d=.008856<d?Math.pow(d,1/3):7.787*d+16/116;a=.008856<a?Math.pow(a,1/3):7.787*a+16/116;return[116*d-16,500*(c-d),200*(d-a)]}function x(a){var c=a[0],d=a[1];a=a[2];if(8>=c){c=100*c/903.3;var e=c/100*7.787+

16/116}else c=100*Math.pow((c+16)/116,3),e=Math.pow(c/100,1/3);var k=.008856>=k/95.047?k=95.047*(d/500+e-16/116)/7.787:95.047*Math.pow(d/500+e,3);var m=.008859>=m/108.883?m=108.883*(e-a/200-16/116)/7.787:108.883*Math.pow(e-a/200,3);return[k,c,m]}function y(a){var c=a[0],d=a[1];a=a[2];var e=360*Math.atan2(a,d)/2/Math.PI;0>e&&(e+=360);return[c,Math.sqrt(d*d+a*a),e]}function w(a){return p(x(a))}function F(a){var c=a[0],d=a[1];a=a[2]/360*2*Math.PI;return[c,d*Math.cos(a),d*Math.sin(a)]}u.exports={rgb2hsl:l,

rgb2hsv:h,rgb2hwb:f,rgb2cmyk:a,rgb2keyword:e,rgb2xyz:d,rgb2lab:c,rgb2lch:function(a){return y(c(a))},hsl2rgb:k,hsl2hsv:function(a){var c=a[0],d=a[1]/100;a=a[2]/100;if(0===a)return[0,0,0];a*=2;d*=1>=a?a:2-a;return[c,2*d/(a+d)*100,(a+d)/2*100]},hsl2hwb:function(a){return f(k(a))},hsl2cmyk:function(c){return a(k(c))},hsl2keyword:function(a){return e(k(a))},hsv2rgb:C,hsv2hsl:function(a){var c=a[0],d=a[1]/100,e=a[2]/100;a=(2-d)*e;d=d*e/(1>=a?a:2-a)||0;return[c,100*d,a/2*100]},hsv2hwb:function(a){return f(C(a))},

hsv2cmyk:function(c){return a(C(c))},hsv2keyword:function(a){return e(C(a))},hwb2rgb:v,hwb2hsl:function(a){return l(v(a))},hwb2hsv:function(a){return h(v(a))},hwb2cmyk:function(c){return a(v(c))},hwb2keyword:function(a){return e(v(a))},cmyk2rgb:m,cmyk2hsl:function(a){return l(m(a))},cmyk2hsv:function(a){return h(m(a))},cmyk2hwb:function(a){return f(m(a))},cmyk2keyword:function(a){return e(m(a))},keyword2rgb:function(a){return A[a]},keyword2hsl:function(a){return l(A[a])},keyword2hsv:function(a){return h(A[a])},

keyword2hwb:function(a){return f(A[a])},keyword2cmyk:function(c){return a(A[c])},keyword2lab:function(a){return c(A[a])},keyword2xyz:function(a){return d(A[a])},xyz2rgb:p,xyz2lab:q,xyz2lch:function(a){return y(q(a))},lab2xyz:x,lab2rgb:w,lab2lch:y,lch2lab:F,lch2xyz:function(a){return x(F(a))},lch2rgb:function(a){return w(F(a))}};var A={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,

0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,

140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,

165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,

182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,

209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,

160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,

191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},K={},M;for(M in A)K[JSON.stringify(A[M])]=M},{}],4:[function(n,u,t){var l=n(3),h=function(){return new a},f;for(f in l)h[f+"Raw"]=function(a){return function(d){"number"==typeof d&&(d=Array.prototype.slice.call(arguments));return l[a](d)}}(f),t=/(\w+)2(\w+)/.exec(f),n=t[1],t=t[2],h[n]=h[n]||{},h[n][t]=h[f]=function(a){return function(d){"number"==

typeof d&&(d=Array.prototype.slice.call(arguments));var c=l[a](d);if("string"==typeof c||void 0===c)return c;for(var e=0;e<c.length;e++)c[e]=Math.round(c[e]);return c}}(f);var a=function(){this.convs={}};a.prototype.routeSpace=function(a,d){var c=d[0];if(void 0===c)return this.getValues(a);"number"==typeof c&&(c=Array.prototype.slice.call(d));return this.setValues(a,c)};a.prototype.setValues=function(a,d){this.space=a;this.convs={};this.convs[a]=d;return this};a.prototype.getValues=function(a){var d=

this.convs[a];d||(d=this.space,d=h[d][a](this.convs[d]),this.convs[a]=d);return d};["rgb","hsl","hsv","cmyk","keyword"].forEach(function(e){a.prototype[e]=function(a){return this.routeSpace(e,arguments)}});u.exports=h},{3:3}],5:[function(n,u,t){u.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,

42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,

122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,

255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,

178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,

25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],

rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,

130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},{}],6:[function(n,u,t){(function(l,h){"object"===typeof t&&"undefined"!==typeof u?u.exports=h():l.moment=h()})(this,function(){function l(){return ic.apply(null,arguments)}function h(a){return a instanceof Array||"[object Array]"===Object.prototype.toString.call(a)}function f(a){return null!=a&&"[object Object]"===Object.prototype.toString.call(a)}function a(a){return void 0===a}

function e(a){return"number"===typeof a||"[object Number]"===Object.prototype.toString.call(a)}function d(a){return a instanceof Date||"[object Date]"===Object.prototype.toString.call(a)}function c(a,c){var z=[],d;for(d=0;d<a.length;++d)z.push(c(a[d],d));return z}function k(a,c){return Object.prototype.hasOwnProperty.call(a,c)}function C(a,c){for(var z in c)k(c,z)&&(a[z]=c[z]);k(c,"toString")&&(a.toString=c.toString);k(c,"valueOf")&&(a.valueOf=c.valueOf);return a}function v(a,c,d,e){return xb(a,c,

d,e,!0).utc()}function m(a){null==a._pf&&(a._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null,rfc2822:!1,weekdayMismatch:!1});return a._pf}function p(a){if(null==a._isValid){var z=m(a),c=jc.call(z.parsedDateParts,function(a){return null!=a});c=!isNaN(a._d.getTime())&&0>z.overflow&&!z.empty&&!z.invalidMonth&&!z.invalidWeekday&&!z.weekdayMismatch&&!z.nullInput&&!z.invalidFormat&&

!z.userInvalidated&&(!z.meridiem||z.meridiem&&c);a._strict&&(c=c&&0===z.charsLeftOver&&0===z.unusedTokens.length&&void 0===z.bigHour);if(null!=Object.isFrozen&&Object.isFrozen(a))return c;a._isValid=c}return a._isValid}function q(a){var z=v(NaN);null!=a?C(m(z),a):m(z).userInvalidated=!0;return z}function x(z,c){var d;a(c._isAMomentObject)||(z._isAMomentObject=c._isAMomentObject);a(c._i)||(z._i=c._i);a(c._f)||(z._f=c._f);a(c._l)||(z._l=c._l);a(c._strict)||(z._strict=c._strict);a(c._tzm)||(z._tzm=c._tzm);

a(c._isUTC)||(z._isUTC=c._isUTC);a(c._offset)||(z._offset=c._offset);a(c._pf)||(z._pf=m(c));a(c._locale)||(z._locale=c._locale);if(0<bb.length)for(d=0;d<bb.length;d++){var e=bb[d];var k=c[e];a(k)||(z[e]=k)}return z}function y(a){x(this,a);this._d=new Date(null!=a._d?a._d.getTime():NaN);this.isValid()||(this._d=new Date(NaN));!1===cb&&(cb=!0,l.updateOffset(this),cb=!1)}function w(a){return a instanceof y||null!=a&&null!=a._isAMomentObject}function F(a){return 0>a?Math.ceil(a)||0:Math.floor(a)}function A(a){a=

+a;var c=0;0!==a&&isFinite(a)&&(c=F(a));return c}function K(a,c,d){var z=Math.min(a.length,c.length),e=Math.abs(a.length-c.length),k=0,m;for(m=0;m<z;m++)(d&&a[m]!==c[m]||!d&&A(a[m])!==A(c[m]))&&k++;return k+e}function M(a){!1===l.suppressDeprecationWarnings&&"undefined"!==typeof console&&console.warn&&console.warn("Deprecation warning: "+a)}function L(a,c){var z=!0;return C(function(){null!=l.deprecationHandler&&l.deprecationHandler(null,a);if(z){for(var d=[],e,k=0;k<arguments.length;k++){e="";if("object"===

typeof arguments[k]){e+="\n["+k+"] ";for(var m in arguments[0])e+=m+": "+arguments[0][m]+", ";e=e.slice(0,-2)}else e=arguments[k];d.push(e)}M(a+"\nArguments: "+Array.prototype.slice.call(d).join("")+"\n"+Error().stack);z=!1}return c.apply(this,arguments)},c)}function t(a,c){null!=l.deprecationHandler&&l.deprecationHandler(a,c);yb[a]||(M(c),yb[a]=!0)}function J(a){return a instanceof Function||"[object Function]"===Object.prototype.toString.call(a)}function W(a,c){var z=C({},a),d;for(d in c)k(c,d)&&

(f(a[d])&&f(c[d])?(z[d]={},C(z[d],a[d]),C(z[d],c[d])):null!=c[d]?z[d]=c[d]:delete z[d]);for(d in a)k(a,d)&&!k(c,d)&&f(a[d])&&(z[d]=C({},z[d]));return z}function G(a){null!=a&&this.set(a)}function I(a,c){var z=a.toLowerCase();Ga[z]=Ga[z+"s"]=Ga[c]=a}function H(a){return"string"===typeof a?Ga[a]||Ga[a.toLowerCase()]:void 0}function N(a){var c={},z,d;for(d in a)k(a,d)&&(z=H(d))&&(c[z]=a[d]);return c}function Q(a){var c=[],z;for(z in a)c.push({unit:z,priority:da[z]});c.sort(function(a,c){return a.priority-

c.priority});return c}function V(a,c,d){var z=""+Math.abs(a);return(0<=a?d?"+":"":"-")+Math.pow(10,Math.max(0,c-z.length)).toString().substr(1)+z}function D(a,c,d,e){var z=e;"string"===typeof e&&(z=function(){return this[e]()});a&&(Ba[a]=z);c&&(Ba[c[0]]=function(){return V(z.apply(this,arguments),c[1],c[2])});d&&(Ba[d]=function(){return this.localeData().ordinal(z.apply(this,arguments),a)})}function X(a){return a.match(/\[[\s\S]/)?a.replace(/^\[|\]$/g,""):a.replace(/\\/g,"")}function la(a){var c=

a.match(zb),z;var d=0;for(z=c.length;d<z;d++)c[d]=Ba[c[d]]?Ba[c[d]]:X(c[d]);return function(d){var e="",k;for(k=0;k<z;k++)e+=J(c[k])?c[k].call(d,a):c[k];return e}}function ca(a,c){if(!a.isValid())return a.localeData().invalidDate();c=ha(c,a.localeData());db[c]=db[c]||la(c);return db[c](a)}function ha(a,c){function z(a){return c.longDateFormat(a)||a}var d=5;for(Na.lastIndex=0;0<=d&&Na.test(a);)a=a.replace(Na,z),Na.lastIndex=0,--d;return a}function E(a,c,d){eb[a]=J(c)?c:function(a,z){return a&&d?d:

c}}function P(a,c){return k(eb,a)?eb[a](c._strict,c._locale):new RegExp(ea(a))}function ea(a){return wa(a.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(a,c,z,d,e){return c||z||d||e}))}function wa(a){return a.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function S(a,c){var z,d=c;"string"===typeof a&&(a=[a]);e(c)&&(d=function(a,z){z[c]=A(a)});for(z=0;z<a.length;z++)fb[a[z]]=d}function Ha(a,c){S(a,function(a,z,d,e){d._w=d._w||{};c(a,d._w,d,e)})}function ra(a){return 0===a%4&&0!==

a%100||0===a%400}function Ca(a,c){return function(z){return null!=z?(Ab(this,a,z),l.updateOffset(this,c),this):Oa(this,a)}}function Oa(a,c){return a.isValid()?a._d["get"+(a._isUTC?"UTC":"")+c]():NaN}function Ab(a,c,d){if(a.isValid()&&!isNaN(d))if("FullYear"===c&&ra(a.year())&&1===a.month()&&29===a.date())a._d["set"+(a._isUTC?"UTC":"")+c](d,a.month(),Pa(d,a.month()));else a._d["set"+(a._isUTC?"UTC":"")+c](d)}function Pa(a,c){if(isNaN(a)||isNaN(c))return NaN;var d=(c%12+12)%12;return 1===d?ra(a+(c-

d)/12)?29:28:31-d%7%2}function Bb(a,c){if(!a.isValid())return a;if("string"===typeof c)if(/^\d+$/.test(c))c=A(c);else if(c=a.localeData().monthsParse(c),!e(c))return a;var d=Math.min(a.date(),Pa(a.year(),c));a._d["set"+(a._isUTC?"UTC":"")+"Month"](c,d);return a}function Cb(a){return null!=a?(Bb(this,a),l.updateOffset(this,!0),this):Oa(this,"Month")}function Db(){function a(a,c){return c.length-a.length}var c=[],d=[],e=[],k;for(k=0;12>k;k++){var m=v([2E3,k]);c.push(this.monthsShort(m,""));d.push(this.months(m,

""));e.push(this.months(m,""));e.push(this.monthsShort(m,""))}c.sort(a);d.sort(a);e.sort(a);for(k=0;12>k;k++)c[k]=wa(c[k]),d[k]=wa(d[k]);for(k=0;24>k;k++)e[k]=wa(e[k]);this._monthsShortRegex=this._monthsRegex=new RegExp("^("+e.join("|")+")","i");this._monthsStrictRegex=new RegExp("^("+d.join("|")+")","i");this._monthsShortStrictRegex=new RegExp("^("+c.join("|")+")","i")}function kc(a,c,d,e,k,m,h){c=new Date(a,c,d,e,k,m,h);100>a&&0<=a&&isFinite(c.getFullYear())&&c.setFullYear(a);return c}function Ia(a){var c=

new Date(Date.UTC.apply(null,arguments));100>a&&0<=a&&isFinite(c.getUTCFullYear())&&c.setUTCFullYear(a);return c}function Qa(a,c,d){d=7+c-d;return-((7+Ia(a,0,d).getUTCDay()-c)%7)+d-1}function Eb(a,c,d,e,k){d=(7+d-e)%7;e=Qa(a,e,k);e=1+7*(c-1)+d+e;0>=e?(c=a-1,a=(ra(c)?366:365)+e):e>(ra(a)?366:365)?(c=a+1,a=e-(ra(a)?366:365)):(c=a,a=e);return{year:c,dayOfYear:a}}function Ja(a,c,d){var z=Qa(a.year(),c,d);z=Math.floor((a.dayOfYear()-z-1)/7)+1;1>z?(a=a.year()-1,c=z+xa(a,c,d)):z>xa(a.year(),c,d)?(c=z-xa(a.year(),

c,d),a=a.year()+1):(a=a.year(),c=z);return{week:c,year:a}}function xa(a,c,d){var z=Qa(a,c,d);c=Qa(a+1,c,d);return((ra(a)?366:365)-z+c)/7}function lc(a,c,d){var z;a=a.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],z=0;7>z;++z){var e=v([2E3,1]).day(z);this._minWeekdaysParse[z]=this.weekdaysMin(e,"").toLocaleLowerCase();this._shortWeekdaysParse[z]=this.weekdaysShort(e,"").toLocaleLowerCase();this._weekdaysParse[z]=this.weekdays(e,

"").toLocaleLowerCase()}if(d)c="dddd"===c?Y.call(this._weekdaysParse,a):"ddd"===c?Y.call(this._shortWeekdaysParse,a):Y.call(this._minWeekdaysParse,a);else if("dddd"===c){c=Y.call(this._weekdaysParse,a);if(-1!==c)return c;c=Y.call(this._shortWeekdaysParse,a);if(-1!==c)return c;c=Y.call(this._minWeekdaysParse,a)}else if("ddd"===c){c=Y.call(this._shortWeekdaysParse,a);if(-1!==c)return c;c=Y.call(this._weekdaysParse,a);if(-1!==c)return c;c=Y.call(this._minWeekdaysParse,a)}else{c=Y.call(this._minWeekdaysParse,

a);if(-1!==c)return c;c=Y.call(this._weekdaysParse,a);if(-1!==c)return c;c=Y.call(this._shortWeekdaysParse,a)}return-1!==c?c:null}function gb(){function a(a,c){return c.length-a.length}var c=[],d=[],e=[],k=[],m;for(m=0;7>m;m++){var h=v([2E3,1]).day(m);var f=this.weekdaysMin(h,"");var q=this.weekdaysShort(h,"");h=this.weekdays(h,"");c.push(f);d.push(q);e.push(h);k.push(f);k.push(q);k.push(h)}c.sort(a);d.sort(a);e.sort(a);k.sort(a);for(m=0;7>m;m++)d[m]=wa(d[m]),e[m]=wa(e[m]),k[m]=wa(k[m]);this._weekdaysMinRegex=

this._weekdaysShortRegex=this._weekdaysRegex=new RegExp("^("+k.join("|")+")","i");this._weekdaysStrictRegex=new RegExp("^("+e.join("|")+")","i");this._weekdaysShortStrictRegex=new RegExp("^("+d.join("|")+")","i");this._weekdaysMinStrictRegex=new RegExp("^("+c.join("|")+")","i")}function hb(){return this.hours()%12||12}function Fb(a,c){D(a,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),c)})}function Gb(a,c){return c._meridiemParse}function Hb(a){return a?a.toLowerCase().replace("_",

"-"):a}function ib(a){var c=null;if(!Z[a]&&"undefined"!==typeof u&&u&&u.exports)try{c=Ra._abbr,n("./locale/"+a),Da(c)}catch(bd){}return Z[a]}function Da(c,d){var e;c&&(e=a(d)?sa(c):jb(c,d))&&(Ra=e);return Ra._abbr}function jb(a,c){if(null!==c){var d=Ib;c.abbr=a;if(null!=Z[a])t("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),

d=Z[a]._config;else if(null!=c.parentLocale)if(null!=Z[c.parentLocale])d=Z[c.parentLocale]._config;else return Ka[c.parentLocale]||(Ka[c.parentLocale]=[]),Ka[c.parentLocale].push({name:a,config:c}),null;Z[a]=new G(W(d,c));Ka[a]&&Ka[a].forEach(function(a){jb(a.name,a.config)});Da(a);return Z[a]}delete Z[a];return null}function sa(a){var c;a&&a._locale&&a._locale._abbr&&(a=a._locale._abbr);if(!a)return Ra;if(!h(a)){if(c=ib(a))return c;a=[a]}a:{c=0;for(var d,e,z,k;c<a.length;){k=Hb(a[c]).split("-");

d=k.length;for(e=(e=Hb(a[c+1]))?e.split("-"):null;0<d;){if(z=ib(k.slice(0,d).join("-"))){a=z;break a}if(e&&e.length>=d&&K(k,e,!0)>=d-1)break;d--}c++}a=null}return a}function kb(a){var c;(c=a._a)&&-2===m(a).overflow&&(c=0>c[oa]||11<c[oa]?oa:1>c[ma]||c[ma]>Pa(c[ia],c[oa])?ma:0>c[aa]||24<c[aa]||24===c[aa]&&(0!==c[ja]||0!==c[pa]||0!==c[ya])?aa:0>c[ja]||59<c[ja]?ja:0>c[pa]||59<c[pa]?pa:0>c[ya]||999<c[ya]?ya:-1,m(a)._overflowDayOfYear&&(c<ia||c>ma)&&(c=ma),m(a)._overflowWeeks&&-1===c&&(c=mc),m(a)._overflowWeekday&&

-1===c&&(c=nc),m(a).overflow=c);return a}function Ea(a,c,d){return null!=a?a:null!=c?c:d}function lb(a){var c=[];if(!a._d){var d=new Date(l.now());d=a._useUTC?[d.getUTCFullYear(),d.getUTCMonth(),d.getUTCDate()]:[d.getFullYear(),d.getMonth(),d.getDate()];if(a._w&&null==a._a[ma]&&null==a._a[oa]){var e=a._w;if(null!=e.GG||null!=e.W||null!=e.E){var k=1;var z=4;var h=Ea(e.GG,a._a[ia],Ja(U(),1,4).year);var f=Ea(e.W,1);var q=Ea(e.E,1);if(1>q||7<q)var p=!0}else if(k=a._locale._week.dow,z=a._locale._week.doy,

f=Ja(U(),k,z),h=Ea(e.gg,a._a[ia],f.year),f=Ea(e.w,f.week),null!=e.d){if(q=e.d,0>q||6<q)p=!0}else if(null!=e.e){if(q=e.e+k,0>e.e||6<e.e)p=!0}else q=k;1>f||f>xa(h,k,z)?m(a)._overflowWeeks=!0:null!=p?m(a)._overflowWeekday=!0:(p=Eb(h,f,q,k,z),a._a[ia]=p.year,a._dayOfYear=p.dayOfYear)}if(null!=a._dayOfYear){p=Ea(a._a[ia],d[ia]);if(a._dayOfYear>(ra(p)?366:365)||0===a._dayOfYear)m(a)._overflowDayOfYear=!0;p=Ia(p,0,a._dayOfYear);a._a[oa]=p.getUTCMonth();a._a[ma]=p.getUTCDate()}for(p=0;3>p&&null==a._a[p];++p)a._a[p]=

c[p]=d[p];for(;7>p;p++)a._a[p]=c[p]=null==a._a[p]?2===p?1:0:a._a[p];24===a._a[aa]&&0===a._a[ja]&&0===a._a[pa]&&0===a._a[ya]&&(a._nextDay=!0,a._a[aa]=0);a._d=(a._useUTC?Ia:kc).apply(null,c);c=a._useUTC?a._d.getUTCDay():a._d.getDay();null!=a._tzm&&a._d.setUTCMinutes(a._d.getUTCMinutes()-a._tzm);a._nextDay&&(a._a[aa]=24);a._w&&"undefined"!==typeof a._w.d&&a._w.d!==c&&(m(a).weekdayMismatch=!0)}}function Jb(a){var c;var d=a._i;var e=oc.exec(d)||pc.exec(d);if(e){m(a).iso=!0;d=0;for(c=Sa.length;d<c;d++)if(Sa[d][1].exec(e[1])){var k=

Sa[d][0];var z=!1!==Sa[d][2];break}if(null==k)a._isValid=!1;else{if(e[3]){d=0;for(c=mb.length;d<c;d++)if(mb[d][1].exec(e[3])){var h=(e[2]||" ")+mb[d][0];break}if(null==h){a._isValid=!1;return}}if(z||null==h){if(e[4])if(qc.exec(e[4]))var f="Z";else{a._isValid=!1;return}a._f=k+(h||"")+(f||"");nb(a)}else a._isValid=!1}}else a._isValid=!1}function Kb(a){var c=rc.exec(a._i.replace(/\([^)]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").trim());if(c){var d=c[3],e=c[2],k=c[5],z=c[6],h=c[7],f=parseInt(c[4],10);

d=[49>=f?2E3+f:999>=f?1900+f:f,Lb.indexOf(d),parseInt(e,10),parseInt(k,10),parseInt(z,10)];h&&d.push(parseInt(h,10));a:{if(h=c[1])if(h=Mb.indexOf(h),e=(new Date(d[0],d[1],d[2])).getDay(),h!==e){m(a).weekdayMismatch=!0;h=a._isValid=!1;break a}h=!0}h&&(a._a=d,(h=c[8])?c=sc[h]:c[9]?c=0:(c=parseInt(c[10],10),h=c%100,c=(c-h)/100*60+h),a._tzm=c,a._d=Ia.apply(null,a._a),a._d.setUTCMinutes(a._d.getUTCMinutes()-a._tzm),m(a).rfc2822=!0)}else a._isValid=!1}function tc(a){var c=uc.exec(a._i);null!==c?a._d=new Date(+c[1]):

(Jb(a),!1===a._isValid&&(delete a._isValid,Kb(a),!1===a._isValid&&(delete a._isValid,l.createFromInputFallback(a))))}function nb(a){if(a._f===l.ISO_8601)Jb(a);else if(a._f===l.RFC_2822)Kb(a);else{a._a=[];m(a).empty=!0;var c=""+a._i,d,e,z=c.length,h=0;var f=ha(a._f,a._locale).match(zb)||[];for(d=0;d<f.length;d++){var q=f[d];if(e=(c.match(P(q,a))||[])[0]){var p=c.substr(0,c.indexOf(e));0<p.length&&m(a).unusedInput.push(p);c=c.slice(c.indexOf(e)+e.length);h+=e.length}if(Ba[q]){if(e?m(a).empty=!1:m(a).unusedTokens.push(q),

p=a,null!=e&&k(fb,q))fb[q](e,p._a,p,q)}else a._strict&&!e&&m(a).unusedTokens.push(q)}m(a).charsLeftOver=z-h;0<c.length&&m(a).unusedInput.push(c);12>=a._a[aa]&&!0===m(a).bigHour&&0<a._a[aa]&&(m(a).bigHour=void 0);m(a).parsedDateParts=a._a.slice(0);m(a).meridiem=a._meridiem;c=a._a;d=aa;z=a._locale;f=a._a[aa];h=a._meridiem;null!=h&&(null!=z.meridiemHour?f=z.meridiemHour(f,h):null!=z.isPM&&((z=z.isPM(h))&&12>f&&(f+=12),z||12!==f||(f=0)));c[d]=f;lb(a);kb(a)}}function vc(a){if(!a._d){var d=N(a._i);a._a=

c([d.year,d.month,d.day||d.date,d.hour,d.minute,d.second,d.millisecond],function(a){return a&&parseInt(a,10)});lb(a)}}function Nb(a){var c=a._i,e=a._f;a._locale=a._locale||sa(a._l);if(null===c||void 0===e&&""===c)return q({nullInput:!0});"string"===typeof c&&(a._i=c=a._locale.preparse(c));if(w(c))return new y(kb(c));if(d(c))a._d=c;else if(h(e))if(0===a._f.length)m(a).invalidFormat=!0,a._d=new Date(NaN);else{for(c=0;c<a._f.length;c++){e=0;var k=x({},a);null!=a._useUTC&&(k._useUTC=a._useUTC);k._f=a._f[c];

nb(k);if(p(k)&&(e+=m(k).charsLeftOver,e+=10*m(k).unusedTokens.length,m(k).score=e,null==z||e<z)){var z=e;var f=k}}C(a,f||k)}else e?nb(a):wc(a);p(a)||(a._d=null);return a}function wc(k){var m=k._i;a(m)?k._d=new Date(l.now()):d(m)?k._d=new Date(m.valueOf()):"string"===typeof m?tc(k):h(m)?(k._a=c(m.slice(0),function(a){return parseInt(a,10)}),lb(k)):f(m)?vc(k):e(m)?k._d=new Date(m):l.createFromInputFallback(k)}function xb(a,c,d,e,k){var m={};if(!0===d||!1===d)e=d,d=void 0;var z;if(z=f(a))a:if(z=a,Object.getOwnPropertyNames)z=

0===Object.getOwnPropertyNames(z).length;else{for(var q in z)if(z.hasOwnProperty(q)){z=!1;break a}z=!0}if(z||h(a)&&0===a.length)a=void 0;m._isAMomentObject=!0;m._useUTC=m._isUTC=k;m._l=d;m._i=a;m._f=c;m._strict=e;a=new y(kb(Nb(m)));a._nextDay&&(a.add(1,"d"),a._nextDay=void 0);return a}function U(a,c,d,e){return xb(a,c,d,e,!1)}function Ob(a,c){var d;1===c.length&&h(c[0])&&(c=c[0]);if(!c.length)return U();var e=c[0];for(d=1;d<c.length;++d)if(!c[d].isValid()||c[d][a](e))e=c[d];return e}function Ta(a){var c=

N(a);a=c.year||0;var d=c.quarter||0,e=c.month||0,k=c.week||0,m=c.day||0,h=c.hour||0,z=c.minute||0,f=c.second||0,q=c.millisecond||0;a:{for(var p in c)if(-1===Y.call(La,p)||null!=c[p]&&isNaN(c[p])){c=!1;break a}p=!1;for(var C=0;C<La.length;++C)if(c[La[C]]){if(p){c=!1;break a}parseFloat(c[La[C]])!==A(c[La[C]])&&(p=!0)}c=!0}this._isValid=c;this._milliseconds=+q+1E3*f+6E4*z+36E5*h;this._days=+m+7*k;this._months=+e+3*d+12*a;this._data={};this._locale=sa();this._bubble()}function ob(a){return a instanceof

Ta}function pb(a){return 0>a?-1*Math.round(-1*a):Math.round(a)}function Pb(a,c){D(a,0,0,function(){var a=this.utcOffset(),d="+";0>a&&(a=-a,d="-");return d+V(~~(a/60),2)+c+V(~~a%60,2)})}function qb(a,c){var d=(c||"").match(a);if(null===d)return null;d=((d[d.length-1]||[])+"").match(xc)||["-",0,0];var e=+(60*d[1])+A(d[2]);return 0===e?0:"+"===d[0]?e:-e}function rb(a,c){if(c._isUTC){var e=c.clone();var k=(w(a)||d(a)?a.valueOf():U(a).valueOf())-e.valueOf();e._d.setTime(e._d.valueOf()+k);l.updateOffset(e,

!1);return e}return U(a).local()}function Qb(){return this.isValid()?this._isUTC&&0===this._offset:!1}function ka(a,c){var d=a,m;ob(a)?d={ms:a._milliseconds,d:a._days,M:a._months}:e(a)?(d={},c?d[c]=a:d.milliseconds=a):(m=yc.exec(a))?(d="-"===m[1]?-1:1,d={y:0,d:A(m[ma])*d,h:A(m[aa])*d,m:A(m[ja])*d,s:A(m[pa])*d,ms:A(pb(1E3*m[ya]))*d}):(m=zc.exec(a))?(d="-"===m[1]?-1:1,d={y:za(m[2],d),M:za(m[3],d),w:za(m[4],d),d:za(m[5],d),h:za(m[6],d),m:za(m[7],d),s:za(m[8],d)}):null==d?d={}:"object"===typeof d&&("from"in

d||"to"in d)&&(m=U(d.from),d=U(d.to),m.isValid()&&d.isValid()?(d=rb(d,m),m.isBefore(d)?d=Rb(m,d):(d=Rb(d,m),d.milliseconds=-d.milliseconds,d.months=-d.months),m=d):m={milliseconds:0,months:0},d={},d.ms=m.milliseconds,d.M=m.months);d=new Ta(d);ob(a)&&k(a,"_locale")&&(d._locale=a._locale);return d}function za(a,c){var d=a&&parseFloat(a.replace(",","."));return(isNaN(d)?0:d)*c}function Rb(a,c){var d={milliseconds:0,months:0};d.months=c.month()-a.month()+12*(c.year()-a.year());a.clone().add(d.months,

"M").isAfter(c)&&--d.months;d.milliseconds=+c-+a.clone().add(d.months,"M");return d}function Sb(a,c){return function(d,e){if(null!==e&&!isNaN(+e)){t(c,"moment()."+c+"(period, number) is deprecated. Please use moment()."+c+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.");var k=d;d=e;e=k}k=ka("string"===typeof d?+d:d,e);Tb(this,k,a);return this}}function Tb(a,c,d,e){var k=c._milliseconds,m=pb(c._days);c=pb(c._months);a.isValid()&&(e=null==e?!0:e,c&&Bb(a,

Oa(a,"Month")+c*d),m&&Ab(a,"Date",Oa(a,"Date")+m*d),k&&a._d.setTime(a._d.valueOf()+k*d),e&&l.updateOffset(a,m||c))}function sb(a,c){var d=12*(c.year()-a.year())+(c.month()-a.month()),e=a.clone().add(d,"months");if(0>c-e){var k=a.clone().add(d-1,"months");e=(c-e)/(e-k)}else k=a.clone().add(d+1,"months"),e=(c-e)/(k-e);return-(d+e)||0}function Ub(a){if(void 0===a)return this._locale._abbr;a=sa(a);null!=a&&(this._locale=a);return this}function Vb(){return this._locale}function Ua(a,c){D(0,[a,a.length],

0,c)}function Wb(a,c,d,e,k){if(null==a)return Ja(this,e,k).year;var m=xa(a,e,k);c>m&&(c=m);a=Eb(a,c,d,e,k);a=Ia(a.year,0,a.dayOfYear);this.year(a.getUTCFullYear());this.month(a.getUTCMonth());this.date(a.getUTCDate());return this}function Ac(a,c){c[ya]=A(1E3*("0."+a))}function Xb(a){return a}function Va(a,c,d,e){var k=sa();c=v().set(e,c);return k[d](c,a)}function Yb(a,c,d){e(a)&&(c=a,a=void 0);a=a||"";if(null!=c)return Va(a,c,d,"month");var k=[];for(c=0;12>c;c++)k[c]=Va(a,c,d,"month");return k}function tb(a,

c,d,k){"boolean"!==typeof a&&(d=c=a,a=!1);e(c)&&(d=c,c=void 0);c=c||"";var m=sa();a=a?m._week.dow:0;if(null!=d)return Va(c,(d+a)%7,k,"day");m=[];for(d=0;7>d;d++)m[d]=Va(c,(d+a)%7,k,"day");return m}function Zb(a,c,d,e){c=ka(c,d);a._milliseconds+=e*c._milliseconds;a._days+=e*c._days;a._months+=e*c._months;return a._bubble()}function $b(a){return 0>a?Math.floor(a):Math.ceil(a)}function ta(a){return function(){return this.as(a)}}function Aa(a){return function(){return this.isValid()?this._data[a]:NaN}}

function Bc(a,c,d,e,k){return k.relativeTime(c||1,!!d,a,e)}function Fa(a){return(0<a)-(0>a)||+a}function Wa(){if(!this.isValid())return this.localeData().invalidDate();var a=ub(this._milliseconds)/1E3,c=ub(this._days),d=ub(this._months);var e=F(a/60);var k=F(e/60);a%=60;e%=60;var m=F(d/12);d%=12;a=a?a.toFixed(3).replace(/\.?0+$/,""):"";var h=this.asSeconds();if(!h)return"P0D";var f=0>h?"-":"",q=Fa(this._months)!==Fa(h)?"-":"",p=Fa(this._days)!==Fa(h)?"-":"";h=Fa(this._milliseconds)!==Fa(h)?"-":"";

return f+"P"+(m?q+m+"Y":"")+(d?q+d+"M":"")+(c?p+c+"D":"")+(k||e||a?"T":"")+(k?h+k+"H":"")+(e?h+e+"M":"")+(a?h+a+"S":"")}var jc=Array.prototype.some?Array.prototype.some:function(a){for(var c=Object(this),d=c.length>>>0,e=0;e<d;e++)if(e in c&&a.call(this,c[e],e,c))return!0;return!1};var bb=l.momentProperties=[],cb=!1,yb={};l.suppressDeprecationWarnings=!1;l.deprecationHandler=null;var Cc=Object.keys?Object.keys:function(a){var c,d=[];for(c in a)k(a,c)&&d.push(c);return d};var Ga={},da={},zb=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,

Na=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,db={},Ba={},ac=/\d/,fa=/\d\d/,bc=/\d{3}/,vb=/\d{4}/,Xa=/[+-]?\d{6}/,T=/\d\d?/,cc=/\d\d\d\d?/,dc=/\d\d\d\d\d\d?/,Ya=/\d{1,3}/,wb=/\d{1,4}/,Za=/[+-]?\d{1,6}/,Dc=/\d+/,$a=/[+-]?\d+/,Ec=/Z|[+-]\d\d:?\d\d/gi,ab=/Z|[+-]\d\d(?::?\d\d)?/gi,Ma=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,eb={},fb={},ia=0,oa=1,ma=2,aa=3,ja=4,pa=5,ya=6,mc=7,nc=8;D("Y",0,0,

function(){var a=this.year();return 9999>=a?""+a:"+"+a});D(0,["YY",2],0,function(){return this.year()%100});D(0,["YYYY",4],0,"year");D(0,["YYYYY",5],0,"year");D(0,["YYYYYY",6,!0],0,"year");I("year","y");da.year=1;E("Y",$a);E("YY",T,fa);E("YYYY",wb,vb);E("YYYYY",Za,Xa);E("YYYYYY",Za,Xa);S(["YYYYY","YYYYYY"],ia);S("YYYY",function(a,c){c[ia]=2===a.length?l.parseTwoDigitYear(a):A(a)});S("YY",function(a,c){c[ia]=l.parseTwoDigitYear(a)});S("Y",function(a,c){c[ia]=parseInt(a,10)});l.parseTwoDigitYear=function(a){return A(a)+

(68<A(a)?1900:2E3)};var ec=Ca("FullYear",!0);var Y=Array.prototype.indexOf?Array.prototype.indexOf:function(a){var c;for(c=0;c<this.length;++c)if(this[c]===a)return c;return-1};D("M",["MM",2],"Mo",function(){return this.month()+1});D("MMM",0,0,function(a){return this.localeData().monthsShort(this,a)});D("MMMM",0,0,function(a){return this.localeData().months(this,a)});I("month","M");da.month=8;E("M",T);E("MM",T,fa);E("MMM",function(a,c){return c.monthsShortRegex(a)});E("MMMM",function(a,c){return c.monthsRegex(a)});

S(["M","MM"],function(a,c){c[oa]=A(a)-1});S(["MMM","MMMM"],function(a,c,d,e){e=d._locale.monthsParse(a,e,d._strict);null!=e?c[oa]=e:m(d).invalidMonth=a});var fc=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,Lb="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" ");D("w",["ww",2],"wo","week");D("W",["WW",2],"Wo","isoWeek");I("week","w");I("isoWeek","W");da.week=5;da.isoWeek=5;E("w",T);E("ww",T,fa);E("W",T);E("WW",T,fa);Ha(["w","ww","W","WW"],function(a,c,d,e){c[e.substr(0,1)]=A(a)});D("d",0,"do","day");D("dd",

0,0,function(a){return this.localeData().weekdaysMin(this,a)});D("ddd",0,0,function(a){return this.localeData().weekdaysShort(this,a)});D("dddd",0,0,function(a){return this.localeData().weekdays(this,a)});D("e",0,0,"weekday");D("E",0,0,"isoWeekday");I("day","d");I("weekday","e");I("isoWeekday","E");da.day=11;da.weekday=11;da.isoWeekday=11;E("d",T);E("e",T);E("E",T);E("dd",function(a,c){return c.weekdaysMinRegex(a)});E("ddd",function(a,c){return c.weekdaysShortRegex(a)});E("dddd",function(a,c){return c.weekdaysRegex(a)});

Ha(["dd","ddd","dddd"],function(a,c,d,e){e=d._locale.weekdaysParse(a,e,d._strict);null!=e?c.d=e:m(d).invalidWeekday=a});Ha(["d","e","E"],function(a,c,d,e){c[e]=A(a)});var Mb="Sun Mon Tue Wed Thu Fri Sat".split(" ");D("H",["HH",2],0,"hour");D("h",["hh",2],0,hb);D("k",["kk",2],0,function(){return this.hours()||24});D("hmm",0,0,function(){return""+hb.apply(this)+V(this.minutes(),2)});D("hmmss",0,0,function(){return""+hb.apply(this)+V(this.minutes(),2)+V(this.seconds(),2)});D("Hmm",0,0,function(){return""+

this.hours()+V(this.minutes(),2)});D("Hmmss",0,0,function(){return""+this.hours()+V(this.minutes(),2)+V(this.seconds(),2)});Fb("a",!0);Fb("A",!1);I("hour","h");da.hour=13;E("a",Gb);E("A",Gb);E("H",T);E("h",T);E("k",T);E("HH",T,fa);E("hh",T,fa);E("kk",T,fa);E("hmm",cc);E("hmmss",dc);E("Hmm",cc);E("Hmmss",dc);S(["H","HH"],aa);S(["k","kk"],function(a,c,d){a=A(a);c[aa]=24===a?0:a});S(["a","A"],function(a,c,d){d._isPm=d._locale.isPM(a);d._meridiem=a});S(["h","hh"],function(a,c,d){c[aa]=A(a);m(d).bigHour=

!0});S("hmm",function(a,c,d){var e=a.length-2;c[aa]=A(a.substr(0,e));c[ja]=A(a.substr(e));m(d).bigHour=!0});S("hmmss",function(a,c,d){var e=a.length-4,k=a.length-2;c[aa]=A(a.substr(0,e));c[ja]=A(a.substr(e,2));c[pa]=A(a.substr(k));m(d).bigHour=!0});S("Hmm",function(a,c,d){d=a.length-2;c[aa]=A(a.substr(0,d));c[ja]=A(a.substr(d))});S("Hmmss",function(a,c,d){d=a.length-4;var e=a.length-2;c[aa]=A(a.substr(0,d));c[ja]=A(a.substr(d,2));c[pa]=A(a.substr(e))});var Fc=Ca("Hours",!0),Ib={calendar:{sameDay:"[Today at] LT",

nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},longDateFormat:{LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},invalidDate:"Invalid date",ordinal:"%d",dayOfMonthOrdinalParse:/\d{1,2}/,relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",

MM:"%d months",y:"a year",yy:"%d years"},months:"January February March April May June July August September October November December".split(" "),monthsShort:Lb,week:{dow:0,doy:6},weekdays:"Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),weekdaysMin:"Su Mo Tu We Th Fr Sa".split(" "),weekdaysShort:Mb,meridiemParse:/[ap]\.?m?\.?/i},Z={},Ka={},Ra,oc=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,

pc=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,qc=/Z|[+-]\d\d(?::?\d\d)?/,Sa=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],mb=

[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],uc=/^\/?Date\((\-?\d+)/i,rc=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,sc={UT:0,GMT:0,EDT:-240,

EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};l.createFromInputFallback=L("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(a){a._d=new Date(a._i+(a._useUTC?" UTC":""))});l.ISO_8601=function(){};

l.RFC_2822=function(){};var Gc=L("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var a=U.apply(null,arguments);return this.isValid()&&a.isValid()?a<this?this:a:q()}),Hc=L("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var a=U.apply(null,arguments);return this.isValid()&&a.isValid()?a>this?this:a:q()}),La="year quarter month week day hour minute second millisecond".split(" ");

Pb("Z",":");Pb("ZZ","");E("Z",ab);E("ZZ",ab);S(["Z","ZZ"],function(a,c,d){d._useUTC=!0;d._tzm=qb(ab,a)});var xc=/([\+\-]|\d\d)/gi;l.updateOffset=function(){};var yc=/^(\-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,zc=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;ka.fn=Ta.prototype;ka.invalid=function(){return ka(NaN)};var Ic=Sb(1,"add"),Jc=Sb(-1,"subtract");l.defaultFormat=

"YYYY-MM-DDTHH:mm:ssZ";l.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var gc=L("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(a){return void 0===a?this.localeData():this.locale(a)});D(0,["gg",2],0,function(){return this.weekYear()%100});D(0,["GG",2],0,function(){return this.isoWeekYear()%100});Ua("gggg","weekYear");Ua("ggggg","weekYear");Ua("GGGG","isoWeekYear");Ua("GGGGG","isoWeekYear");I("weekYear",

"gg");I("isoWeekYear","GG");da.weekYear=1;da.isoWeekYear=1;E("G",$a);E("g",$a);E("GG",T,fa);E("gg",T,fa);E("GGGG",wb,vb);E("gggg",wb,vb);E("GGGGG",Za,Xa);E("ggggg",Za,Xa);Ha(["gggg","ggggg","GGGG","GGGGG"],function(a,c,d,e){c[e.substr(0,2)]=A(a)});Ha(["gg","GG"],function(a,c,d,e){c[e]=l.parseTwoDigitYear(a)});D("Q",0,"Qo","quarter");I("quarter","Q");da.quarter=7;E("Q",ac);S("Q",function(a,c){c[oa]=3*(A(a)-1)});D("D",["DD",2],"Do","date");I("date","D");da.date=9;E("D",T);E("DD",T,fa);E("Do",function(a,

c){return a?c._dayOfMonthOrdinalParse||c._ordinalParse:c._dayOfMonthOrdinalParseLenient});S(["D","DD"],ma);S("Do",function(a,c){c[ma]=A(a.match(T)[0])});var hc=Ca("Date",!0);D("DDD",["DDDD",3],"DDDo","dayOfYear");I("dayOfYear","DDD");da.dayOfYear=4;E("DDD",Ya);E("DDDD",bc);S(["DDD","DDDD"],function(a,c,d){d._dayOfYear=A(a)});D("m",["mm",2],0,"minute");I("minute","m");da.minute=14;E("m",T);E("mm",T,fa);S(["m","mm"],ja);var Kc=Ca("Minutes",!1);D("s",["ss",2],0,"second");I("second","s");da.second=15;

E("s",T);E("ss",T,fa);S(["s","ss"],pa);var Lc=Ca("Seconds",!1);D("S",0,0,function(){return~~(this.millisecond()/100)});D(0,["SS",2],0,function(){return~~(this.millisecond()/10)});D(0,["SSS",3],0,"millisecond");D(0,["SSSS",4],0,function(){return 10*this.millisecond()});D(0,["SSSSS",5],0,function(){return 100*this.millisecond()});D(0,["SSSSSS",6],0,function(){return 1E3*this.millisecond()});D(0,["SSSSSSS",7],0,function(){return 1E4*this.millisecond()});D(0,["SSSSSSSS",8],0,function(){return 1E5*this.millisecond()});

D(0,["SSSSSSSSS",9],0,function(){return 1E6*this.millisecond()});I("millisecond","ms");da.millisecond=16;E("S",Ya,ac);E("SS",Ya,fa);E("SSS",Ya,bc);var ua;for(ua="SSSS";9>=ua.length;ua+="S")E(ua,Dc);for(ua="S";9>=ua.length;ua+="S")S(ua,Ac);var Mc=Ca("Milliseconds",!1);D("z",0,0,"zoneAbbr");D("zz",0,0,"zoneName");var B=y.prototype;B.add=Ic;B.calendar=function(a,c){var d=a||U(),e=rb(d,this).startOf("day");e=l.calendarFormat(this,e)||"sameElse";var k=c&&(J(c[e])?c[e].call(this,d):c[e]);return this.format(k||

this.localeData().calendar(e,this,U(d)))};B.clone=function(){return new y(this)};B.diff=function(a,c,d){if(!this.isValid())return NaN;a=rb(a,this);if(!a.isValid())return NaN;var e=6E4*(a.utcOffset()-this.utcOffset());c=H(c);switch(c){case "year":c=sb(this,a)/12;break;case "month":c=sb(this,a);break;case "quarter":c=sb(this,a)/3;break;case "second":c=(this-a)/1E3;break;case "minute":c=(this-a)/6E4;break;case "hour":c=(this-a)/36E5;break;case "day":c=(this-a-e)/864E5;break;case "week":c=(this-a-e)/

6048E5;break;default:c=this-a}return d?c:F(c)};B.endOf=function(a){a=H(a);if(void 0===a||"millisecond"===a)return this;"date"===a&&(a="day");return this.startOf(a).add(1,"isoWeek"===a?"week":a).subtract(1,"ms")};B.format=function(a){a||(a=this.isUtc()?l.defaultFormatUtc:l.defaultFormat);a=ca(this,a);return this.localeData().postformat(a)};B.from=function(a,c){return this.isValid()&&(w(a)&&a.isValid()||U(a).isValid())?ka({to:this,from:a}).locale(this.locale()).humanize(!c):this.localeData().invalidDate()};

B.fromNow=function(a){return this.from(U(),a)};B.to=function(a,c){return this.isValid()&&(w(a)&&a.isValid()||U(a).isValid())?ka({from:this,to:a}).locale(this.locale()).humanize(!c):this.localeData().invalidDate()};B.toNow=function(a){return this.to(U(),a)};B.get=function(a){a=H(a);return J(this[a])?this[a]():this};B.invalidAt=function(){return m(this).overflow};B.isAfter=function(c,d){var e=w(c)?c:U(c);if(!this.isValid()||!e.isValid())return!1;d=H(a(d)?"millisecond":d);return"millisecond"===d?this.valueOf()>

e.valueOf():e.valueOf()<this.clone().startOf(d).valueOf()};B.isBefore=function(c,d){var e=w(c)?c:U(c);if(!this.isValid()||!e.isValid())return!1;d=H(a(d)?"millisecond":d);return"millisecond"===d?this.valueOf()<e.valueOf():this.clone().endOf(d).valueOf()<e.valueOf()};B.isBetween=function(a,c,d,e){e=e||"()";return("("===e[0]?this.isAfter(a,d):!this.isBefore(a,d))&&(")"===e[1]?this.isBefore(c,d):!this.isAfter(c,d))};B.isSame=function(a,c){var d=w(a)?a:U(a);if(!this.isValid()||!d.isValid())return!1;c=

H(c||"millisecond");if("millisecond"===c)return this.valueOf()===d.valueOf();d=d.valueOf();return this.clone().startOf(c).valueOf()<=d&&d<=this.clone().endOf(c).valueOf()};B.isSameOrAfter=function(a,c){return this.isSame(a,c)||this.isAfter(a,c)};B.isSameOrBefore=function(a,c){return this.isSame(a,c)||this.isBefore(a,c)};B.isValid=function(){return p(this)};B.lang=gc;B.locale=Ub;B.localeData=Vb;B.max=Hc;B.min=Gc;B.parsingFlags=function(){return C({},m(this))};B.set=function(a,c){if("object"===typeof a){a=

N(a);for(var d=Q(a),e=0;e<d.length;e++)this[d[e].unit](a[d[e].unit])}else if(a=H(a),J(this[a]))return this[a](c);return this};B.startOf=function(a){a=H(a);switch(a){case "year":this.month(0);case "quarter":case "month":this.date(1);case "week":case "isoWeek":case "day":case "date":this.hours(0);case "hour":this.minutes(0);case "minute":this.seconds(0);case "second":this.milliseconds(0)}"week"===a&&this.weekday(0);"isoWeek"===a&&this.isoWeekday(1);"quarter"===a&&this.month(3*Math.floor(this.month()/

3));return this};B.subtract=Jc;B.toArray=function(){return[this.year(),this.month(),this.date(),this.hour(),this.minute(),this.second(),this.millisecond()]};B.toObject=function(){return{years:this.year(),months:this.month(),date:this.date(),hours:this.hours(),minutes:this.minutes(),seconds:this.seconds(),milliseconds:this.milliseconds()}};B.toDate=function(){return new Date(this.valueOf())};B.toISOString=function(a){if(!this.isValid())return null;var c=(a=!0!==a)?this.clone().utc():this;return 0>

c.year()||9999<c.year()?ca(c,a?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):J(Date.prototype.toISOString)?a?this.toDate().toISOString():(new Date(this._d.valueOf())).toISOString().replace("Z",ca(c,"Z")):ca(c,a?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")};B.inspect=function(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var a="moment",c="";this.isLocal()||(a=0===this.utcOffset()?"moment.utc":"moment.parseZone",c="Z");a="["+a+'("]';var d=0<=this.year()&&

9999>=this.year()?"YYYY":"YYYYYY";return this.format(a+d+"-MM-DD[T]HH:mm:ss.SSS"+(c+'[")]'))};B.toJSON=function(){return this.isValid()?this.toISOString():null};B.toString=function(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")};B.unix=function(){return Math.floor(this.valueOf()/1E3)};B.valueOf=function(){return this._d.valueOf()-6E4*(this._offset||0)};B.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}};

B.year=ec;B.isLeapYear=function(){return ra(this.year())};B.weekYear=function(a){return Wb.call(this,a,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)};B.isoWeekYear=function(a){return Wb.call(this,a,this.isoWeek(),this.isoWeekday(),1,4)};B.quarter=B.quarters=function(a){return null==a?Math.ceil((this.month()+1)/3):this.month(3*(a-1)+this.month()%3)};B.month=Cb;B.daysInMonth=function(){return Pa(this.year(),this.month())};B.week=B.weeks=function(a){var c=this.localeData().week(this);

return null==a?c:this.add(7*(a-c),"d")};B.isoWeek=B.isoWeeks=function(a){var c=Ja(this,1,4).week;return null==a?c:this.add(7*(a-c),"d")};B.weeksInYear=function(){var a=this.localeData()._week;return xa(this.year(),a.dow,a.doy)};B.isoWeeksInYear=function(){return xa(this.year(),1,4)};B.date=hc;B.day=B.days=function(a){if(!this.isValid())return null!=a?this:NaN;var c=this._isUTC?this._d.getUTCDay():this._d.getDay();if(null!=a){var d=this.localeData();"string"===typeof a&&(isNaN(a)?(a=d.weekdaysParse(a),

a="number"===typeof a?a:null):a=parseInt(a,10));return this.add(a-c,"d")}return c};B.weekday=function(a){if(!this.isValid())return null!=a?this:NaN;var c=(this.day()+7-this.localeData()._week.dow)%7;return null==a?c:this.add(a-c,"d")};B.isoWeekday=function(a){if(!this.isValid())return null!=a?this:NaN;if(null!=a){var c=this.localeData();a="string"===typeof a?c.weekdaysParse(a)%7||7:isNaN(a)?null:a;return this.day(this.day()%7?a:a-7)}return this.day()||7};B.dayOfYear=function(a){var c=Math.round((this.clone().startOf("day")-

this.clone().startOf("year"))/864E5)+1;return null==a?c:this.add(a-c,"d")};B.hour=B.hours=Fc;B.minute=B.minutes=Kc;B.second=B.seconds=Lc;B.millisecond=B.milliseconds=Mc;B.utcOffset=function(a,c,d){var e=this._offset||0,k;if(!this.isValid())return null!=a?this:NaN;if(null!=a){if("string"===typeof a){if(a=qb(ab,a),null===a)return this}else 16>Math.abs(a)&&!d&&(a*=60);!this._isUTC&&c&&(k=15*-Math.round(this._d.getTimezoneOffset()/15));this._offset=a;this._isUTC=!0;null!=k&&this.add(k,"m");e!==a&&(!c||

this._changeInProgress?Tb(this,ka(a-e,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,l.updateOffset(this,!0),this._changeInProgress=null));return this}return this._isUTC?e:15*-Math.round(this._d.getTimezoneOffset()/15)};B.utc=function(a){return this.utcOffset(0,a)};B.local=function(a){this._isUTC&&(this.utcOffset(0,a),this._isUTC=!1,a&&this.subtract(15*-Math.round(this._d.getTimezoneOffset()/15),"m"));return this};B.parseZone=function(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,

!0);else if("string"===typeof this._i){var a=qb(Ec,this._i);null!=a?this.utcOffset(a):this.utcOffset(0,!0)}return this};B.hasAlignedHourOffset=function(a){if(!this.isValid())return!1;a=a?U(a).utcOffset():0;return 0===(this.utcOffset()-a)%60};B.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()};B.isLocal=function(){return this.isValid()?!this._isUTC:!1};B.isUtcOffset=function(){return this.isValid()?this._isUTC:!1};B.isUtc=

Qb;B.isUTC=Qb;B.zoneAbbr=function(){return this._isUTC?"UTC":""};B.zoneName=function(){return this._isUTC?"Coordinated Universal Time":""};B.dates=L("dates accessor is deprecated. Use date instead.",hc);B.months=L("months accessor is deprecated. Use month instead",Cb);B.years=L("years accessor is deprecated. Use year instead",ec);B.zone=L("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",function(a,c){return null!=a?("string"!==typeof a&&(a=

-a),this.utcOffset(a,c),this):-this.utcOffset()});B.isDSTShifted=L("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",function(){if(!a(this._isDSTShifted))return this._isDSTShifted;var c={};x(c,this);c=Nb(c);if(c._a){var d=c._isUTC?v(c._a):U(c._a);this._isDSTShifted=this.isValid()&&0<K(c._a,d.toArray())}else this._isDSTShifted=!1;return this._isDSTShifted});var R=G.prototype;R.calendar=function(a,c,d){a=this._calendar[a]||this._calendar.sameElse;

return J(a)?a.call(c,d):a};R.longDateFormat=function(a){var c=this._longDateFormat[a],d=this._longDateFormat[a.toUpperCase()];if(c||!d)return c;this._longDateFormat[a]=d.replace(/MMMM|MM|DD|dddd/g,function(a){return a.slice(1)});return this._longDateFormat[a]};R.invalidDate=function(){return this._invalidDate};R.ordinal=function(a){return this._ordinal.replace("%d",a)};R.preparse=Xb;R.postformat=Xb;R.relativeTime=function(a,c,d,e){var k=this._relativeTime[d];return J(k)?k(a,c,d,e):k.replace(/%d/i,

a)};R.pastFuture=function(a,c){var d=this._relativeTime[0<a?"future":"past"];return J(d)?d(c):d.replace(/%s/i,c)};R.set=function(a){var c;for(c in a){var d=a[c];J(d)?this[c]=d:this["_"+c]=d}this._config=a;this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)};R.months=function(a,c){return a?h(this._months)?this._months[a.month()]:this._months[(this._months.isFormat||fc).test(c)?"format":"standalone"][a.month()]:h(this._months)?

this._months:this._months.standalone};R.monthsShort=function(a,c){return a?h(this._monthsShort)?this._monthsShort[a.month()]:this._monthsShort[fc.test(c)?"format":"standalone"][a.month()]:h(this._monthsShort)?this._monthsShort:this._monthsShort.standalone};R.monthsParse=function(a,c,d){var e;if(this._monthsParseExact){a:{a=a.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],e=0;12>e;++e){var k=v([2E3,e]);this._shortMonthsParse[e]=

this.monthsShort(k,"").toLocaleLowerCase();this._longMonthsParse[e]=this.months(k,"").toLocaleLowerCase()}if(d)c="MMM"===c?Y.call(this._shortMonthsParse,a):Y.call(this._longMonthsParse,a);else if("MMM"===c){c=Y.call(this._shortMonthsParse,a);if(-1!==c)break a;c=Y.call(this._longMonthsParse,a)}else{c=Y.call(this._longMonthsParse,a);if(-1!==c)break a;c=Y.call(this._shortMonthsParse,a)}c=-1!==c?c:null}return c}this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]);

for(e=0;12>e;e++)if(k=v([2E3,e]),d&&!this._longMonthsParse[e]&&(this._longMonthsParse[e]=new RegExp("^"+this.months(k,"").replace(".","")+"$","i"),this._shortMonthsParse[e]=new RegExp("^"+this.monthsShort(k,"").replace(".","")+"$","i")),d||this._monthsParse[e]||(k="^"+this.months(k,"")+"|^"+this.monthsShort(k,""),this._monthsParse[e]=new RegExp(k.replace(".",""),"i")),d&&"MMMM"===c&&this._longMonthsParse[e].test(a)||d&&"MMM"===c&&this._shortMonthsParse[e].test(a)||!d&&this._monthsParse[e].test(a))return e};

R.monthsRegex=function(a){if(this._monthsParseExact)return k(this,"_monthsRegex")||Db.call(this),a?this._monthsStrictRegex:this._monthsRegex;k(this,"_monthsRegex")||(this._monthsRegex=Ma);return this._monthsStrictRegex&&a?this._monthsStrictRegex:this._monthsRegex};R.monthsShortRegex=function(a){if(this._monthsParseExact)return k(this,"_monthsRegex")||Db.call(this),a?this._monthsShortStrictRegex:this._monthsShortRegex;k(this,"_monthsShortRegex")||(this._monthsShortRegex=Ma);return this._monthsShortStrictRegex&&

a?this._monthsShortStrictRegex:this._monthsShortRegex};R.week=function(a){return Ja(a,this._week.dow,this._week.doy).week};R.firstDayOfYear=function(){return this._week.doy};R.firstDayOfWeek=function(){return this._week.dow};R.weekdays=function(a,c){return a?h(this._weekdays)?this._weekdays[a.day()]:this._weekdays[this._weekdays.isFormat.test(c)?"format":"standalone"][a.day()]:h(this._weekdays)?this._weekdays:this._weekdays.standalone};R.weekdaysMin=function(a){return a?this._weekdaysMin[a.day()]:

this._weekdaysMin};R.weekdaysShort=function(a){return a?this._weekdaysShort[a.day()]:this._weekdaysShort};R.weekdaysParse=function(a,c,d){var e;if(this._weekdaysParseExact)return lc.call(this,a,c,d);this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]);for(e=0;7>e;e++){var k=v([2E3,1]).day(e);d&&!this._fullWeekdaysParse[e]&&(this._fullWeekdaysParse[e]=new RegExp("^"+this.weekdays(k,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[e]=

new RegExp("^"+this.weekdaysShort(k,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[e]=new RegExp("^"+this.weekdaysMin(k,"").replace(".",".?")+"$","i"));this._weekdaysParse[e]||(k="^"+this.weekdays(k,"")+"|^"+this.weekdaysShort(k,"")+"|^"+this.weekdaysMin(k,""),this._weekdaysParse[e]=new RegExp(k.replace(".",""),"i"));if(d&&"dddd"===c&&this._fullWeekdaysParse[e].test(a)||d&&"ddd"===c&&this._shortWeekdaysParse[e].test(a)||d&&"dd"===c&&this._minWeekdaysParse[e].test(a)||!d&&this._weekdaysParse[e].test(a))return e}};

R.weekdaysRegex=function(a){if(this._weekdaysParseExact)return k(this,"_weekdaysRegex")||gb.call(this),a?this._weekdaysStrictRegex:this._weekdaysRegex;k(this,"_weekdaysRegex")||(this._weekdaysRegex=Ma);return this._weekdaysStrictRegex&&a?this._weekdaysStrictRegex:this._weekdaysRegex};R.weekdaysShortRegex=function(a){if(this._weekdaysParseExact)return k(this,"_weekdaysRegex")||gb.call(this),a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex;k(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=

Ma);return this._weekdaysShortStrictRegex&&a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex};R.weekdaysMinRegex=function(a){if(this._weekdaysParseExact)return k(this,"_weekdaysRegex")||gb.call(this),a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex;k(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=Ma);return this._weekdaysMinStrictRegex&&a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex};R.isPM=function(a){return"p"===(a+"").toLowerCase().charAt(0)};R.meridiem=function(a,c,d){return 11<

a?d?"pm":"PM":d?"am":"AM"};Da("en",{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(a){var c=a%10;c=1===A(a%100/10)?"th":1===c?"st":2===c?"nd":3===c?"rd":"th";return a+c}});l.lang=L("moment.lang is deprecated. Use moment.locale instead.",Da);l.langData=L("moment.langData is deprecated. Use moment.localeData instead.",sa);var qa=Math.abs,Nc=ta("ms"),Oc=ta("s"),Pc=ta("m"),Qc=ta("h"),Rc=ta("d"),Sc=ta("w"),Tc=ta("M"),Uc=ta("y"),Vc=Aa("milliseconds"),Wc=Aa("seconds"),Xc=Aa("minutes"),Yc=

Aa("hours"),Zc=Aa("days"),$c=Aa("months"),ad=Aa("years"),va=Math.round,na={ss:44,s:45,m:45,h:22,d:26,M:11},ub=Math.abs,O=Ta.prototype;O.isValid=function(){return this._isValid};O.abs=function(){var a=this._data;this._milliseconds=qa(this._milliseconds);this._days=qa(this._days);this._months=qa(this._months);a.milliseconds=qa(a.milliseconds);a.seconds=qa(a.seconds);a.minutes=qa(a.minutes);a.hours=qa(a.hours);a.months=qa(a.months);a.years=qa(a.years);return this};O.add=function(a,c){return Zb(this,

a,c,1)};O.subtract=function(a,c){return Zb(this,a,c,-1)};O.as=function(a){if(!this.isValid())return NaN;var c=this._milliseconds;a=H(a);if("month"===a||"year"===a){var d=this._days+c/864E5;d=this._months+4800*d/146097;return"month"===a?d:d/12}d=this._days+Math.round(146097*this._months/4800);switch(a){case "week":return d/7+c/6048E5;case "day":return d+c/864E5;case "hour":return 24*d+c/36E5;case "minute":return 1440*d+c/6E4;case "second":return 86400*d+c/1E3;case "millisecond":return Math.floor(864E5*

d)+c;default:throw Error("Unknown unit "+a);}};O.asMilliseconds=Nc;O.asSeconds=Oc;O.asMinutes=Pc;O.asHours=Qc;O.asDays=Rc;O.asWeeks=Sc;O.asMonths=Tc;O.asYears=Uc;O.valueOf=function(){return this.isValid()?this._milliseconds+864E5*this._days+this._months%12*2592E6+31536E6*A(this._months/12):NaN};O._bubble=function(){var a=this._milliseconds,c=this._days,d=this._months,e=this._data;0<=a&&0<=c&&0<=d||0>=a&&0>=c&&0>=d||(a+=864E5*$b(146097*d/4800+c),d=c=0);e.milliseconds=a%1E3;a=F(a/1E3);e.seconds=a%60;

a=F(a/60);e.minutes=a%60;a=F(a/60);e.hours=a%24;c+=F(a/24);a=F(4800*c/146097);d+=a;c-=$b(146097*a/4800);a=F(d/12);e.days=c;e.months=d%12;e.years=a;return this};O.clone=function(){return ka(this)};O.get=function(a){a=H(a);return this.isValid()?this[a+"s"]():NaN};O.milliseconds=Vc;O.seconds=Wc;O.minutes=Xc;O.hours=Yc;O.days=Zc;O.weeks=function(){return F(this.days()/7)};O.months=$c;O.years=ad;O.humanize=function(a){if(!this.isValid())return this.localeData().invalidDate();var c=this.localeData();var d=

!a;var e=ka(this).abs(),k=va(e.as("s")),m=va(e.as("m")),h=va(e.as("h")),f=va(e.as("d")),q=va(e.as("M"));e=va(e.as("y"));k=k<=na.ss&&["s",k]||k<na.s&&["ss",k]||1>=m&&["m"]||m<na.m&&["mm",m]||1>=h&&["h"]||h<na.h&&["hh",h]||1>=f&&["d"]||f<na.d&&["dd",f]||1>=q&&["M"]||q<na.M&&["MM",q]||1>=e&&["y"]||["yy",e];k[2]=d;k[3]=0<+this;k[4]=c;d=Bc.apply(null,k);a&&(d=c.pastFuture(+this,d));return c.postformat(d)};O.toISOString=Wa;O.toString=Wa;O.toJSON=Wa;O.locale=Ub;O.localeData=Vb;O.toIsoString=L("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",

Wa);O.lang=gc;D("X",0,0,"unix");D("x",0,0,"valueOf");E("x",$a);E("X",/[+-]?\d+(\.\d{1,3})?/);S("X",function(a,c,d){d._d=new Date(1E3*parseFloat(a,10))});S("x",function(a,c,d){d._d=new Date(A(a))});l.version="2.20.1";var ic=U;l.fn=B;l.min=function(){var a=[].slice.call(arguments,0);return Ob("isBefore",a)};l.max=function(){var a=[].slice.call(arguments,0);return Ob("isAfter",a)};l.now=function(){return Date.now?Date.now():+new Date};l.utc=v;l.unix=function(a){return U(1E3*a)};l.months=function(a,c){return Yb(a,

c,"months")};l.isDate=d;l.locale=Da;l.invalid=q;l.duration=ka;l.isMoment=w;l.weekdays=function(a,c,d){return tb(a,c,d,"weekdays")};l.parseZone=function(){return U.apply(null,arguments).parseZone()};l.localeData=sa;l.isDuration=ob;l.monthsShort=function(a,c){return Yb(a,c,"monthsShort")};l.weekdaysMin=function(a,c,d){return tb(a,c,d,"weekdaysMin")};l.defineLocale=jb;l.updateLocale=function(a,c){if(null!=c){var d=Ib;var e=ib(a);null!=e&&(d=e._config);c=W(d,c);e=new G(c);e.parentLocale=Z[a];Z[a]=e;Da(a)}else null!=

Z[a]&&(null!=Z[a].parentLocale?Z[a]=Z[a].parentLocale:null!=Z[a]&&delete Z[a]);return Z[a]};l.locales=function(){return Cc(Z)};l.weekdaysShort=function(a,c,d){return tb(a,c,d,"weekdaysShort")};l.normalizeUnits=H;l.relativeTimeRounding=function(a){return void 0===a?va:"function"===typeof a?(va=a,!0):!1};l.relativeTimeThreshold=function(a,c){if(void 0===na[a])return!1;if(void 0===c)return na[a];na[a]=c;"s"===a&&(na.ss=c-1);return!0};l.calendarFormat=function(a,c){var d=a.diff(c,"days",!0);return-6>

d?"sameElse":-1>d?"lastWeek":0>d?"lastDay":1>d?"sameDay":2>d?"nextDay":7>d?"nextWeek":"sameElse"};l.prototype=B;l.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"YYYY-[W]WW",MONTH:"YYYY-MM"};return l})},{}],7:[function(n,u,t){t=n(29)();t.helpers=n(45);n(27)(t);t.defaults=n(25);t.Element=n(26);t.elements=n(40);t.Interaction=n(28);

t.layouts=n(30);t.platform=n(48);t.plugins=n(31);t.Ticks=n(34);n(22)(t);n(23)(t);n(24)(t);n(33)(t);n(32)(t);n(35)(t);n(55)(t);n(53)(t);n(54)(t);n(56)(t);n(57)(t);n(58)(t);n(15)(t);n(16)(t);n(17)(t);n(18)(t);n(19)(t);n(20)(t);n(21)(t);n(8)(t);n(9)(t);n(10)(t);n(11)(t);n(12)(t);n(13)(t);n(14)(t);n=n(49);for(var l in n)n.hasOwnProperty(l)&&t.plugins.register(n[l]);t.platform.initialize();u.exports=t;"undefined"!==typeof window&&(window.Chart=t);t.Legend=n.legend._element;t.Title=n.title._element;t.pluginService=

t.plugins;t.PluginBase=t.Element.extend({});t.canvasHelpers=t.helpers.canvas;t.layoutService=t.layouts},{10:10,11:11,12:12,13:13,14:14,15:15,16:16,17:17,18:18,19:19,20:20,21:21,22:22,23:23,24:24,25:25,26:26,27:27,28:28,29:29,30:30,31:31,32:32,33:33,34:34,35:35,40:40,45:45,48:48,49:49,53:53,54:54,55:55,56:56,57:57,58:58,8:8,9:9}],8:[function(n,u,t){u.exports=function(l){l.Bar=function(h,f){f.type="bar";return new l(h,f)}}},{}],9:[function(n,u,t){u.exports=function(l){l.Bubble=function(h,f){f.type=

"bubble";return new l(h,f)}}},{}],10:[function(n,u,t){u.exports=function(l){l.Doughnut=function(h,f){f.type="doughnut";return new l(h,f)}}},{}],11:[function(n,u,t){u.exports=function(l){l.Line=function(h,f){f.type="line";return new l(h,f)}}},{}],12:[function(n,u,t){u.exports=function(l){l.PolarArea=function(h,f){f.type="polarArea";return new l(h,f)}}},{}],13:[function(n,u,t){u.exports=function(l){l.Radar=function(h,f){f.type="radar";return new l(h,f)}}},{}],14:[function(n,u,t){u.exports=function(l){l.Scatter=

function(h,f){f.type="scatter";return new l(h,f)}}},{}],15:[function(n,u,t){t=n(25);var l=n(40),h=n(45);t._set("bar",{hover:{mode:"label"},scales:{xAxes:[{type:"category",categoryPercentage:.8,barPercentage:.9,offset:!0,gridLines:{offsetGridLines:!0}}],yAxes:[{type:"linear"}]}});t._set("horizontalBar",{hover:{mode:"index",axis:"y"},scales:{xAxes:[{type:"linear",position:"bottom"}],yAxes:[{position:"left",type:"category",categoryPercentage:.8,barPercentage:.9,offset:!0,gridLines:{offsetGridLines:!0}}]},

elements:{rectangle:{borderSkipped:"left"}},tooltips:{callbacks:{title:function(h,a){var e="";0<h.length&&(h[0].yLabel?e=h[0].yLabel:0<a.labels.length&&h[0].index<a.labels.length&&(e=a.labels[h[0].index]));return e},label:function(h,a){return(a.datasets[h.datasetIndex].label||"")+": "+h.xLabel}},mode:"index",axis:"y"}});u.exports=function(f){f.controllers.bar=f.DatasetController.extend({dataElementType:l.Rectangle,initialize:function(){f.DatasetController.prototype.initialize.apply(this,arguments);

var a=this.getMeta();a.stack=this.getDataset().stack;a.bar=!0},update:function(a){var e=this.getMeta().data,d;this._ruler=this.getRuler();var c=0;for(d=e.length;c<d;++c)this.updateElement(e[c],c,a)},updateElement:function(a,e,d){var c=this.chart,k=this.getMeta(),f=this.getDataset(),v=a.custom||{},m=c.options.elements.rectangle;a._xScale=this.getScaleForId(k.xAxisID);a._yScale=this.getScaleForId(k.yAxisID);a._datasetIndex=this.index;a._index=e;a._model={datasetLabel:f.label,label:c.data.labels[e],

borderSkipped:v.borderSkipped?v.borderSkipped:m.borderSkipped,backgroundColor:v.backgroundColor?v.backgroundColor:h.valueAtIndexOrDefault(f.backgroundColor,e,m.backgroundColor),borderColor:v.borderColor?v.borderColor:h.valueAtIndexOrDefault(f.borderColor,e,m.borderColor),borderWidth:v.borderWidth?v.borderWidth:h.valueAtIndexOrDefault(f.borderWidth,e,m.borderWidth)};this.updateElementGeometry(a,e,d);a.pivot()},updateElementGeometry:function(a,e,d){a=a._model;var c=this.getValueScale(),k=c.getBasePixel();

c=c.isHorizontal();var h=this._ruler||this.getRuler(),f=this.calculateBarValuePixels(this.index,e);e=this.calculateBarIndexPixels(this.index,e,h);a.horizontal=c;a.base=d?k:f.base;a.x=c?d?k:f.head:e.center;a.y=c?e.center:d?k:f.head;a.height=c?e.size:void 0;a.width=c?void 0:e.size},getValueScaleId:function(){return this.getMeta().yAxisID},getIndexScaleId:function(){return this.getMeta().xAxisID},getValueScale:function(){return this.getScaleForId(this.getValueScaleId())},getIndexScale:function(){return this.getScaleForId(this.getIndexScaleId())},

_getStacks:function(a){var e=this.chart,d=this.getIndexScale().options.stacked;a=void 0===a?e.data.datasets.length:a+1;var c=[],k;for(k=0;k<a;++k){var h=e.getDatasetMeta(k);h.bar&&e.isDatasetVisible(k)&&(!1===d||!0===d&&-1===c.indexOf(h.stack)||void 0===d&&(void 0===h.stack||-1===c.indexOf(h.stack)))&&c.push(h.stack)}return c},getStackCount:function(){return this._getStacks().length},getStackIndex:function(a,e){var d=this._getStacks(a),c=void 0!==e?d.indexOf(e):-1;return-1===c?d.length-1:c},getRuler:function(){var a=

this.getIndexScale(),e=this.getStackCount(),d=this.index,c=a.isHorizontal(),k=c?a.left:a.top;c=k+(c?a.width:a.height);var f=[],v;var m=0;for(v=this.getMeta().data.length;m<v;++m)f.push(a.getPixelForValue(null,m,d));if(h.isNullOrUndef(a.options.barThickness)){d=a.isHorizontal()?a.width:a.height;var p=a.getTicks();m=1;for(v=f.length;m<v;++m)d=Math.min(d,f[m]-f[m-1]);m=0;for(v=p.length;m<v;++m){p=a.getPixelForTick(m);d=0<m?Math.min(d,p-q):d;var q=p}q=d}else q=-1;return{min:q,pixels:f,start:k,end:c,stackCount:e,

scale:a}},calculateBarValuePixels:function(a,e){var d=this.chart,c=this.getMeta(),k=this.getValueScale(),h=d.data.datasets,f=k.getRightValue(h[a].data[e]),m=k.options.stacked,p=c.stack;c=0;if(m||void 0===m&&void 0!==p)for(m=0;m<a;++m){var q=d.getDatasetMeta(m);q.bar&&q.stack===p&&q.controller.getValueScaleId()===k.id&&d.isDatasetVisible(m)&&(q=k.getRightValue(h[m].data[e]),0>f&&0>q||0<=f&&0<q)&&(c+=q)}d=k.getPixelForValue(c);k=k.getPixelForValue(c+f);f=(k-d)/2;return{size:f,base:d,head:k,center:k+

f/2}},calculateBarIndexPixels:function(a,e,d){var c=d.scale.options;if("flex"===c.barThickness){var k=d.pixels,f=k[e],v=0<e?k[e-1]:null;e=e<k.length-1?k[e+1]:null;k=c.categoryPercentage;null===v&&(v=f-(null===e?d.end-f:e-f));null===e&&(e=f+f-v);d={chunk:(e-v)/2*k/d.stackCount,ratio:c.barPercentage,start:f-(f-v)/2*k}}else v=c.barThickness,f=d.stackCount,e=d.pixels[e],h.isNullOrUndef(v)?(d=d.min*c.categoryPercentage,v=c.barPercentage):(d=v*f,v=1),d={chunk:d/f,ratio:v,start:e-d/2};a=this.getStackIndex(a,

this.getMeta().stack);a=d.start+d.chunk*a+d.chunk/2;c=Math.min(h.valueOrDefault(c.maxBarThickness,Infinity),d.chunk*d.ratio);return{base:a-c/2,head:a+c/2,center:a,size:c}},draw:function(){var a=this.chart,e=this.getValueScale(),d=this.getMeta().data,c=this.getDataset(),k=d.length,f=0;for(h.canvas.clipArea(a.ctx,a.chartArea);f<k;++f)isNaN(e.getRightValue(c.data[f]))||d[f].draw();h.canvas.unclipArea(a.ctx)},setHoverStyle:function(a){var e=this.chart.data.datasets[a._datasetIndex],d=a._index,c=a.custom||

{};a=a._model;a.backgroundColor=c.hoverBackgroundColor?c.hoverBackgroundColor:h.valueAtIndexOrDefault(e.hoverBackgroundColor,d,h.getHoverColor(a.backgroundColor));a.borderColor=c.hoverBorderColor?c.hoverBorderColor:h.valueAtIndexOrDefault(e.hoverBorderColor,d,h.getHoverColor(a.borderColor));a.borderWidth=c.hoverBorderWidth?c.hoverBorderWidth:h.valueAtIndexOrDefault(e.hoverBorderWidth,d,a.borderWidth)},removeHoverStyle:function(a){var e=this.chart.data.datasets[a._datasetIndex],d=a._index,c=a.custom||

{};a=a._model;var k=this.chart.options.elements.rectangle;a.backgroundColor=c.backgroundColor?c.backgroundColor:h.valueAtIndexOrDefault(e.backgroundColor,d,k.backgroundColor);a.borderColor=c.borderColor?c.borderColor:h.valueAtIndexOrDefault(e.borderColor,d,k.borderColor);a.borderWidth=c.borderWidth?c.borderWidth:h.valueAtIndexOrDefault(e.borderWidth,d,k.borderWidth)}});f.controllers.horizontalBar=f.controllers.bar.extend({getValueScaleId:function(){return this.getMeta().xAxisID},getIndexScaleId:function(){return this.getMeta().yAxisID}})}},

{25:25,40:40,45:45}],16:[function(n,u,t){t=n(25);var l=n(40),h=n(45);t._set("bubble",{hover:{mode:"single"},scales:{xAxes:[{type:"linear",position:"bottom",id:"x-axis-0"}],yAxes:[{type:"linear",position:"left",id:"y-axis-0"}]},tooltips:{callbacks:{title:function(){return""},label:function(h,a){return(a.datasets[h.datasetIndex].label||"")+": ("+h.xLabel+", "+h.yLabel+", "+a.datasets[h.datasetIndex].data[h.index].r+")"}}}});u.exports=function(f){f.controllers.bubble=f.DatasetController.extend({dataElementType:l.Point,

update:function(a){var e=this,d=e.getMeta().data;h.each(d,function(c,d){e.updateElement(c,d,a)})},updateElement:function(a,e,d){var c=this.getMeta(),k=a.custom||{},h=this.getScaleForId(c.xAxisID);c=this.getScaleForId(c.yAxisID);var f=this._resolveElementOptions(a,e),m=this.getDataset().data[e],p=this.index,q=d?h.getPixelForDecimal(.5):h.getPixelForValue("object"===typeof m?m:NaN,e,p);m=d?c.getBasePixel():c.getPixelForValue(m,e,p);a._xScale=h;a._yScale=c;a._options=f;a._datasetIndex=p;a._index=e;a._model=

{backgroundColor:f.backgroundColor,borderColor:f.borderColor,borderWidth:f.borderWidth,hitRadius:f.hitRadius,pointStyle:f.pointStyle,radius:d?0:f.radius,skip:k.skip||isNaN(q)||isNaN(m),x:q,y:m};a.pivot()},setHoverStyle:function(a){var e=a._model;a=a._options;e.backgroundColor=h.valueOrDefault(a.hoverBackgroundColor,h.getHoverColor(a.backgroundColor));e.borderColor=h.valueOrDefault(a.hoverBorderColor,h.getHoverColor(a.borderColor));e.borderWidth=h.valueOrDefault(a.hoverBorderWidth,a.borderWidth);e.radius=

a.radius+a.hoverRadius},removeHoverStyle:function(a){var e=a._model;a=a._options;e.backgroundColor=a.backgroundColor;e.borderColor=a.borderColor;e.borderWidth=a.borderWidth;e.radius=a.radius},_resolveElementOptions:function(a,e){var d=this.chart,c=d.data.datasets[this.index],k=a.custom||{},f=d.options.elements.point,v=h.options.resolve,m=c.data[e],p={},q,x={chart:d,dataIndex:e,dataset:c,datasetIndex:this.index},y="backgroundColor borderColor borderWidth hoverBackgroundColor hoverBorderColor hoverBorderWidth hoverRadius hitRadius pointStyle".split(" ");

d=0;for(q=y.length;d<q;++d){var w=y[d];p[w]=v([k[w],c[w],f[w]],x,e)}p.radius=v([k.radius,m?m.r:void 0,c.radius,f.radius],x,e);return p}})}},{25:25,40:40,45:45}],17:[function(n,u,t){t=n(25);var l=n(40),h=n(45);t._set("doughnut",{animation:{animateRotate:!0,animateScale:!1},hover:{mode:"single"},legendCallback:function(h){var a=[];a.push('<ul class="'+h.id+'-legend">');var e=h.data;h=e.datasets;e=e.labels;if(h.length)for(var d=0;d<h[0].data.length;++d)a.push('<li><span style="background-color:'+h[0].backgroundColor[d]+

'"></span>'),e[d]&&a.push(e[d]),a.push("</li>");a.push("</ul>");return a.join("")},legend:{labels:{generateLabels:function(f){var a=f.data;return a.labels.length&&a.datasets.length?a.labels.map(function(e,d){var c=f.getDatasetMeta(0),k=a.datasets[0],C=c.data[d],v=C&&C.custom||{},m=h.valueAtIndexOrDefault,p=f.options.elements.arc;C=v.backgroundColor?v.backgroundColor:m(k.backgroundColor,d,p.backgroundColor);var q=v.borderColor?v.borderColor:m(k.borderColor,d,p.borderColor);v=v.borderWidth?v.borderWidth:

m(k.borderWidth,d,p.borderWidth);return{text:e,fillStyle:C,strokeStyle:q,lineWidth:v,hidden:isNaN(k.data[d])||c.data[d].hidden,index:d}}):[]}},onClick:function(h,a){var e=a.index,d=this.chart,c;var k=0;for(c=(d.data.datasets||[]).length;k<c;++k){var f=d.getDatasetMeta(k);f.data[e]&&(f.data[e].hidden=!f.data[e].hidden)}d.update()}},cutoutPercentage:50,rotation:-.5*Math.PI,circumference:2*Math.PI,tooltips:{callbacks:{title:function(){return""},label:function(f,a){var e=a.labels[f.index],d=": "+a.datasets[f.datasetIndex].data[f.index];

h.isArray(e)?(e=e.slice(),e[0]+=d):e+=d;return e}}}});t._set("pie",h.clone(t.doughnut));t._set("pie",{cutoutPercentage:0});u.exports=function(f){f.controllers.doughnut=f.controllers.pie=f.DatasetController.extend({dataElementType:l.Arc,linkScales:h.noop,getRingIndex:function(a){for(var e=0,d=0;d<a;++d)this.chart.isDatasetVisible(d)&&++e;return e},update:function(a){var e=this,d=e.chart,c=d.chartArea,k=d.options,f=k.elements.arc,v=c.right-c.left-f.borderWidth;c=c.bottom-c.top-f.borderWidth;var m=Math.min(v,

c),p=0,q=0;f=e.getMeta();var x=k.cutoutPercentage,y=k.circumference;if(y<2*Math.PI){m=k.rotation%(2*Math.PI);m+=2*Math.PI*(m>=Math.PI?-1:m<-Math.PI?1:0);y=m+y;var w=Math.cos(m);q=Math.sin(m);var l=Math.cos(y),A=Math.sin(y),n=x/100;p=m<=-Math.PI&&-Math.PI<=y||m<=Math.PI&&Math.PI<=y?-1:Math.min(w*(0>w?1:n),l*(0>l?1:n));k=m<=.5*-Math.PI&&.5*-Math.PI<=y||m<=1.5*Math.PI&&1.5*Math.PI<=y?-1:Math.min(q*(0>q?1:n),A*(0>A?1:n));w=0>=m&&0<=y||m<=2*Math.PI&&2*Math.PI<=y?1:Math.max(w*(0<w?1:n),l*(0<l?1:n));y=m<=

.5*Math.PI&&.5*Math.PI<=y||m<=2.5*Math.PI&&2.5*Math.PI<=y?1:Math.max(q*(0<q?1:n),A*(0<A?1:n));m=Math.min(v/(.5*(w-p)),c/(.5*(y-k)));p=-.5*(w+p);q=-.5*(y+k)}d.borderWidth=e.getMaxBorderWidth(f.data);d.outerRadius=Math.max((m-d.borderWidth)/2,0);d.innerRadius=Math.max(x?d.outerRadius/100*x:0,0);d.radiusLength=(d.outerRadius-d.innerRadius)/d.getVisibleDatasetCount();d.offsetX=p*d.outerRadius;d.offsetY=q*d.outerRadius;f.total=e.calculateTotal();e.outerRadius=d.outerRadius-d.radiusLength*e.getRingIndex(e.index);

e.innerRadius=Math.max(e.outerRadius-d.radiusLength,0);h.each(f.data,function(c,d){e.updateElement(c,d,a)})},updateElement:function(a,e,d){var c=this.chart,k=c.chartArea,f=c.options,v=f.animation,m=(k.left+k.right)/2;k=(k.top+k.bottom)/2;var p=f.rotation,q=f.rotation,x=this.getDataset(),y=d&&v.animateRotate?0:a.hidden?0:this.calculateCircumference(x.data[e])*(f.circumference/(2*Math.PI)),w=h.valueAtIndexOrDefault;h.extend(a,{_datasetIndex:this.index,_index:e,_model:{x:m+c.offsetX,y:k+c.offsetY,startAngle:p,

endAngle:q,circumference:y,outerRadius:d&&v.animateScale?0:this.outerRadius,innerRadius:d&&v.animateScale?0:this.innerRadius,label:w(x.label,e,c.data.labels[e])}});c=a._model;this.removeHoverStyle(a);d&&v.animateRotate||(c.startAngle=0===e?f.rotation:this.getMeta().data[e-1]._model.endAngle,c.endAngle=c.startAngle+c.circumference);a.pivot()},removeHoverStyle:function(a){f.DatasetController.prototype.removeHoverStyle.call(this,a,this.chart.options.elements.arc)},calculateTotal:function(){var a=this.getDataset(),

e=this.getMeta(),d=0,c;h.each(e.data,function(e,h){c=a.data[h];isNaN(c)||e.hidden||(d+=Math.abs(c))});return d},calculateCircumference:function(a){var e=this.getMeta().total;return 0<e&&!isNaN(a)?Math.abs(a)/e*Math.PI*2:0},getMaxBorderWidth:function(a){for(var e=0,d=this.index,c=a.length,k,h,f=0;f<c;f++)k=a[f]._model?a[f]._model.borderWidth:0,h=a[f]._chart?a[f]._chart.config.data.datasets[d].hoverBorderWidth:0,e=k>e?k:e,e=h>e?h:e;return e}})}},{25:25,40:40,45:45}],18:[function(n,u,t){t=n(25);var l=

n(40),h=n(45);t._set("line",{showLines:!0,spanGaps:!1,hover:{mode:"label"},scales:{xAxes:[{type:"category",id:"x-axis-0"}],yAxes:[{type:"linear",id:"y-axis-0"}]}});u.exports=function(f){f.controllers.line=f.DatasetController.extend({datasetElementType:l.Line,dataElementType:l.Point,update:function(a){var e=this.getMeta(),d=e.dataset,c=e.data||[],k=this.chart.options,f=k.elements.line,v=this.getScaleForId(e.yAxisID),m=this.getDataset();if(e=h.valueOrDefault(m.showLine,k.showLines)){var p=d.custom||

{};void 0!==m.tension&&void 0===m.lineTension&&(m.lineTension=m.tension);d._scale=v;d._datasetIndex=this.index;d._children=c;d._model={spanGaps:m.spanGaps?m.spanGaps:k.spanGaps,tension:p.tension?p.tension:h.valueOrDefault(m.lineTension,f.tension),backgroundColor:p.backgroundColor?p.backgroundColor:m.backgroundColor||f.backgroundColor,borderWidth:p.borderWidth?p.borderWidth:m.borderWidth||f.borderWidth,borderColor:p.borderColor?p.borderColor:m.borderColor||f.borderColor,borderCapStyle:p.borderCapStyle?

p.borderCapStyle:m.borderCapStyle||f.borderCapStyle,borderDash:p.borderDash?p.borderDash:m.borderDash||f.borderDash,borderDashOffset:p.borderDashOffset?p.borderDashOffset:m.borderDashOffset||f.borderDashOffset,borderJoinStyle:p.borderJoinStyle?p.borderJoinStyle:m.borderJoinStyle||f.borderJoinStyle,fill:p.fill?p.fill:void 0!==m.fill?m.fill:f.fill,steppedLine:p.steppedLine?p.steppedLine:h.valueOrDefault(m.steppedLine,f.stepped),cubicInterpolationMode:p.cubicInterpolationMode?p.cubicInterpolationMode:

h.valueOrDefault(m.cubicInterpolationMode,f.cubicInterpolationMode)};d.pivot()}k=0;for(f=c.length;k<f;++k)this.updateElement(c[k],k,a);e&&0!==d._model.tension&&this.updateBezierControlPoints();k=0;for(f=c.length;k<f;++k)c[k].pivot()},getPointBackgroundColor:function(a,e){var d=this.chart.options.elements.point.backgroundColor,c=this.getDataset(),k=a.custom||{};k.backgroundColor?d=k.backgroundColor:c.pointBackgroundColor?d=h.valueAtIndexOrDefault(c.pointBackgroundColor,e,d):c.backgroundColor&&(d=c.backgroundColor);

return d},getPointBorderColor:function(a,e){var d=this.chart.options.elements.point.borderColor,c=this.getDataset(),k=a.custom||{};k.borderColor?d=k.borderColor:c.pointBorderColor?d=h.valueAtIndexOrDefault(c.pointBorderColor,e,d):c.borderColor&&(d=c.borderColor);return d},getPointBorderWidth:function(a,e){var d=this.chart.options.elements.point.borderWidth,c=this.getDataset(),k=a.custom||{};isNaN(k.borderWidth)?!isNaN(c.pointBorderWidth)||h.isArray(c.pointBorderWidth)?d=h.valueAtIndexOrDefault(c.pointBorderWidth,

e,d):isNaN(c.borderWidth)||(d=c.borderWidth):d=k.borderWidth;return d},updateElement:function(a,e,d){var c=this.getMeta(),k=a.custom||{},f=this.getDataset(),v=this.index,m=f.data[e],p=this.getScaleForId(c.yAxisID),q=this.getScaleForId(c.xAxisID),x=this.chart.options.elements.point;void 0!==f.radius&&void 0===f.pointRadius&&(f.pointRadius=f.radius);void 0!==f.hitRadius&&void 0===f.pointHitRadius&&(f.pointHitRadius=f.hitRadius);var y=q.getPixelForValue("object"===typeof m?m:NaN,e,v);d=d?p.getBasePixel():

this.calculatePointY(m,e,v);a._xScale=q;a._yScale=p;a._datasetIndex=v;a._index=e;a._model={x:y,y:d,skip:k.skip||isNaN(y)||isNaN(d),radius:k.radius||h.valueAtIndexOrDefault(f.pointRadius,e,x.radius),pointStyle:k.pointStyle||h.valueAtIndexOrDefault(f.pointStyle,e,x.pointStyle),backgroundColor:this.getPointBackgroundColor(a,e),borderColor:this.getPointBorderColor(a,e),borderWidth:this.getPointBorderWidth(a,e),tension:c.dataset._model?c.dataset._model.tension:0,steppedLine:c.dataset._model?c.dataset._model.steppedLine:

!1,hitRadius:k.hitRadius||h.valueAtIndexOrDefault(f.pointHitRadius,e,x.hitRadius)}},calculatePointY:function(a,e,d){var c=this.chart,k=this.getMeta();k=this.getScaleForId(k.yAxisID);var h=0,f=0,m;if(k.options.stacked){for(m=0;m<d;m++){var p=c.data.datasets[m];var q=c.getDatasetMeta(m);"line"===q.type&&q.yAxisID===k.id&&c.isDatasetVisible(m)&&(p=Number(k.getRightValue(p.data[e])),0>p?f+=p||0:h+=p||0)}a=Number(k.getRightValue(a));return 0>a?k.getPixelForValue(f+a):k.getPixelForValue(h+a)}return k.getPixelForValue(a)},

updateBezierControlPoints:function(){var a=this.getMeta(),e=this.chart.chartArea,d=a.data||[],c;a.dataset._model.spanGaps&&(d=d.filter(function(a){return!a._model.skip}));if("monotone"===a.dataset._model.cubicInterpolationMode)h.splineCurveMonotone(d);else{var k=0;for(c=d.length;k<c;++k){var f=d[k];f=f._model;var v=h.splineCurve(h.previousItem(d,k)._model,f,h.nextItem(d,k)._model,a.dataset._model.tension);f.controlPointPreviousX=v.previous.x;f.controlPointPreviousY=v.previous.y;f.controlPointNextX=

v.next.x;f.controlPointNextY=v.next.y}}if(this.chart.options.elements.line.capBezierPoints)for(k=0,c=d.length;k<c;++k)f=d[k]._model,f.controlPointPreviousX=Math.max(Math.min(f.controlPointPreviousX,e.right),e.left),f.controlPointPreviousY=Math.max(Math.min(f.controlPointPreviousY,e.bottom),e.top),f.controlPointNextX=Math.max(Math.min(f.controlPointNextX,e.right),e.left),f.controlPointNextY=Math.max(Math.min(f.controlPointNextY,e.bottom),e.top)},draw:function(){var a=this.chart,e=this.getMeta(),d=

e.data||[],c=a.chartArea,k=d.length,f=0;h.canvas.clipArea(a.ctx,c);var v=this.getDataset();h.valueOrDefault(v.showLine,a.options.showLines)&&e.dataset.draw();for(h.canvas.unclipArea(a.ctx);f<k;++f)d[f].draw(c)},setHoverStyle:function(a){var e=this.chart.data.datasets[a._datasetIndex],d=a._index,c=a.custom||{};a=a._model;a.radius=c.hoverRadius||h.valueAtIndexOrDefault(e.pointHoverRadius,d,this.chart.options.elements.point.hoverRadius);a.backgroundColor=c.hoverBackgroundColor||h.valueAtIndexOrDefault(e.pointHoverBackgroundColor,

d,h.getHoverColor(a.backgroundColor));a.borderColor=c.hoverBorderColor||h.valueAtIndexOrDefault(e.pointHoverBorderColor,d,h.getHoverColor(a.borderColor));a.borderWidth=c.hoverBorderWidth||h.valueAtIndexOrDefault(e.pointHoverBorderWidth,d,a.borderWidth)},removeHoverStyle:function(a){var e=this.chart.data.datasets[a._datasetIndex],d=a._index,c=a.custom||{},k=a._model;void 0!==e.radius&&void 0===e.pointRadius&&(e.pointRadius=e.radius);k.radius=c.radius||h.valueAtIndexOrDefault(e.pointRadius,d,this.chart.options.elements.point.radius);

k.backgroundColor=this.getPointBackgroundColor(a,d);k.borderColor=this.getPointBorderColor(a,d);k.borderWidth=this.getPointBorderWidth(a,d)}})}},{25:25,40:40,45:45}],19:[function(n,u,t){t=n(25);var l=n(40),h=n(45);t._set("polarArea",{scale:{type:"radialLinear",angleLines:{display:!1},gridLines:{circular:!0},pointLabels:{display:!1},ticks:{beginAtZero:!0}},animation:{animateRotate:!0,animateScale:!0},startAngle:-.5*Math.PI,legendCallback:function(f){var a=[];a.push('<ul class="'+f.id+'-legend">');

var e=f.data;f=e.datasets;e=e.labels;if(f.length)for(var d=0;d<f[0].data.length;++d)a.push('<li><span style="background-color:'+f[0].backgroundColor[d]+'"></span>'),e[d]&&a.push(e[d]),a.push("</li>");a.push("</ul>");return a.join("")},legend:{labels:{generateLabels:function(f){var a=f.data;return a.labels.length&&a.datasets.length?a.labels.map(function(e,d){var c=f.getDatasetMeta(0),k=a.datasets[0],C=c.data[d].custom||{},v=h.valueAtIndexOrDefault,m=f.options.elements.arc,p=C.backgroundColor?C.backgroundColor:

v(k.backgroundColor,d,m.backgroundColor),q=C.borderColor?C.borderColor:v(k.borderColor,d,m.borderColor);C=C.borderWidth?C.borderWidth:v(k.borderWidth,d,m.borderWidth);return{text:e,fillStyle:p,strokeStyle:q,lineWidth:C,hidden:isNaN(k.data[d])||c.data[d].hidden,index:d}}):[]}},onClick:function(f,a){var e=a.index,d=this.chart,c;var k=0;for(c=(d.data.datasets||[]).length;k<c;++k){var h=d.getDatasetMeta(k);h.data[e].hidden=!h.data[e].hidden}d.update()}},tooltips:{callbacks:{title:function(){return""},

label:function(f,a){return a.labels[f.index]+": "+f.yLabel}}}});u.exports=function(f){f.controllers.polarArea=f.DatasetController.extend({dataElementType:l.Arc,linkScales:h.noop,update:function(a){var e=this,d=e.chart,c=d.chartArea,k=e.getMeta(),f=d.options;d.outerRadius=Math.max((Math.min(c.right-c.left,c.bottom-c.top)-f.elements.arc.borderWidth/2)/2,0);d.innerRadius=Math.max(f.cutoutPercentage?d.outerRadius/100*f.cutoutPercentage:1,0);d.radiusLength=(d.outerRadius-d.innerRadius)/d.getVisibleDatasetCount();

e.outerRadius=d.outerRadius-d.radiusLength*e.index;e.innerRadius=e.outerRadius-d.radiusLength;k.count=e.countVisibleElements();h.each(k.data,function(c,d){e.updateElement(c,d,a)})},updateElement:function(a,e,d){var c=this.chart,k=this.getDataset(),f=c.options,v=f.animation,m=c.scale;c=c.data.labels;for(var p=this.calculateCircumference(k.data[e]),q=m.xCenter,x=m.yCenter,y=0,w=this.getMeta(),l=0;l<e;++l)isNaN(k.data[l])||w.data[l].hidden||++y;f=f.startAngle;w=a.hidden?0:m.getDistanceFromCenterForValue(k.data[e]);

y=f+p*y;p=y+(a.hidden?0:p);k=v.animateScale?0:m.getDistanceFromCenterForValue(k.data[e]);h.extend(a,{_datasetIndex:this.index,_index:e,_scale:m,_model:{x:q,y:x,innerRadius:0,outerRadius:d?k:w,startAngle:d&&v.animateRotate?f:y,endAngle:d&&v.animateRotate?f:p,label:h.valueAtIndexOrDefault(c,e,c[e])}});this.removeHoverStyle(a);a.pivot()},removeHoverStyle:function(a){f.DatasetController.prototype.removeHoverStyle.call(this,a,this.chart.options.elements.arc)},countVisibleElements:function(){var a=this.getDataset(),

e=this.getMeta(),d=0;h.each(e.data,function(c,e){isNaN(a.data[e])||c.hidden||d++});return d},calculateCircumference:function(a){var e=this.getMeta().count;return 0<e&&!isNaN(a)?2*Math.PI/e:0}})}},{25:25,40:40,45:45}],20:[function(n,u,t){t=n(25);var l=n(40),h=n(45);t._set("radar",{scale:{type:"radialLinear"},elements:{line:{tension:0}}});u.exports=function(f){f.controllers.radar=f.DatasetController.extend({datasetElementType:l.Line,dataElementType:l.Point,linkScales:h.noop,update:function(a){var e=

this,d=e.getMeta(),c=d.data,k=d.dataset.custom||{},f=e.getDataset(),v=e.chart.options.elements.line,m=e.chart.scale;void 0!==f.tension&&void 0===f.lineTension&&(f.lineTension=f.tension);h.extend(d.dataset,{_datasetIndex:e.index,_scale:m,_children:c,_loop:!0,_model:{tension:k.tension?k.tension:h.valueOrDefault(f.lineTension,v.tension),backgroundColor:k.backgroundColor?k.backgroundColor:f.backgroundColor||v.backgroundColor,borderWidth:k.borderWidth?k.borderWidth:f.borderWidth||v.borderWidth,borderColor:k.borderColor?

k.borderColor:f.borderColor||v.borderColor,fill:k.fill?k.fill:void 0!==f.fill?f.fill:v.fill,borderCapStyle:k.borderCapStyle?k.borderCapStyle:f.borderCapStyle||v.borderCapStyle,borderDash:k.borderDash?k.borderDash:f.borderDash||v.borderDash,borderDashOffset:k.borderDashOffset?k.borderDashOffset:f.borderDashOffset||v.borderDashOffset,borderJoinStyle:k.borderJoinStyle?k.borderJoinStyle:f.borderJoinStyle||v.borderJoinStyle}});d.dataset.pivot();h.each(c,function(c,d){e.updateElement(c,d,a)},e);e.updateBezierControlPoints()},

updateElement:function(a,e,d){var c=a.custom||{},k=this.getDataset(),f=this.chart.scale,v=this.chart.options.elements.point,m=f.getPointPositionForValue(e,k.data[e]);void 0!==k.radius&&void 0===k.pointRadius&&(k.pointRadius=k.radius);void 0!==k.hitRadius&&void 0===k.pointHitRadius&&(k.pointHitRadius=k.hitRadius);h.extend(a,{_datasetIndex:this.index,_index:e,_scale:f,_model:{x:d?f.xCenter:m.x,y:d?f.yCenter:m.y,tension:c.tension?c.tension:h.valueOrDefault(k.lineTension,this.chart.options.elements.line.tension),

radius:c.radius?c.radius:h.valueAtIndexOrDefault(k.pointRadius,e,v.radius),backgroundColor:c.backgroundColor?c.backgroundColor:h.valueAtIndexOrDefault(k.pointBackgroundColor,e,v.backgroundColor),borderColor:c.borderColor?c.borderColor:h.valueAtIndexOrDefault(k.pointBorderColor,e,v.borderColor),borderWidth:c.borderWidth?c.borderWidth:h.valueAtIndexOrDefault(k.pointBorderWidth,e,v.borderWidth),pointStyle:c.pointStyle?c.pointStyle:h.valueAtIndexOrDefault(k.pointStyle,e,v.pointStyle),hitRadius:c.hitRadius?

c.hitRadius:h.valueAtIndexOrDefault(k.pointHitRadius,e,v.hitRadius)}});a._model.skip=c.skip?c.skip:isNaN(a._model.x)||isNaN(a._model.y)},updateBezierControlPoints:function(){var a=this.chart.chartArea,e=this.getMeta();h.each(e.data,function(d,c){var k=d._model,f=h.splineCurve(h.previousItem(e.data,c,!0)._model,k,h.nextItem(e.data,c,!0)._model,k.tension);k.controlPointPreviousX=Math.max(Math.min(f.previous.x,a.right),a.left);k.controlPointPreviousY=Math.max(Math.min(f.previous.y,a.bottom),a.top);k.controlPointNextX=

Math.max(Math.min(f.next.x,a.right),a.left);k.controlPointNextY=Math.max(Math.min(f.next.y,a.bottom),a.top);d.pivot()})},setHoverStyle:function(a){var e=this.chart.data.datasets[a._datasetIndex],d=a.custom||{},c=a._index;a=a._model;a.radius=d.hoverRadius?d.hoverRadius:h.valueAtIndexOrDefault(e.pointHoverRadius,c,this.chart.options.elements.point.hoverRadius);a.backgroundColor=d.hoverBackgroundColor?d.hoverBackgroundColor:h.valueAtIndexOrDefault(e.pointHoverBackgroundColor,c,h.getHoverColor(a.backgroundColor));

a.borderColor=d.hoverBorderColor?d.hoverBorderColor:h.valueAtIndexOrDefault(e.pointHoverBorderColor,c,h.getHoverColor(a.borderColor));a.borderWidth=d.hoverBorderWidth?d.hoverBorderWidth:h.valueAtIndexOrDefault(e.pointHoverBorderWidth,c,a.borderWidth)},removeHoverStyle:function(a){var e=this.chart.data.datasets[a._datasetIndex],d=a.custom||{},c=a._index;a=a._model;var k=this.chart.options.elements.point;a.radius=d.radius?d.radius:h.valueAtIndexOrDefault(e.pointRadius,c,k.radius);a.backgroundColor=

d.backgroundColor?d.backgroundColor:h.valueAtIndexOrDefault(e.pointBackgroundColor,c,k.backgroundColor);a.borderColor=d.borderColor?d.borderColor:h.valueAtIndexOrDefault(e.pointBorderColor,c,k.borderColor);a.borderWidth=d.borderWidth?d.borderWidth:h.valueAtIndexOrDefault(e.pointBorderWidth,c,k.borderWidth)}})}},{25:25,40:40,45:45}],21:[function(n,u,t){n(25)._set("scatter",{hover:{mode:"single"},scales:{xAxes:[{id:"x-axis-1",type:"linear",position:"bottom"}],yAxes:[{id:"y-axis-1",type:"linear",position:"left"}]},

showLines:!1,tooltips:{callbacks:{title:function(){return""},label:function(l){return"("+l.xLabel+", "+l.yLabel+")"}}}});u.exports=function(l){l.controllers.scatter=l.controllers.line}},{25:25}],22:[function(n,u,t){t=n(25);var l=n(26),h=n(45);t._set("global",{animation:{duration:1E3,easing:"easeOutQuart",onProgress:h.noop,onComplete:h.noop}});u.exports=function(f){f.Animation=l.extend({chart:null,currentStep:0,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null});f.animationService=

{frameDuration:17,animations:[],dropFrames:0,request:null,addAnimation:function(a,e,d,c){d=this.animations;var k;e.chart=a;c||(a.animating=!0);c=0;for(k=d.length;c<k;++c)if(d[c].chart===a){d[c]=e;return}d.push(e);1===d.length&&this.requestAnimationFrame()},cancelAnimation:function(a){var e=h.findIndex(this.animations,function(d){return d.chart===a});-1!==e&&(this.animations.splice(e,1),a.animating=!1)},requestAnimationFrame:function(){var a=this;null===a.request&&(a.request=h.requestAnimFrame.call(window,

function(){a.request=null;a.startDigest()}))},startDigest:function(){var a=Date.now(),e=0;1<this.dropFrames&&(e=Math.floor(this.dropFrames),this.dropFrames%=1);this.advance(1+e);e=Date.now();this.dropFrames+=(e-a)/this.frameDuration;0<this.animations.length&&this.requestAnimationFrame()},advance:function(a){for(var e=this.animations,d,c,k=0;k<e.length;)d=e[k],c=d.chart,d.currentStep=(d.currentStep||0)+a,d.currentStep=Math.min(d.currentStep,d.numSteps),h.callback(d.render,[c,d],c),h.callback(d.onAnimationProgress,

[d],c),d.currentStep>=d.numSteps?(h.callback(d.onAnimationComplete,[d],c),c.animating=!1,e.splice(k,1)):++k}};Object.defineProperty(f.Animation.prototype,"animationObject",{get:function(){return this}});Object.defineProperty(f.Animation.prototype,"chartInstance",{get:function(){return this.chart},set:function(a){this.chart=a}})}},{25:25,26:26,45:45}],23:[function(n,u,t){var l=n(25),h=n(45),f=n(28),a=n(30),e=n(48),d=n(31);u.exports=function(c){function k(a){a=a||{};var c=a.data=a.data||{};c.datasets=

c.datasets||[];c.labels=c.labels||[];a.options=h.configMerge(l.global,l[a.type],a.options||{});return a}function C(d){var e=d.options;h.each(d.scales,function(c){a.removeBox(d,c)});e=h.configMerge(c.defaults.global,c.defaults[d.config.type],e);d.options=d.config.options=e;d.ensureScalesHaveIDs();d.buildOrUpdateScales();d.tooltip._options=e.tooltips;d.tooltip.initialize()}function v(a){return"top"===a||"bottom"===a}c.types={};c.instances={};c.controllers={};h.extend(c.prototype,{construct:function(a,

d){var f=this;d=k(d);var m=e.acquireContext(a,d),p=m&&m.canvas,v=p&&p.height,C=p&&p.width;f.id=h.uid();f.ctx=m;f.canvas=p;f.config=d;f.width=C;f.height=v;f.aspectRatio=v?C/v:null;f.options=d.options;f._bufferedRender=!1;f.chart=f;f.controller=f;c.instances[f.id]=f;Object.defineProperty(f,"data",{get:function(){return f.config.data},set:function(a){f.config.data=a}});m&&p?(f.initialize(),f.update()):console.error("Failed to create chart: can't acquire context from the given item")},initialize:function(){d.notify(this,

"beforeInit");h.retinaScale(this,this.options.devicePixelRatio);this.bindEvents();this.options.responsive&&this.resize(!0);this.ensureScalesHaveIDs();this.buildOrUpdateScales();this.initToolTip();d.notify(this,"afterInit");return this},clear:function(){h.canvas.clear(this);return this},stop:function(){c.animationService.cancelAnimation(this);return this},resize:function(a){var c=this.options,e=this.canvas,k=c.maintainAspectRatio&&this.aspectRatio||null,f=Math.max(0,Math.floor(h.getMaximumWidth(e)));

k=Math.max(0,Math.floor(k?f/k:h.getMaximumHeight(e)));if(this.width!==f||this.height!==k)if(e.width=this.width=f,e.height=this.height=k,e.style.width=f+"px",e.style.height=k+"px",h.retinaScale(this,c.devicePixelRatio),!a){a={width:f,height:k};d.notify(this,"resize",[a]);if(this.options.onResize)this.options.onResize(this,a);this.stop();this.update(this.options.responsiveAnimationDuration)}},ensureScalesHaveIDs:function(){var a=this.options,c=a.scales||{};a=a.scale;h.each(c.xAxes,function(a,c){a.id=

a.id||"x-axis-"+c});h.each(c.yAxes,function(a,c){a.id=a.id||"y-axis-"+c});a&&(a.id=a.id||"scale")},buildOrUpdateScales:function(){var a=this,d=a.options,e=a.scales||{},k=[],f=Object.keys(e).reduce(function(a,c){a[c]=!1;return a},{});d.scales&&(k=k.concat((d.scales.xAxes||[]).map(function(a){return{options:a,dtype:"category",dposition:"bottom"}}),(d.scales.yAxes||[]).map(function(a){return{options:a,dtype:"linear",dposition:"left"}})));d.scale&&k.push({options:d.scale,dtype:"radialLinear",isDefault:!0,

dposition:"chartArea"});h.each(k,function(d){var k=d.options,m=k.id,q=h.valueOrDefault(k.type,d.dtype);v(k.position)!==v(d.dposition)&&(k.position=d.dposition);f[m]=!0;if(m in e&&e[m].type===q)m=e[m],m.options=k,m.ctx=a.ctx,m.chart=a;else{var p=c.scaleService.getScaleConstructor(q);if(!p)return;m=new p({id:m,type:q,options:k,ctx:a.ctx,chart:a});e[m.id]=m}m.mergeTicksOptions();d.isDefault&&(a.scale=m)});h.each(f,function(a,c){a||delete e[c]});a.scales=e;c.scaleService.addScalesToLayout(this)},buildOrUpdateControllers:function(){var a=

this,d=[],e=[];h.each(a.data.datasets,function(k,f){var h=a.getDatasetMeta(f),m=k.type||a.config.type;h.type&&h.type!==m&&(a.destroyDatasetMeta(f),h=a.getDatasetMeta(f));h.type=m;d.push(h.type);if(h.controller)h.controller.updateIndex(f),h.controller.linkScales();else{m=c.controllers[h.type];if(void 0===m)throw Error('"'+h.type+'" is not a chart type.');h.controller=new m(a,f);e.push(h.controller)}},a);return e},resetElements:function(){var a=this;h.each(a.data.datasets,function(c,d){a.getDatasetMeta(d).controller.reset()},

a)},reset:function(){this.resetElements();this.tooltip.initialize()},update:function(a,c){var e=this;a&&"object"===typeof a||(a={duration:a,lazy:c});C(e);d._invalidate(e);if(!1!==d.notify(e,"beforeUpdate")){e.tooltip._data=e.data;var k=e.buildOrUpdateControllers();h.each(e.data.datasets,function(a,c){e.getDatasetMeta(c).controller.buildOrUpdateElements()},e);e.updateLayout();e.options.animation&&e.options.animation.duration&&h.each(k,function(a){a.reset()});e.updateDatasets();e.tooltip.initialize();

e.lastActive=[];d.notify(e,"afterUpdate");e._bufferedRender?e._bufferedRequest={duration:a.duration,easing:a.easing,lazy:a.lazy}:e.render(a)}},updateLayout:function(){!1!==d.notify(this,"beforeLayout")&&(a.update(this,this.width,this.height),d.notify(this,"afterScaleUpdate"),d.notify(this,"afterLayout"))},updateDatasets:function(){if(!1!==d.notify(this,"beforeDatasetsUpdate")){for(var a=0,c=this.data.datasets.length;a<c;++a)this.updateDataset(a);d.notify(this,"afterDatasetsUpdate")}},updateDataset:function(a){var c=

this.getDatasetMeta(a);a={meta:c,index:a};!1!==d.notify(this,"beforeDatasetUpdate",[a])&&(c.controller.update(),d.notify(this,"afterDatasetUpdate",[a]))},render:function(a,e){var k=this;a&&"object"===typeof a||(a={duration:a,lazy:e});var f=a.duration,m=a.lazy;if(!1!==d.notify(k,"beforeRender")){var p=k.options.animation,v=function(a){d.notify(k,"afterRender");h.callback(p&&p.onComplete,[a],k)};p&&("undefined"!==typeof f&&0!==f||"undefined"===typeof f&&0!==p.duration)?(v=new c.Animation({numSteps:(f||

p.duration)/16.66,easing:a.easing||p.easing,render:function(a,c){var d=c.currentStep,e=d/c.numSteps;a.draw((0,h.easing.effects[c.easing])(e),e,d)},onAnimationProgress:p.onProgress,onAnimationComplete:v}),c.animationService.addAnimation(k,v,f,m)):(k.draw(),v(new c.Animation({numSteps:0,chart:k})));return k}},draw:function(a){var c=this;c.clear();h.isNullOrUndef(a)&&(a=1);c.transition(a);!1!==d.notify(c,"beforeDraw",[a])&&(h.each(c.boxes,function(a){a.draw(c.chartArea)},c),c.scale&&c.scale.draw(),c.drawDatasets(a),

c._drawTooltip(a),d.notify(c,"afterDraw",[a]))},transition:function(a){for(var c=0,d=(this.data.datasets||[]).length;c<d;++c)this.isDatasetVisible(c)&&this.getDatasetMeta(c).controller.transition(a);this.tooltip.transition(a)},drawDatasets:function(a){if(!1!==d.notify(this,"beforeDatasetsDraw",[a])){for(var c=(this.data.datasets||[]).length-1;0<=c;--c)this.isDatasetVisible(c)&&this.drawDataset(c,a);d.notify(this,"afterDatasetsDraw",[a])}},drawDataset:function(a,c){var e=this.getDatasetMeta(a),k={meta:e,

index:a,easingValue:c};!1!==d.notify(this,"beforeDatasetDraw",[k])&&(e.controller.draw(c),d.notify(this,"afterDatasetDraw",[k]))},_drawTooltip:function(a){var c=this.tooltip;a={tooltip:c,easingValue:a};!1!==d.notify(this,"beforeTooltipDraw",[a])&&(c.draw(),d.notify(this,"afterTooltipDraw",[a]))},getElementAtEvent:function(a){return f.modes.single(this,a)},getElementsAtEvent:function(a){return f.modes.label(this,a,{intersect:!0})},getElementsAtXAxis:function(a){return f.modes["x-axis"](this,a,{intersect:!0})},

getElementsAtEventForMode:function(a,c,d){c=f.modes[c];return"function"===typeof c?c(this,a,d):[]},getDatasetAtEvent:function(a){return f.modes.dataset(this,a,{intersect:!0})},getDatasetMeta:function(a){a=this.data.datasets[a];a._meta||(a._meta={});var c=a._meta[this.id];c||(c=a._meta[this.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null});return c},getVisibleDatasetCount:function(){for(var a=0,c=0,d=this.data.datasets.length;c<d;++c)this.isDatasetVisible(c)&&

a++;return a},isDatasetVisible:function(a){var c=this.getDatasetMeta(a);return"boolean"===typeof c.hidden?!c.hidden:!this.data.datasets[a].hidden},generateLegend:function(){return this.options.legendCallback(this)},destroyDatasetMeta:function(a){var c=this.id;a=this.data.datasets[a];var d=a._meta&&a._meta[c];d&&(d.controller.destroy(),delete a._meta[c])},destroy:function(){var a=this.canvas,k;this.stop();var f=0;for(k=this.data.datasets.length;f<k;++f)this.destroyDatasetMeta(f);a&&(this.unbindEvents(),

h.canvas.clear(this),e.releaseContext(this.ctx),this.ctx=this.canvas=null);d.notify(this,"destroy");delete c.instances[this.id]},toBase64Image:function(){return this.canvas.toDataURL.apply(this.canvas,arguments)},initToolTip:function(){this.tooltip=new c.Tooltip({_chart:this,_chartInstance:this,_data:this.data,_options:this.options.tooltips},this)},bindEvents:function(){var a=this,c=a._listeners={},d=function(){a.eventHandler.apply(a,arguments)};h.each(a.options.events,function(k){e.addEventListener(a,

k,d);c[k]=d});a.options.responsive&&(d=function(){a.resize()},e.addEventListener(a,"resize",d),c.resize=d)},unbindEvents:function(){var a=this,c=a._listeners;c&&(delete a._listeners,h.each(c,function(c,d){e.removeEventListener(a,d,c)}))},updateHoverStyle:function(a,c,d){c=d?"setHoverStyle":"removeHoverStyle";var e;var k=0;for(e=a.length;k<e;++k)if(d=a[k])this.getDatasetMeta(d._datasetIndex).controller[c](d)},eventHandler:function(a){var c=this.tooltip;if(!1!==d.notify(this,"beforeEvent",[a])){this._bufferedRender=

!0;this._bufferedRequest=null;var e=this.handleEvent(a);c&&(e=c._start?c.handleEvent(a):e|c.handleEvent(a));d.notify(this,"afterEvent",[a]);(a=this._bufferedRequest)?this.render(a):e&&!this.animating&&(this.stop(),this.render(this.options.hover.animationDuration,!0));this._bufferedRender=!1;this._bufferedRequest=null;return this}},handleEvent:function(a){var c=this.options||{},d=c.hover;this.lastActive=this.lastActive||[];this.active="mouseout"===a.type?[]:this.getElementsAtEventForMode(a,d.mode,

d);h.callback(c.onHover||c.hover.onHover,[a["native"],this.active],this);("mouseup"===a.type||"click"===a.type)&&c.onClick&&c.onClick.call(this,a["native"],this.active);this.lastActive.length&&this.updateHoverStyle(this.lastActive,d.mode,!1);this.active.length&&d.mode&&this.updateHoverStyle(this.active,d.mode,!0);a=!h.arrayEquals(this.active,this.lastActive);this.lastActive=this.active;return a}});c.Controller=c}},{25:25,28:28,30:30,31:31,45:45,48:48}],24:[function(n,u,t){var l=n(45);u.exports=function(h){function f(a,

c){a._chartjs?a._chartjs.listeners.push(c):(Object.defineProperty(a,"_chartjs",{configurable:!0,enumerable:!1,value:{listeners:[c]}}),e.forEach(function(c){var d="onData"+c.charAt(0).toUpperCase()+c.slice(1),e=a[c];Object.defineProperty(a,c,{configurable:!0,enumerable:!1,value:function(){var c=Array.prototype.slice.call(arguments),k=e.apply(this,c);l.each(a._chartjs.listeners,function(a){"function"===typeof a[d]&&a[d].apply(a,c)});return k}})}))}function a(a,c){var d=a._chartjs;if(d){d=d.listeners;

var f=d.indexOf(c);-1!==f&&d.splice(f,1);0<d.length||(e.forEach(function(c){delete a[c]}),delete a._chartjs)}}var e=["push","pop","shift","splice","unshift"];h.DatasetController=function(a,c){this.initialize(a,c)};l.extend(h.DatasetController.prototype,{datasetElementType:null,dataElementType:null,initialize:function(a,c){this.chart=a;this.index=c;this.linkScales();this.addElements()},updateIndex:function(a){this.index=a},linkScales:function(){var a=this.getMeta(),c=this.getDataset();null!==a.xAxisID&&

a.xAxisID in this.chart.scales||(a.xAxisID=c.xAxisID||this.chart.options.scales.xAxes[0].id);null!==a.yAxisID&&a.yAxisID in this.chart.scales||(a.yAxisID=c.yAxisID||this.chart.options.scales.yAxes[0].id)},getDataset:function(){return this.chart.data.datasets[this.index]},getMeta:function(){return this.chart.getDatasetMeta(this.index)},getScaleForId:function(a){return this.chart.scales[a]},reset:function(){this.update(!0)},destroy:function(){this._data&&a(this._data,this)},createMetaDataset:function(){var a=

this.datasetElementType;return a&&new a({_chart:this.chart,_datasetIndex:this.index})},createMetaData:function(a){var c=this.dataElementType;return c&&new c({_chart:this.chart,_datasetIndex:this.index,_index:a})},addElements:function(){var a=this.getMeta(),c=this.getDataset().data||[],e=a.data;var f=0;for(c=c.length;f<c;++f)e[f]=e[f]||this.createMetaData(f);a.dataset=a.dataset||this.createMetaDataset()},addElementAndReset:function(a){var c=this.createMetaData(a);this.getMeta().data.splice(a,0,c);

this.updateElement(c,a,!0)},buildOrUpdateElements:function(){var d=this.getDataset();d=d.data||(d.data=[]);this._data!==d&&(this._data&&a(this._data,this),f(d,this),this._data=d);this.resyncElements()},update:l.noop,transition:function(a){for(var c=this.getMeta(),d=c.data||[],e=d.length,f=0;f<e;++f)d[f].transition(a);c.dataset&&c.dataset.transition(a)},draw:function(){var a=this.getMeta(),c=a.data||[],e=c.length,f=0;for(a.dataset&&a.dataset.draw();f<e;++f)c[f].draw()},removeHoverStyle:function(a,

c){var d=this.chart.data.datasets[a._datasetIndex],e=a._index,f=a.custom||{},h=l.valueAtIndexOrDefault,p=a._model;p.backgroundColor=f.backgroundColor?f.backgroundColor:h(d.backgroundColor,e,c.backgroundColor);p.borderColor=f.borderColor?f.borderColor:h(d.borderColor,e,c.borderColor);p.borderWidth=f.borderWidth?f.borderWidth:h(d.borderWidth,e,c.borderWidth)},setHoverStyle:function(a){var c=this.chart.data.datasets[a._datasetIndex],d=a._index,e=a.custom||{},f=l.valueAtIndexOrDefault,h=l.getHoverColor;

a=a._model;a.backgroundColor=e.hoverBackgroundColor?e.hoverBackgroundColor:f(c.hoverBackgroundColor,d,h(a.backgroundColor));a.borderColor=e.hoverBorderColor?e.hoverBorderColor:f(c.hoverBorderColor,d,h(a.borderColor));a.borderWidth=e.hoverBorderWidth?e.hoverBorderWidth:f(c.hoverBorderWidth,d,a.borderWidth)},resyncElements:function(){var a=this.getMeta(),c=this.getDataset().data,e=a.data.length;c=c.length;c<e?a.data.splice(c,e-c):c>e&&this.insertElements(e,c-e)},insertElements:function(a,c){for(var d=

0;d<c;++d)this.addElementAndReset(a+d)},onDataPush:function(){this.insertElements(this.getDataset().data.length-1,arguments.length)},onDataPop:function(){this.getMeta().data.pop()},onDataShift:function(){this.getMeta().data.shift()},onDataSplice:function(a,c){this.getMeta().data.splice(a,c);this.insertElements(a,arguments.length-2)},onDataUnshift:function(){this.insertElements(0,arguments.length)}});h.DatasetController.extend=l.inherits}},{45:45}],25:[function(n,u,t){var l=n(45);u.exports={_set:function(h,

f){return l.merge(this[h]||(this[h]={}),f)}}},{45:45}],26:[function(n,u,t){var l=n(2),h=n(45);n=function(f){h.extend(this,f);this.initialize.apply(this,arguments)};h.extend(n.prototype,{initialize:function(){this.hidden=!1},pivot:function(){this._view||(this._view=h.clone(this._model));this._start={};return this},transition:function(f){var a=this._model,e=this._start,d=this._view;if(!a||1===f)return this._view=a,this._start=null,this;d||(d=this._view={});e||(e=this._start={});var c=Object.keys(a),

k;var h=0;for(k=c.length;h<k;++h){var v=c[h];var m=a[v];d.hasOwnProperty(v)||(d[v]=m);var p=d[v];if(p!==m&&"_"!==v[0]){e.hasOwnProperty(v)||(e[v]=p);p=e[v];var q=typeof m;if(q===typeof p)if("string"===q){if(p=l(p),p.valid&&(q=l(m),q.valid)){d[v]=q.mix(p,f).rgbString();continue}}else if("number"===q&&isFinite(p)&&isFinite(m)){d[v]=p+(m-p)*f;continue}d[v]=m}}return this},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return h.isNumber(this._model.x)&&h.isNumber(this._model.y)}});

n.extend=h.inherits;u.exports=n},{2:2,45:45}],27:[function(n,u,t){var l=n(2),h=n(25),f=n(45);u.exports=function(a){function e(a,d,e){if("string"===typeof a){var c=parseInt(a,10);-1!==a.indexOf("%")&&(c=c/100*d.parentNode[e])}else c=a;return c}function d(a,d,f){var c=document.defaultView,k=a.parentNode,h=c.getComputedStyle(a)[d];d=c.getComputedStyle(k)[d];c=void 0!==h&&null!==h&&"none"!==h;var q=void 0!==d&&null!==d&&"none"!==d,x=Number.POSITIVE_INFINITY;return c||q?Math.min(c?e(h,a,f):x,q?e(d,k,f):

x):"none"}f.configMerge=function(){return f.merge(f.clone(arguments[0]),[].slice.call(arguments,1),{merger:function(c,d,e,h){var k=d[c]||{},p=e[c];"scales"===c?d[c]=f.scaleMerge(k,p):"scale"===c?d[c]=f.merge(k,[a.scaleService.getScaleDefaults(p.type),p]):f._merger(c,d,e,h)}})};f.scaleMerge=function(){return f.merge(f.clone(arguments[0]),[].slice.call(arguments,1),{merger:function(c,d,e,h){if("xAxes"===c||"yAxes"===c){h=e[c].length;var k;d[c]||(d[c]=[]);for(k=0;k<h;++k){var p=e[c][k];var q=f.valueOrDefault(p.type,

"xAxes"===c?"category":"linear");k>=d[c].length&&d[c].push({});!d[c][k].type||p.type&&p.type!==d[c][k].type?f.merge(d[c][k],[a.scaleService.getScaleDefaults(q),p]):f.merge(d[c][k],p)}}else f._merger(c,d,e,h)}})};f.where=function(a,d){if(f.isArray(a)&&Array.prototype.filter)return a.filter(d);var c=[];f.each(a,function(a){d(a)&&c.push(a)});return c};f.findIndex=Array.prototype.findIndex?function(a,d,e){return a.findIndex(d,e)}:function(a,d,e){e=void 0===e?a:e;for(var c=0,k=a.length;c<k;++c)if(d.call(e,

a[c],c,a))return c;return-1};f.findNextWhere=function(a,d,e){f.isNullOrUndef(e)&&(e=-1);for(e+=1;e<a.length;e++){var c=a[e];if(d(c))return c}};f.findPreviousWhere=function(a,d,e){f.isNullOrUndef(e)&&(e=a.length);for(--e;0<=e;e--){var c=a[e];if(d(c))return c}};f.isNumber=function(a){return!isNaN(parseFloat(a))&&isFinite(a)};f.almostEquals=function(a,d,e){return Math.abs(a-d)<e};f.almostWhole=function(a,d){var c=Math.round(a);return c-d<a&&c+d>a};f.max=function(a){return a.reduce(function(a,c){return isNaN(c)?

a:Math.max(a,c)},Number.NEGATIVE_INFINITY)};f.min=function(a){return a.reduce(function(a,c){return isNaN(c)?a:Math.min(a,c)},Number.POSITIVE_INFINITY)};f.sign=Math.sign?function(a){return Math.sign(a)}:function(a){a=+a;return 0===a||isNaN(a)?a:0<a?1:-1};f.log10=Math.log10?function(a){return Math.log10(a)}:function(a){var c=Math.log(a)*Math.LOG10E,d=Math.round(c);return a===Math.pow(10,d)?d:c};f.toRadians=function(a){return Math.PI/180*a};f.toDegrees=function(a){return 180/Math.PI*a};f.getAngleFromPoint=

function(a,d){var c=d.x-a.x,e=d.y-a.y,k=Math.sqrt(c*c+e*e);c=Math.atan2(e,c);c<-.5*Math.PI&&(c+=2*Math.PI);return{angle:c,distance:k}};f.distanceBetweenPoints=function(a,d){return Math.sqrt(Math.pow(d.x-a.x,2)+Math.pow(d.y-a.y,2))};f.aliasPixel=function(a){return 0===a%2?0:.5};f.splineCurve=function(a,d,e,f){a=a.skip?d:a;e=e.skip?d:e;var c=Math.sqrt(Math.pow(d.x-a.x,2)+Math.pow(d.y-a.y,2)),k=Math.sqrt(Math.pow(e.x-d.x,2)+Math.pow(e.y-d.y,2)),h=c/(c+k);c=k/(c+k);h=isNaN(h)?0:h;c=isNaN(c)?0:c;h*=f;

f*=c;return{previous:{x:d.x-h*(e.x-a.x),y:d.y-h*(e.y-a.y)},next:{x:d.x+f*(e.x-a.x),y:d.y+f*(e.y-a.y)}}};f.EPSILON=Number.EPSILON||1E-14;f.splineCurveMonotone=function(a){a=(a||[]).map(function(a){return{model:a._model,deltaK:0,mK:0}});var c=a.length,d,e;for(d=0;d<c;++d){var h=a[d];if(!h.model.skip){var p=0<d?a[d-1]:null;if((e=d<c-1?a[d+1]:null)&&!e.model.skip){var q=e.model.x-h.model.x;h.deltaK=0!==q?(e.model.y-h.model.y)/q:0}!p||p.model.skip?h.mK=h.deltaK:!e||e.model.skip?h.mK=p.deltaK:this.sign(p.deltaK)!==

this.sign(h.deltaK)?h.mK=0:h.mK=(p.deltaK+h.deltaK)/2}}for(d=0;d<c-1;++d)if(h=a[d],e=a[d+1],!h.model.skip&&!e.model.skip)if(f.almostEquals(h.deltaK,0,this.EPSILON))h.mK=e.mK=0;else{p=h.mK/h.deltaK;q=e.mK/h.deltaK;var x=Math.pow(p,2)+Math.pow(q,2);9>=x||(x=3/Math.sqrt(x),h.mK=p*x*h.deltaK,e.mK=q*x*h.deltaK)}for(d=0;d<c;++d)h=a[d],h.model.skip||(p=0<d?a[d-1]:null,e=d<c-1?a[d+1]:null,p&&!p.model.skip&&(p=(h.model.x-p.model.x)/3,h.model.controlPointPreviousX=h.model.x-p,h.model.controlPointPreviousY=

h.model.y-p*h.mK),e&&!e.model.skip&&(p=(e.model.x-h.model.x)/3,h.model.controlPointNextX=h.model.x+p,h.model.controlPointNextY=h.model.y+p*h.mK))};f.nextItem=function(a,d,e){return e?d>=a.length-1?a[0]:a[d+1]:d>=a.length-1?a[a.length-1]:a[d+1]};f.previousItem=function(a,d,e){return e?0>=d?a[a.length-1]:a[d-1]:0>=d?a[0]:a[d-1]};f.niceNum=function(a,d){var c=Math.floor(f.log10(a)),e=a/Math.pow(10,c);return(d?1.5>e?1:3>e?2:7>e?5:10:1>=e?1:2>=e?2:5>=e?5:10)*Math.pow(10,c)};f.requestAnimFrame=function(){return"undefined"===

typeof window?function(a){a()}:window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a){return window.setTimeout(a,1E3/60)}}();f.getRelativePosition=function(a,d){var c=a.originalEvent||a;var e=a.currentTarget||a.srcElement,k=e.getBoundingClientRect(),h=c.touches;if(h&&0<h.length){var q=h[0].clientX;c=h[0].clientY}else q=c.clientX,c=c.clientY;h=parseFloat(f.getStyle(e,"padding-left"));

var x=parseFloat(f.getStyle(e,"padding-top")),y=parseFloat(f.getStyle(e,"padding-right")),w=parseFloat(f.getStyle(e,"padding-bottom"));w=k.bottom-k.top-x-w;q=Math.round((q-k.left-h)/(k.right-k.left-h-y)*e.width/d.currentDevicePixelRatio);c=Math.round((c-k.top-x)/w*e.height/d.currentDevicePixelRatio);return{x:q,y:c}};f.getConstraintWidth=function(a){return d(a,"max-width","clientWidth")};f.getConstraintHeight=function(a){return d(a,"max-height","clientHeight")};f.getMaximumWidth=function(a){var c=

a.parentNode;if(!c)return a.clientWidth;var d=parseInt(f.getStyle(c,"padding-left"),10),e=parseInt(f.getStyle(c,"padding-right"),10);c=c.clientWidth-d-e;a=f.getConstraintWidth(a);return isNaN(a)?c:Math.min(c,a)};f.getMaximumHeight=function(a){var c=a.parentNode;if(!c)return a.clientHeight;var d=parseInt(f.getStyle(c,"padding-top"),10),e=parseInt(f.getStyle(c,"padding-bottom"),10);c=c.clientHeight-d-e;a=f.getConstraintHeight(a);return isNaN(a)?c:Math.min(c,a)};f.getStyle=function(a,d){return a.currentStyle?

a.currentStyle[d]:document.defaultView.getComputedStyle(a,null).getPropertyValue(d)};f.retinaScale=function(a,d){var c=a.currentDevicePixelRatio=d||window.devicePixelRatio||1;if(1!==c){var e=a.canvas,f=a.height,h=a.width;e.height=f*c;e.width=h*c;a.ctx.scale(c,c);e.style.height||e.style.width||(e.style.height=f+"px",e.style.width=h+"px")}};f.fontString=function(a,d,e){return d+" "+a+"px "+e};f.longestText=function(a,d,e,h){h=h||{};var c=h.data=h.data||{},k=h.garbageCollect=h.garbageCollect||[];h.font!==

d&&(c=h.data={},k=h.garbageCollect=[],h.font=d);a.font=d;var q=0;f.each(e,function(d){void 0!==d&&null!==d&&!0!==f.isArray(d)?q=f.measureText(a,c,k,q,d):f.isArray(d)&&f.each(d,function(d){void 0===d||null===d||f.isArray(d)||(q=f.measureText(a,c,k,q,d))})});d=k.length/2;if(d>e.length){for(e=0;e<d;e++)delete c[k[e]];k.splice(0,d)}return q};f.measureText=function(a,d,e,f,h){var c=d[h];c||(c=d[h]=a.measureText(h).width,e.push(h));c>f&&(f=c);return f};f.numberOfLabelLines=function(a){var c=1;f.each(a,

function(a){f.isArray(a)&&a.length>c&&(c=a.length)});return c};f.color=l?function(a){a instanceof CanvasGradient&&(a=h.global.defaultColor);return l(a)}:function(a){console.error("Color.js not found!");return a};f.getHoverColor=function(a){return a instanceof CanvasPattern?a:f.color(a).saturate(.5).darken(.1).rgbString()}}},{2:2,25:25,45:45}],28:[function(n,u,t){function l(a,d){return a["native"]?{x:a.x,y:a.y}:c.getRelativePosition(a,d)}function h(a,c){var d=a.data.datasets,e,f;var h=0;for(e=d.length;h<

e;++h)if(a.isDatasetVisible(h)){d=a.getDatasetMeta(h);var k=0;for(f=d.data.length;k<f;++k){var y=d.data[k];y._view.skip||c(y)}}}function f(a,c){var d=[];h(a,function(a){a.inRange(c.x,c.y)&&d.push(a)});return d}function a(a,c,d,e){var f=Number.POSITIVE_INFINITY,k=[];h(a,function(a){if(!d||a.inRange(c.x,c.y)){var h=a.getCenterPoint();h=e(c,h);h<f?(k=[a],f=h):h===f&&k.push(a)}});return k}function e(a){var c=-1!==a.indexOf("x"),d=-1!==a.indexOf("y");return function(a,e){return Math.sqrt(Math.pow(c?Math.abs(a.x-

e.x):0,2)+Math.pow(d?Math.abs(a.y-e.y):0,2))}}function d(c,d,h){d=l(d,c);h.axis=h.axis||"x";var k=e(h.axis),p=h.intersect?f(c,d):a(c,d,!1,k),q=[];if(!p.length)return[];c.data.datasets.forEach(function(a,d){if(c.isDatasetVisible(d)){var e=c.getDatasetMeta(d).data[p[0]._index];e&&!e._view.skip&&q.push(e)}});return q}var c=n(45);u.exports={modes:{single:function(a,c){var d=l(c,a),e=[];h(a,function(a){if(a.inRange(d.x,d.y))return e.push(a),e});return e.slice(0,1)},label:d,index:d,dataset:function(c,d,

h){d=l(d,c);h.axis=h.axis||"xy";var k=e(h.axis);h=h.intersect?f(c,d):a(c,d,!1,k);0<h.length&&(h=c.getDatasetMeta(h[0]._datasetIndex).data);return h},"x-axis":function(a,c){return d(a,c,{intersect:!1})},point:function(a,c){var d=l(c,a);return f(a,d)},nearest:function(c,d,f){d=l(d,c);f.axis=f.axis||"xy";var h=e(f.axis);c=a(c,d,f.intersect,h);1<c.length&&c.sort(function(a,c){var d=a.getArea(),e=c.getArea();d-=e;0===d&&(d=a._datasetIndex-c._datasetIndex);return d});return c.slice(0,1)},x:function(a,c,

d){var e=l(c,a),f=[],k=!1;h(a,function(a){a.inXRange(e.x)&&f.push(a);a.inRange(e.x,e.y)&&(k=!0)});d.intersect&&!k&&(f=[]);return f},y:function(a,c,d){var e=l(c,a),f=[],k=!1;h(a,function(a){a.inYRange(e.y)&&f.push(a);a.inRange(e.x,e.y)&&(k=!0)});d.intersect&&!k&&(f=[]);return f}}}},{45:45}],29:[function(n,u,t){n(25)._set("global",{responsive:!0,responsiveAnimationDuration:0,maintainAspectRatio:!0,events:["mousemove","mouseout","click","touchstart","touchmove"],hover:{onHover:null,mode:"nearest",intersect:!0,

animationDuration:400},onClick:null,defaultColor:"rgba(0,0,0,0.1)",defaultFontColor:"#666",defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:"normal",showLines:!0,elements:{},layout:{padding:{top:0,right:0,bottom:0,left:0}}});u.exports=function(){var l=function(h,f){this.construct(h,f);return this};return l.Chart=l}},{25:25}],30:[function(n,u,t){function l(a,e){return f.where(a,function(a){return a.position===e})}function h(a,e){a.forEach(function(a,

c){a._tmpIndex_=c;return a});a.sort(function(a,c){var d=e?c:a,f=e?a:c;return d.weight===f.weight?d._tmpIndex_-f._tmpIndex_:d.weight-f.weight});a.forEach(function(a){delete a._tmpIndex_})}var f=n(45);u.exports={defaults:{},addBox:function(a,e){a.boxes||(a.boxes=[]);e.fullWidth=e.fullWidth||!1;e.position=e.position||"top";e.weight=e.weight||0;a.boxes.push(e)},removeBox:function(a,e){var d=a.boxes?a.boxes.indexOf(e):-1;-1!==d&&a.boxes.splice(d,1)},configure:function(a,e,d){a=["fullWidth","position",

"weight"];for(var c=a.length,f=0,h;f<c;++f)h=a[f],d.hasOwnProperty(h)&&(e[h]=d[h])},update:function(a,e,d){function c(a){var c=f.findNextWhere(W,function(c){return c.box===a});c&&(a.isHorizontal()?a.update(a.fullWidth?A:t,K/2,{left:Math.max(Q,G),right:Math.max(V,I),top:0,bottom:0}):a.update(c.minSize.width,u))}function k(a){a.isHorizontal()?(a.left=a.fullWidth?v:Q,a.right=a.fullWidth?e-m:Q+t,a.top=P,a.bottom=P+a.height,P=a.bottom):(a.left=E,a.right=E+a.width,a.top=D,a.bottom=D+u,E=a.right)}if(a){var n=

f.options.toPadding((a.options.layout||{}).padding),v=n.left,m=n.right,p=n.top,q=n.bottom;n=l(a.boxes,"left");var x=l(a.boxes,"right"),y=l(a.boxes,"top"),w=l(a.boxes,"bottom"),F=l(a.boxes,"chartArea");h(n,!0);h(x,!1);h(y,!0);h(w,!1);var A=e-v-m,K=d-p-q,M=(e-A/2)/(n.length+x.length),L=(d-K/2)/(y.length+w.length),t=A,u=K,W=[];f.each(n.concat(x,y,w),function(a){var c=a.isHorizontal();if(c){var d=a.update(a.fullWidth?A:t,L);u-=d.height}else d=a.update(M,u),t-=d.width;W.push({horizontal:c,minSize:d,box:a})});

var G=0,I=0,H=0,N=0;f.each(y.concat(w),function(a){a.getPadding&&(a=a.getPadding(),G=Math.max(G,a.left),I=Math.max(I,a.right))});f.each(n.concat(x),function(a){a.getPadding&&(a=a.getPadding(),H=Math.max(H,a.top),N=Math.max(N,a.bottom))});var Q=v,V=m,D=p,X=q;f.each(n.concat(x),c);f.each(n,function(a){Q+=a.width});f.each(x,function(a){V+=a.width});f.each(y.concat(w),c);f.each(y,function(a){D+=a.height});f.each(w,function(a){X+=a.height});f.each(n.concat(x),function(a){var c=f.findNextWhere(W,function(c){return c.box===

a}),d={left:0,right:0,top:D,bottom:X};c&&a.update(c.minSize.width,u,d)});Q=v;V=m;D=p;X=q;f.each(n,function(a){Q+=a.width});f.each(x,function(a){V+=a.width});f.each(y,function(a){D+=a.height});f.each(w,function(a){X+=a.height});q=Math.max(G-Q,0);Q+=q;V+=Math.max(I-V,0);var la=Math.max(H-D,0);D+=la;X+=Math.max(N-X,0);var ca=d-D-X,ha=e-Q-V;if(ha!==t||ca!==u)f.each(n,function(a){a.height=ca}),f.each(x,function(a){a.height=ca}),f.each(y,function(a){a.fullWidth||(a.width=ha)}),f.each(w,function(a){a.fullWidth||

(a.width=ha)}),u=ca,t=ha;var E=v+q,P=p+la;f.each(n.concat(y),k);E+=t;P+=u;f.each(x,k);f.each(w,k);a.chartArea={left:Q,top:D,right:Q+t,bottom:D+u};f.each(F,function(c){c.left=a.chartArea.left;c.top=a.chartArea.top;c.right=a.chartArea.right;c.bottom=a.chartArea.bottom;c.update(t,u)})}}}},{45:45}],31:[function(n,u,t){var l=n(25),h=n(45);l._set("global",{plugins:{}});u.exports={_plugins:[],_cacheId:0,register:function(f){var a=this._plugins;[].concat(f).forEach(function(e){-1===a.indexOf(e)&&a.push(e)});

this._cacheId++},unregister:function(f){var a=this._plugins;[].concat(f).forEach(function(e){e=a.indexOf(e);-1!==e&&a.splice(e,1)});this._cacheId++},clear:function(){this._plugins=[];this._cacheId++},count:function(){return this._plugins.length},getAll:function(){return this._plugins},notify:function(f,a,e){var d=this.descriptors(f),c=d.length,h;for(h=0;h<c;++h){var l=d[h];var v=l.plugin;var m=v[a];if("function"===typeof m){var p=[f].concat(e||[]);p.push(l.options);if(!1===m.apply(v,p))return!1}}return!0},

descriptors:function(f){var a=f.$plugins||(f.$plugins={});if(a.id===this._cacheId)return a.descriptors;var e=[],d=[];f=f&&f.config||{};var c=f.options&&f.options.plugins||{};this._plugins.concat(f.plugins||[]).forEach(function(a){if(-1===e.indexOf(a)){var f=a.id,k=c[f];!1!==k&&(!0===k&&(k=h.clone(l.global.plugins[f])),e.push(a),d.push({plugin:a,options:k||{}}))}});a.descriptors=d;a.id=this._cacheId;return d},_invalidate:function(f){delete f.$plugins}}},{25:25,45:45}],32:[function(n,u,t){function l(a){var c=

[],d;var e=0;for(d=a.length;e<d;++e)c.push(a[e].label);return c}function h(a,c,e){var d=a.getPixelForTick(c);e&&(d=0===c?d-(a.getPixelForTick(1)-d)/2:d-(d-a.getPixelForTick(c-1))/2);return d}var f=n(25),a=n(26),e=n(45);n=n(34);f._set("scale",{display:!0,position:"left",offset:!1,gridLines:{display:!0,color:"rgba(0, 0, 0, 0.1)",lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:"rgba(0,0,0,0.25)",zeroLineBorderDash:[],zeroLineBorderDashOffset:0,

offsetGridLines:!1,borderDash:[],borderDashOffset:0},scaleLabel:{display:!1,labelString:"",lineHeight:1.2,padding:{top:4,bottom:4}},ticks:{beginAtZero:!1,minRotation:0,maxRotation:50,mirror:!1,padding:0,reverse:!1,display:!0,autoSkip:!0,autoSkipPadding:0,labelOffset:0,callback:n.formatters.values,minor:{},major:{}}});u.exports=function(d){function c(a,c,d){return e.isArray(c)?e.longestText(a,d,c):a.measureText(c).width}function k(a){var c=e.valueOrDefault,d=f.global,h=c(a.fontSize,d.defaultFontSize),

k=c(a.fontStyle,d.defaultFontStyle);a=c(a.fontFamily,d.defaultFontFamily);return{size:h,style:k,family:a,font:e.fontString(h,k,a)}}function n(a){return e.options.toLineHeight(e.valueOrDefault(a.lineHeight,1.2),e.valueOrDefault(a.fontSize,f.global.defaultFontSize))}d.Scale=a.extend({getPadding:function(){return{left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}},getTicks:function(){return this._ticks},mergeTicksOptions:function(){var a=this.options.ticks;

!1===a.minor&&(a.minor={display:!1});!1===a.major&&(a.major={display:!1});for(var c in a)"major"!==c&&"minor"!==c&&("undefined"===typeof a.minor[c]&&(a.minor[c]=a[c]),"undefined"===typeof a.major[c]&&(a.major[c]=a[c]))},beforeUpdate:function(){e.callback(this.options.beforeUpdate,[this])},update:function(a,c,d){var f;this.beforeUpdate();this.maxWidth=a;this.maxHeight=c;this.margins=e.extend({left:0,right:0,top:0,bottom:0},d);this.longestTextCache=this.longestTextCache||{};this.beforeSetDimensions();

this.setDimensions();this.afterSetDimensions();this.beforeDataLimits();this.determineDataLimits();this.afterDataLimits();this.beforeBuildTicks();var h=this.buildTicks()||[];this.afterBuildTicks();this.beforeTickToLabelConversion();d=this.convertTicksToLabels(h)||this.ticks;this.afterTickToLabelConversion();this.ticks=d;a=0;for(c=d.length;a<c;++a){var k=d[a];(f=h[a])?f.label=k:h.push({label:k,major:!1})}this._ticks=h;this.beforeCalculateTickRotation();this.calculateTickRotation();this.afterCalculateTickRotation();

this.beforeFit();this.fit();this.afterFit();this.afterUpdate();return this.minSize},afterUpdate:function(){e.callback(this.options.afterUpdate,[this])},beforeSetDimensions:function(){e.callback(this.options.beforeSetDimensions,[this])},setDimensions:function(){this.isHorizontal()?(this.width=this.maxWidth,this.left=0,this.right=this.width):(this.height=this.maxHeight,this.top=0,this.bottom=this.height);this.paddingBottom=this.paddingRight=this.paddingTop=this.paddingLeft=0},afterSetDimensions:function(){e.callback(this.options.afterSetDimensions,

[this])},beforeDataLimits:function(){e.callback(this.options.beforeDataLimits,[this])},determineDataLimits:e.noop,afterDataLimits:function(){e.callback(this.options.afterDataLimits,[this])},beforeBuildTicks:function(){e.callback(this.options.beforeBuildTicks,[this])},buildTicks:e.noop,afterBuildTicks:function(){e.callback(this.options.afterBuildTicks,[this])},beforeTickToLabelConversion:function(){e.callback(this.options.beforeTickToLabelConversion,[this])},convertTicksToLabels:function(){var a=this.options.ticks;

this.ticks=this.ticks.map(a.userCallback||a.callback,this)},afterTickToLabelConversion:function(){e.callback(this.options.afterTickToLabelConversion,[this])},beforeCalculateTickRotation:function(){e.callback(this.options.beforeCalculateTickRotation,[this])},calculateTickRotation:function(){var a=this.ctx,c=this.options.ticks,d=l(this._ticks),f=k(c);a.font=f.font;var h=c.minRotation||0;if(d.length&&this.options.display&&this.isHorizontal())for(f=a=e.longestText(a,f.font,d,this.longestTextCache),d=

this.getPixelForTick(1)-this.getPixelForTick(0)-6;f>d&&h<c.maxRotation;){var y=e.toRadians(h);f=Math.cos(y);y=Math.sin(y);if(y*a>this.maxHeight){h--;break}h++;f*=a}this.labelRotation=h},afterCalculateTickRotation:function(){e.callback(this.options.afterCalculateTickRotation,[this])},beforeFit:function(){e.callback(this.options.beforeFit,[this])},fit:function(){var a=this.minSize={width:0,height:0},d=l(this._ticks),f=this.options,h=f.ticks,x=f.scaleLabel,y=f.gridLines,w=f.display,F=this.isHorizontal(),

A=k(h),K=f.gridLines.tickMarkLength;a.width=F?this.isFullWidth()?this.maxWidth-this.margins.left-this.margins.right:this.maxWidth:w&&y.drawTicks?K:0;a.height=F?w&&y.drawTicks?K:0:this.maxHeight;x.display&&w&&(y=n(x),x=e.options.toPadding(x.padding),x=y+x.height,F?a.height+=x:a.width+=x);h.display&&w&&(x=e.longestText(this.ctx,A.font,d,this.longestTextCache),y=e.numberOfLabelLines(d),w=.5*A.size,K=this.options.ticks.padding,F?(this.longestLabelWidth=x,F=e.toRadians(this.labelRotation),h=Math.cos(F),

a.height=Math.min(this.maxHeight,a.height+(Math.sin(F)*x+A.size*y+w*(y-1)+w)+K),this.ctx.font=A.font,F=c(this.ctx,d[0],A.font),d=c(this.ctx,d[d.length-1],A.font),0!==this.labelRotation?(this.paddingLeft="bottom"===f.position?h*F+3:h*w+3,this.paddingRight="bottom"===f.position?h*w+3:h*d+3):(this.paddingLeft=F/2+3,this.paddingRight=d/2+3)):(x=h.mirror?0:x+(K+w),a.width=Math.min(this.maxWidth,a.width+x),this.paddingTop=A.size/2,this.paddingBottom=A.size/2));this.handleMargins();this.width=a.width;this.height=

a.height},handleMargins:function(){this.margins&&(this.paddingLeft=Math.max(this.paddingLeft-this.margins.left,0),this.paddingTop=Math.max(this.paddingTop-this.margins.top,0),this.paddingRight=Math.max(this.paddingRight-this.margins.right,0),this.paddingBottom=Math.max(this.paddingBottom-this.margins.bottom,0))},afterFit:function(){e.callback(this.options.afterFit,[this])},isHorizontal:function(){return"top"===this.options.position||"bottom"===this.options.position},isFullWidth:function(){return this.options.fullWidth},

getRightValue:function(a){if(e.isNullOrUndef(a)||"number"===typeof a&&!isFinite(a))return NaN;if(a)if(this.isHorizontal()){if(void 0!==a.x)return this.getRightValue(a.x)}else if(void 0!==a.y)return this.getRightValue(a.y);return a},getLabelForIndex:e.noop,getPixelForValue:e.noop,getValueForPixel:e.noop,getPixelForTick:function(a){var c=this.options.offset;if(this.isHorizontal()){var d=(this.width-(this.paddingLeft+this.paddingRight))/Math.max(this._ticks.length-(c?0:1),1);a=d*a+this.paddingLeft;c&&

(a+=d/2);c=this.left+Math.round(a);return c+=this.isFullWidth()?this.margins.left:0}return this.top+(this.height-(this.paddingTop+this.paddingBottom))/(this._ticks.length-1)*a},getPixelForDecimal:function(a){return this.isHorizontal()?(a=this.left+Math.round((this.width-(this.paddingLeft+this.paddingRight))*a+this.paddingLeft),a+=this.isFullWidth()?this.margins.left:0):this.top+a*this.height},getBasePixel:function(){return this.getPixelForValue(this.getBaseValue())},getBaseValue:function(){var a=

this.min,c=this.max;return this.beginAtZero?0:0>a&&0>c?c:0<a&&0<c?a:0},_autoSkip:function(a){var c=this.isHorizontal(),d=this.options.ticks.minor,f=a.length,h=e.toRadians(this.labelRotation),k=this.longestLabelWidth*Math.cos(h);h=[];if(d.maxTicksLimit)var w=d.maxTicksLimit;if(c){var l=!1;(k+d.autoSkipPadding)*f>this.width-(this.paddingLeft+this.paddingRight)&&(l=1+Math.floor((k+d.autoSkipPadding)*f/(this.width-(this.paddingLeft+this.paddingRight))));w&&f>w&&(l=Math.max(l,Math.floor(f/w)))}for(c=0;c<

f;c++)d=a[c],(w=1<l&&0<c%l||0===c%l&&c+l>=f)&&c!==f-1&&delete d.label,h.push(d);return h},draw:function(a){var c=this,d=c.options;if(d.display){var q=c.ctx,x=f.global,l=d.ticks.minor,w=d.ticks.major||l,F=d.gridLines,A=d.scaleLabel,v=0!==c.labelRotation,C=c.isHorizontal(),t=l.autoSkip?c._autoSkip(c.getTicks()):c.getTicks(),u=e.valueOrDefault(l.fontColor,x.defaultFontColor),J=k(l),W=e.valueOrDefault(w.fontColor,x.defaultFontColor),G=k(w),I=F.drawTicks?F.tickMarkLength:0;w=e.valueOrDefault(A.fontColor,

x.defaultFontColor);var H=k(A),N=e.options.toPadding(A.padding),Q=e.toRadians(c.labelRotation),V=[],D=c.options.gridLines.lineWidth,X="right"===d.position?c.right:c.right-D-I,la="right"===d.position?c.right+I:c.right,ca="bottom"===d.position?c.top+D:c.bottom-I-D,ha="bottom"===d.position?c.top+D+I:c.bottom+D;e.each(t,function(f,k){if(!e.isNullOrUndef(f.label)){var q=f.label;if(k===c.zeroLineIndex&&d.offset===F.offsetGridLines){var m=F.zeroLineWidth;var p=F.zeroLineColor;var w=F.zeroLineBorderDash;

var y=F.zeroLineBorderDashOffset}else m=e.valueAtIndexOrDefault(F.lineWidth,k),p=e.valueAtIndexOrDefault(F.color,k),w=e.valueOrDefault(F.borderDash,x.borderDash),y=e.valueOrDefault(F.borderDashOffset,x.borderDashOffset);var A,n,K,L="middle";var M=l.padding;if(C){var u=I+M;if("bottom"===d.position){L=v?"middle":"top";var ba=v?"right":"center";M=c.top+u}else L=v?"middle":"bottom",ba=v?"left":"center",M=c.bottom-u;var J=h(c,k,F.offsetGridLines&&1<t.length);J<c.left&&(p="rgba(0,0,0,0)");J+=e.aliasPixel(m);

u=c.getPixelForTick(k)+l.labelOffset;J=A=n=K=J;var G=ca;var W=ha;var E=a.top;var H=a.bottom+D}else u="left"===d.position,l.mirror?ba=u?"left":"right":(ba=u?"right":"left",M=I+M),u=u?c.right-M:c.left+M,G=h(c,k,F.offsetGridLines&&1<t.length),G<c.top&&(p="rgba(0,0,0,0)"),G+=e.aliasPixel(m),M=c.getPixelForTick(k)+l.labelOffset,J=X,A=la,n=a.left,K=a.right+D,G=W=E=H=G;V.push({tx1:J,ty1:G,tx2:A,ty2:W,x1:n,y1:E,x2:K,y2:H,labelX:u,labelY:M,glWidth:m,glColor:p,glBorderDash:w,glBorderDashOffset:y,rotation:-1*

Q,label:q,major:f.major,textBaseline:L,textAlign:ba})}});e.each(V,function(a){F.display&&(q.save(),q.lineWidth=a.glWidth,q.strokeStyle=a.glColor,q.setLineDash&&(q.setLineDash(a.glBorderDash),q.lineDashOffset=a.glBorderDashOffset),q.beginPath(),F.drawTicks&&(q.moveTo(a.tx1,a.ty1),q.lineTo(a.tx2,a.ty2)),F.drawOnChartArea&&(q.moveTo(a.x1,a.y1),q.lineTo(a.x2,a.y2)),q.stroke(),q.restore());if(l.display){q.save();q.translate(a.labelX,a.labelY);q.rotate(a.rotation);q.font=a.major?G.font:J.font;q.fillStyle=

a.major?W:u;q.textBaseline=a.textBaseline;q.textAlign=a.textAlign;a=a.label;if(e.isArray(a))for(var d=a.length,f=1.5*J.size,h=c.isHorizontal()?0:-f*(d-1)/2,k=0;k<d;++k)q.fillText(""+a[k],0,h),h+=f;else q.fillText(a,0,0);q.restore()}});if(A.display){var E=0,P=n(A)/2;if(C){var ea=c.left+(c.right-c.left)/2;N="bottom"===d.position?c.bottom-P-N.bottom:c.top+P+N.top}else ea=(E="left"===d.position)?c.left+P+N.top:c.right-P-N.top,N=c.top+(c.bottom-c.top)/2,E=E?-.5*Math.PI:.5*Math.PI;q.save();q.translate(ea,

N);q.rotate(E);q.textAlign="center";q.textBaseline="middle";q.fillStyle=w;q.font=H.font;q.fillText(A.labelString,0,0);q.restore()}F.drawBorder&&(q.lineWidth=e.valueAtIndexOrDefault(F.lineWidth,0),q.strokeStyle=e.valueAtIndexOrDefault(F.color,0),A=c.left,w=c.right+D,H=c.top,ea=c.bottom+D,N=e.aliasPixel(q.lineWidth),C?(H=ea="top"===d.position?c.bottom:c.top,H+=N,ea+=N):(A=w="left"===d.position?c.right:c.left,A+=N,w+=N),q.beginPath(),q.moveTo(A,H),q.lineTo(w,ea),q.stroke())}}})}},{25:25,26:26,34:34,

45:45}],33:[function(n,u,t){var l=n(25),h=n(45),f=n(30);u.exports=function(a){a.scaleService={constructors:{},defaults:{},registerScaleType:function(a,d,c){this.constructors[a]=d;this.defaults[a]=h.clone(c)},getScaleConstructor:function(a){return this.constructors.hasOwnProperty(a)?this.constructors[a]:void 0},getScaleDefaults:function(a){return this.defaults.hasOwnProperty(a)?h.merge({},[l.scale,this.defaults[a]]):{}},updateScaleDefaults:function(a,d){this.defaults.hasOwnProperty(a)&&(this.defaults[a]=

h.extend(this.defaults[a],d))},addScalesToLayout:function(a){h.each(a.scales,function(d){d.fullWidth=d.options.fullWidth;d.position=d.options.position;d.weight=d.options.weight;f.addBox(a,d)})}}}},{25:25,30:30,45:45}],34:[function(n,u,t){var l=n(45);u.exports={formatters:{values:function(h){return l.isArray(h)?h:""+h},linear:function(h,f,a){f=3<a.length?a[2]-a[1]:a[1]-a[0];1<Math.abs(f)&&h!==Math.floor(h)&&(f=h-Math.floor(h));f=l.log10(Math.abs(f));0!==h?(f=-1*Math.floor(f),f=Math.max(Math.min(f,

20),0),h=h.toFixed(f)):h="0";return h},logarithmic:function(h,f,a){var e=h/Math.pow(10,Math.floor(l.log10(h)));return 0===h?"0":1===e||2===e||5===e||0===f||f===a.length-1?h.toExponential():""}}}},{45:45}],35:[function(n,u,t){var l=n(25),h=n(26),f=n(45);l._set("global",{tooltips:{enabled:!0,custom:null,mode:"nearest",position:"average",intersect:!0,backgroundColor:"rgba(0,0,0,0.8)",titleFontStyle:"bold",titleSpacing:2,titleMarginBottom:6,titleFontColor:"#fff",titleAlign:"left",bodySpacing:2,bodyFontColor:"#fff",

bodyAlign:"left",footerFontStyle:"bold",footerSpacing:2,footerMarginTop:6,footerFontColor:"#fff",footerAlign:"left",yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:"#fff",displayColors:!0,borderColor:"rgba(0,0,0,0)",borderWidth:0,callbacks:{beforeTitle:f.noop,title:function(a,e){var d="",c=e.labels,f=c?c.length:0;if(0<a.length){var h=a[0];h.xLabel?d=h.xLabel:0<f&&h.index<f&&(d=c[h.index])}return d},afterTitle:f.noop,beforeBody:f.noop,beforeLabel:f.noop,label:function(a,

e){var d=e.datasets[a.datasetIndex].label||"";d&&(d+=": ");return d+=a.yLabel},labelColor:function(a,e){var d=e.getDatasetMeta(a.datasetIndex).data[a.index]._view;return{borderColor:d.borderColor,backgroundColor:d.backgroundColor}},labelTextColor:function(){return this._options.bodyFontColor},afterLabel:f.noop,afterBody:f.noop,beforeFooter:f.noop,footer:f.noop,afterFooter:f.noop}}});u.exports=function(a){function e(a,c){var d=f.color(a);return d.alpha(c*d.alpha()).rgbaString()}function d(a,c){c&&

(f.isArray(c)?Array.prototype.push.apply(a,c):a.push(c));return a}function c(a){var c=a._xScale,d=a._yScale||a._scale,e=a._index,f=a._datasetIndex;return{xLabel:c?c.getLabelForIndex(e,f):"",yLabel:d?d.getLabelForIndex(e,f):"",index:e,datasetIndex:f,x:a._model.x,y:a._model.y}}function k(a){var c=l.global,d=f.valueOrDefault;return{xPadding:a.xPadding,yPadding:a.yPadding,xAlign:a.xAlign,yAlign:a.yAlign,bodyFontColor:a.bodyFontColor,_bodyFontFamily:d(a.bodyFontFamily,c.defaultFontFamily),_bodyFontStyle:d(a.bodyFontStyle,

c.defaultFontStyle),_bodyAlign:a.bodyAlign,bodyFontSize:d(a.bodyFontSize,c.defaultFontSize),bodySpacing:a.bodySpacing,titleFontColor:a.titleFontColor,_titleFontFamily:d(a.titleFontFamily,c.defaultFontFamily),_titleFontStyle:d(a.titleFontStyle,c.defaultFontStyle),titleFontSize:d(a.titleFontSize,c.defaultFontSize),_titleAlign:a.titleAlign,titleSpacing:a.titleSpacing,titleMarginBottom:a.titleMarginBottom,footerFontColor:a.footerFontColor,_footerFontFamily:d(a.footerFontFamily,c.defaultFontFamily),_footerFontStyle:d(a.footerFontStyle,

c.defaultFontStyle),footerFontSize:d(a.footerFontSize,c.defaultFontSize),_footerAlign:a.footerAlign,footerSpacing:a.footerSpacing,footerMarginTop:a.footerMarginTop,caretSize:a.caretSize,cornerRadius:a.cornerRadius,backgroundColor:a.backgroundColor,opacity:0,legendColorBackground:a.multiKeyBackground,displayColors:a.displayColors,borderColor:a.borderColor,borderWidth:a.borderWidth}}function n(a,c){var d=a._chart.ctx,e=2*c.yPadding,h=0,k=c.body,m=k.reduce(function(a,c){return a+c.before.length+c.lines.length+

c.after.length},0);m+=c.beforeBody.length+c.afterBody.length;var q=c.title.length,l=c.footer.length,p=c.titleFontSize,n=c.bodyFontSize,v=c.footerFontSize;e=e+q*p+(q?(q-1)*c.titleSpacing:0);e+=q?c.titleMarginBottom:0;e=e+m*n+(m?(m-1)*c.bodySpacing:0);e+=l?c.footerMarginTop:0;e+=l*v;e+=l?(l-1)*c.footerSpacing:0;var C=0,t=function(a){h=Math.max(h,d.measureText(a).width+C)};d.font=f.fontString(p,c._titleFontStyle,c._titleFontFamily);f.each(c.title,t);d.font=f.fontString(n,c._bodyFontStyle,c._bodyFontFamily);

f.each(c.beforeBody.concat(c.afterBody),t);C=c.displayColors?n+2:0;f.each(k,function(a){f.each(a.before,t);f.each(a.lines,t);f.each(a.after,t)});C=0;d.font=f.fontString(v,c._footerFontStyle,c._footerFontFamily);f.each(c.footer,t);h+=2*c.xPadding;return{width:h,height:e}}function v(a,c){var d=a._model,e=a._chart,f=a._chart.chartArea,h="center",k="center";d.y<c.height?k="top":d.y>e.height-c.height&&(k="bottom");var m=(f.left+f.right)/2,q=(f.top+f.bottom)/2;if("center"===k){f=function(a){return a<=m};

var l=function(a){return a>m}}else f=function(a){return a<=c.width/2},l=function(a){return a>=e.width-c.width/2};var p=function(a){return a+c.width+d.caretSize+d.caretPadding>e.width};var n=function(a){return 0>a-c.width-d.caretSize-d.caretPadding};var v=function(a){return a<=q?"top":"bottom"};f(d.x)?(h="left",p(d.x)&&(h="center",k=v(d.y))):l(d.x)&&(h="right",n(d.x)&&(h="center",k=v(d.y)));f=a._options;return{xAlign:f.xAlign?f.xAlign:h,yAlign:f.yAlign?f.yAlign:k}}function m(a,c,d,e){var f=a.x,h=a.y,

k=a.caretPadding,m=d.xAlign;d=d.yAlign;var q=a.caretSize+k;a=a.cornerRadius+k;"right"===m?f-=c.width:"center"===m&&(f-=c.width/2,f+c.width>e.width&&(f=e.width-c.width),0>f&&(f=0));h="top"===d?h+q:"bottom"===d?h-(c.height+q):h-c.height/2;"center"===d?"left"===m?f+=q:"right"===m&&(f-=q):"left"===m?f-=a:"right"===m&&(f+=a);return{x:f,y:h}}a.Tooltip=h.extend({initialize:function(){this._model=k(this._options);this._lastActive=[]},getTitle:function(){var a=this._options.callbacks,c=a.beforeTitle.apply(this,

arguments),e=a.title.apply(this,arguments);a=a.afterTitle.apply(this,arguments);var f=[];f=d(f,c);f=d(f,e);return f=d(f,a)},getBeforeBody:function(){var a=this._options.callbacks.beforeBody.apply(this,arguments);return f.isArray(a)?a:void 0!==a?[a]:[]},getBody:function(a,c){var e=this,h=e._options.callbacks,k=[];f.each(a,function(a){var f={before:[],lines:[],after:[]};d(f.before,h.beforeLabel.call(e,a,c));d(f.lines,h.label.call(e,a,c));d(f.after,h.afterLabel.call(e,a,c));k.push(f)});return k},getAfterBody:function(){var a=

this._options.callbacks.afterBody.apply(this,arguments);return f.isArray(a)?a:void 0!==a?[a]:[]},getFooter:function(){var a=this._options.callbacks,c=a.beforeFooter.apply(this,arguments),e=a.footer.apply(this,arguments);a=a.afterFooter.apply(this,arguments);var f=[];f=d(f,c);f=d(f,e);return f=d(f,a)},update:function(d){var e=this,h=e._options,l=e._model,w=e._model=k(h),p=e._active,A=e._data,K={xAlign:l.xAlign,yAlign:l.yAlign},C={x:l.x,y:l.y},t={width:l.width,height:l.height};l={x:l.caretX,y:l.caretY};

if(p.length){w.opacity=1;var u=[],J=[];l=a.Tooltip.positioners[h.position].call(e,p,e._eventPosition);t=[];K=0;for(C=p.length;K<C;++K)t.push(c(p[K]));h.filter&&(t=t.filter(function(a){return h.filter(a,A)}));h.itemSort&&(t=t.sort(function(a,c){return h.itemSort(a,c,A)}));f.each(t,function(a){u.push(h.callbacks.labelColor.call(e,a,e._chart));J.push(h.callbacks.labelTextColor.call(e,a,e._chart))});w.title=e.getTitle(t,A);w.beforeBody=e.getBeforeBody(t,A);w.body=e.getBody(t,A);w.afterBody=e.getAfterBody(t,

A);w.footer=e.getFooter(t,A);w.x=Math.round(l.x);w.y=Math.round(l.y);w.caretPadding=h.caretPadding;w.labelColors=u;w.labelTextColors=J;w.dataPoints=t;t=n(this,w);K=v(this,t);C=m(w,t,K,e._chart)}else w.opacity=0;w.xAlign=K.xAlign;w.yAlign=K.yAlign;w.x=C.x;w.y=C.y;w.width=t.width;w.height=t.height;w.caretX=l.x;w.caretY=l.y;e._model=w;d&&h.custom&&h.custom.call(e,w);return e},drawCaret:function(a,c){var d=this._chart.ctx,e=this.getCaretPosition(a,c,this._view);d.lineTo(e.x1,e.y1);d.lineTo(e.x2,e.y2);

d.lineTo(e.x3,e.y3)},getCaretPosition:function(a,c,d){var e=d.caretSize;var f=d.cornerRadius;var h=d.xAlign;var k=d.yAlign;var m=a.x;a=a.y;var l=c.width;c=c.height;"center"===k?(k=a+c/2,"left"===h?(h=m,m=h-e,d=h,a=k+e,e=k-e):(h=m+l,m=h+e,d=h,a=k-e,e=k+e)):(m="left"===h?m+f+e:"right"===h?m+l-f-e:d.caretX,h=m-e,d=m+e,"top"===k?(k=a-e,e=a):(a+=c,k=a+e,e=a,c=d,d=h,h=c));return{x1:h,x2:m,x3:d,y1:a,y2:k,y3:e}},drawTitle:function(a,c,d,h){var k=c.title;if(k.length){d.textAlign=c._titleAlign;d.textBaseline=

"top";var m=c.titleFontSize,l=c.titleSpacing;d.fillStyle=e(c.titleFontColor,h);d.font=f.fontString(m,c._titleFontStyle,c._titleFontFamily);var q;h=0;for(q=k.length;h<q;++h)d.fillText(k[h],a.x,a.y),a.y+=m+l,h+1===k.length&&(a.y+=c.titleMarginBottom-l)}},drawBody:function(a,c,d,h){var k=c.bodyFontSize,m=c.bodySpacing,l=c.body;d.textAlign=c._bodyAlign;d.textBaseline="top";d.font=f.fontString(k,c._bodyFontStyle,c._bodyFontFamily);var q=0,x=function(c){d.fillText(c,a.x+q,a.y);a.y+=k+m};d.fillStyle=e(c.bodyFontColor,

h);f.each(c.beforeBody,x);var p=c.displayColors;q=p?k+2:0;f.each(l,function(m,l){var q=e(c.labelTextColors[l],h);d.fillStyle=q;f.each(m.before,x);f.each(m.lines,function(f){p&&(d.fillStyle=e(c.legendColorBackground,h),d.fillRect(a.x,a.y,k,k),d.lineWidth=1,d.strokeStyle=e(c.labelColors[l].borderColor,h),d.strokeRect(a.x,a.y,k,k),d.fillStyle=e(c.labelColors[l].backgroundColor,h),d.fillRect(a.x+1,a.y+1,k-2,k-2),d.fillStyle=q);x(f)});f.each(m.after,x)});q=0;f.each(c.afterBody,x);a.y-=m},drawFooter:function(a,

c,d,h){var k=c.footer;k.length&&(a.y+=c.footerMarginTop,d.textAlign=c._footerAlign,d.textBaseline="top",d.fillStyle=e(c.footerFontColor,h),d.font=f.fontString(c.footerFontSize,c._footerFontStyle,c._footerFontFamily),f.each(k,function(e){d.fillText(e,a.x,a.y);a.y+=c.footerFontSize+c.footerSpacing}))},drawBackground:function(a,c,d,f,h){d.fillStyle=e(c.backgroundColor,h);d.strokeStyle=e(c.borderColor,h);d.lineWidth=c.borderWidth;h=c.xAlign;var k=c.yAlign,m=a.x,l=a.y,q=f.width,w=f.height,x=c.cornerRadius;

d.beginPath();d.moveTo(m+x,l);"top"===k&&this.drawCaret(a,f);d.lineTo(m+q-x,l);d.quadraticCurveTo(m+q,l,m+q,l+x);"center"===k&&"right"===h&&this.drawCaret(a,f);d.lineTo(m+q,l+w-x);d.quadraticCurveTo(m+q,l+w,m+q-x,l+w);"bottom"===k&&this.drawCaret(a,f);d.lineTo(m+x,l+w);d.quadraticCurveTo(m,l+w,m,l+w-x);"center"===k&&"left"===h&&this.drawCaret(a,f);d.lineTo(m,l+x);d.quadraticCurveTo(m,l,m+x,l);d.closePath();d.fill();0<c.borderWidth&&d.stroke()},draw:function(){var a=this._chart.ctx,c=this._view;if(0!==

c.opacity){var d={width:c.width,height:c.height},e={x:c.x,y:c.y},f=Math.abs(.001>c.opacity)?0:c.opacity,h=c.title.length||c.beforeBody.length||c.body.length||c.afterBody.length||c.footer.length;this._options.enabled&&h&&(this.drawBackground(e,c,a,d,f),e.x+=c.xPadding,e.y+=c.yPadding,this.drawTitle(e,c,a,f),this.drawBody(e,c,a,f),this.drawFooter(e,c,a,f))}},handleEvent:function(a){var c=this._options,d;this._lastActive=this._lastActive||[];this._active="mouseout"===a.type?[]:this._chart.getElementsAtEventForMode(a,

c.mode,c);if(d=!f.arrayEquals(this._active,this._lastActive))if(this._lastActive=this._active,c.enabled||c.custom)this._eventPosition={x:a.x,y:a.y},this.update(!0),this.pivot();return d}});a.Tooltip.positioners={average:function(a){if(!a.length)return!1;var c,d=0,e=0,f=0;var h=0;for(c=a.length;h<c;++h){var k=a[h];k&&k.hasValue()&&(k=k.tooltipPosition(),d+=k.x,e+=k.y,++f)}return{x:Math.round(d/f),y:Math.round(e/f)}},nearest:function(a,c){var d=c.x,e=c.y,h=Number.POSITIVE_INFINITY,k;var m=0;for(k=a.length;m<

k;++m){var l=a[m];if(l&&l.hasValue()){var q=l.getCenterPoint();q=f.distanceBetweenPoints(c,q);if(q<h){h=q;var p=l}}}p&&(e=p.tooltipPosition(),d=e.x,e=e.y);return{x:d,y:e}}}}},{25:25,26:26,45:45}],36:[function(n,u,t){t=n(25);var l=n(26),h=n(45);t._set("global",{elements:{arc:{backgroundColor:t.global.defaultColor,borderColor:"#fff",borderWidth:2}}});u.exports=l.extend({inLabelRange:function(f){var a=this._view;return a?Math.pow(f-a.x,2)<Math.pow(a.radius+a.hoverRadius,2):!1},inRange:function(f,a){var e=

this._view;if(e){var d=h.getAngleFromPoint(e,{x:f,y:a}),c=d.angle,k=d.distance;d=e.startAngle;for(var l=e.endAngle;l<d;)l+=2*Math.PI;for(;c>l;)c-=2*Math.PI;for(;c<d;)c+=2*Math.PI;e=k>=e.innerRadius&&k<=e.outerRadius;return c>=d&&c<=l&&e}return!1},getCenterPoint:function(){var f=this._view,a=(f.startAngle+f.endAngle)/2,e=(f.innerRadius+f.outerRadius)/2;return{x:f.x+Math.cos(a)*e,y:f.y+Math.sin(a)*e}},getArea:function(){var f=this._view;return(f.endAngle-f.startAngle)/(2*Math.PI)*Math.PI*(Math.pow(f.outerRadius,

2)-Math.pow(f.innerRadius,2))},tooltipPosition:function(){var f=this._view,a=f.startAngle+(f.endAngle-f.startAngle)/2,e=(f.outerRadius-f.innerRadius)/2+f.innerRadius;return{x:f.x+Math.cos(a)*e,y:f.y+Math.sin(a)*e}},draw:function(){var f=this._chart.ctx,a=this._view,e=a.startAngle,d=a.endAngle;f.beginPath();f.arc(a.x,a.y,a.outerRadius,e,d);f.arc(a.x,a.y,a.innerRadius,d,e,!0);f.closePath();f.strokeStyle=a.borderColor;f.lineWidth=a.borderWidth;f.fillStyle=a.backgroundColor;f.fill();f.lineJoin="bevel";

a.borderWidth&&f.stroke()}})},{25:25,26:26,45:45}],37:[function(n,u,t){t=n(25);var l=n(26),h=n(45),f=t.global;t._set("global",{elements:{line:{tension:.4,backgroundColor:f.defaultColor,borderWidth:3,borderColor:f.defaultColor,borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",capBezierPoints:!0,fill:!0}}});u.exports=l.extend({draw:function(){var a=this._view,e=this._chart.ctx,d=a.spanGaps,c=this._children.slice(),k=f.elements.line;this._loop&&c.length&&c.push(c[0]);e.save();

e.lineCap=a.borderCapStyle||k.borderCapStyle;e.setLineDash&&e.setLineDash(a.borderDash||k.borderDash);e.lineDashOffset=a.borderDashOffset||k.borderDashOffset;e.lineJoin=a.borderJoinStyle||k.borderJoinStyle;e.lineWidth=a.borderWidth||k.borderWidth;e.strokeStyle=a.borderColor||f.defaultColor;e.beginPath();a=-1;for(k=0;k<c.length;++k){var l=c[k];var n=h.previousItem(c,k);var m=l._view;0===k?m.skip||(e.moveTo(m.x,m.y),a=k):(n=-1===a?n:c[a],m.skip||(a!==k-1&&!d||-1===a?e.moveTo(m.x,m.y):h.canvas.lineTo(e,

n._view,l._view),a=k))}e.stroke();e.restore()}})},{25:25,26:26,45:45}],38:[function(n,u,t){function l(a){var d=this._view;return d?Math.abs(a-d.x)<d.radius+d.hitRadius:!1}var h=n(25);t=n(26);var f=n(45),a=h.global.defaultColor;h._set("global",{elements:{point:{radius:3,pointStyle:"circle",backgroundColor:a,borderColor:a,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}});u.exports=t.extend({inRange:function(a,d){var c=this._view;return c?Math.pow(a-c.x,2)+Math.pow(d-c.y,2)<Math.pow(c.hitRadius+

c.radius,2):!1},inLabelRange:l,inXRange:l,inYRange:function(a){var d=this._view;return d?Math.abs(a-d.y)<d.radius+d.hitRadius:!1},getCenterPoint:function(){var a=this._view;return{x:a.x,y:a.y}},getArea:function(){return Math.PI*Math.pow(this._view.radius,2)},tooltipPosition:function(){var a=this._view;return{x:a.x,y:a.y,padding:a.radius+a.borderWidth}},draw:function(e){var d=this._view,c=this._model,k=this._chart.ctx,l=d.pointStyle,n=d.radius,m=d.x,p=d.y,q=f.color,x=0;d.skip||(k.strokeStyle=d.borderColor||

a,k.lineWidth=f.valueOrDefault(d.borderWidth,h.global.elements.point.borderWidth),k.fillStyle=d.backgroundColor||a,void 0!==e&&(c.x<e.left||1.01*e.right<c.x||c.y<e.top||1.01*e.bottom<c.y)&&(c.x<e.left?x=(m-c.x)/(e.left-c.x):1.01*e.right<c.x?x=(c.x-m)/(c.x-e.right):c.y<e.top?x=(p-c.y)/(e.top-c.y):1.01*e.bottom<c.y&&(x=(c.y-p)/(c.y-e.bottom)),x=Math.round(100*x)/100,k.strokeStyle=q(k.strokeStyle).alpha(x).rgbString(),k.fillStyle=q(k.fillStyle).alpha(x).rgbString()),f.canvas.drawPoint(k,l,n,m,p))}})},

{25:25,26:26,45:45}],39:[function(n,u,t){function l(h){var f=h._view;if(void 0!==h._view.width){var a=f.width/2;h=f.x-a;a=f.x+a;var e=Math.min(f.y,f.base);f=Math.max(f.y,f.base)}else{var d=f.height/2;h=Math.min(f.x,f.base);a=Math.max(f.x,f.base);e=f.y-d;f=f.y+d}return{left:h,top:e,right:a,bottom:f}}t=n(25);n=n(26);t._set("global",{elements:{rectangle:{backgroundColor:t.global.defaultColor,borderColor:t.global.defaultColor,borderSkipped:"bottom",borderWidth:0}}});u.exports=n.extend({draw:function(){var h=

this._chart.ctx,f=this._view,a=f.borderWidth;if(f.horizontal){var e=f.base;var d=f.x;var c=f.y-f.height/2;var k=f.y+f.height/2;var l=d>e?1:-1;var n=1;var m=f.borderSkipped||"left"}else e=f.x-f.width/2,d=f.x+f.width/2,c=f.y,k=f.base,l=1,n=k>c?1:-1,m=f.borderSkipped||"bottom";if(a){var p=Math.min(Math.abs(e-d),Math.abs(c-k));a=a>p?p:a;var q=a/2;p=e+("left"!==m?q*l:0);l=d+("right"!==m?-q*l:0);var x=c+("top"!==m?q*n:0);n=k+("bottom"!==m?-q*n:0);p!==l&&(c=x,k=n);x!==n&&(e=p,d=l)}h.beginPath();h.fillStyle=

f.backgroundColor;h.strokeStyle=f.borderColor;h.lineWidth=a;f=[[e,k],[e,c],[d,c],[d,k]];m=["bottom","left","top","right"].indexOf(m,0);-1===m&&(m=0);e=f[(m+0)%4];h.moveTo(e[0],e[1]);for(d=1;4>d;d++)e=f[(m+d)%4],h.lineTo(e[0],e[1]);h.fill();a&&h.stroke()},height:function(){var h=this._view;return h.base-h.y},inRange:function(h,f){var a=!1;this._view&&(a=l(this),a=h>=a.left&&h<=a.right&&f>=a.top&&f<=a.bottom);return a},inLabelRange:function(h,f){if(!this._view)return!1;var a=l(this);return void 0!==

this._view.width?h>=a.left&&h<=a.right:f>=a.top&&f<=a.bottom},inXRange:function(h){var f=l(this);return h>=f.left&&h<=f.right},inYRange:function(h){var f=l(this);return h>=f.top&&h<=f.bottom},getCenterPoint:function(){var h=this._view;if(void 0!==this._view.width){var f=h.x;h=(h.y+h.base)/2}else f=(h.x+h.base)/2,h=h.y;return{x:f,y:h}},getArea:function(){var h=this._view;return h.width*Math.abs(h.y-h.base)},tooltipPosition:function(){var h=this._view;return{x:h.x,y:h.y}}})},{25:25,26:26}],40:[function(n,

u,t){u.exports={};u.exports.Arc=n(36);u.exports.Line=n(37);u.exports.Point=n(38);u.exports.Rectangle=n(39)},{36:36,37:37,38:38,39:39}],41:[function(n,u,t){n=n(42);t=u.exports={clear:function(l){l.ctx.clearRect(0,0,l.width,l.height)},roundedRect:function(l,h,f,a,e,d){if(d){var c=Math.min(d,a/2);d=Math.min(d,e/2);l.moveTo(h+c,f);l.lineTo(h+a-c,f);l.quadraticCurveTo(h+a,f,h+a,f+d);l.lineTo(h+a,f+e-d);l.quadraticCurveTo(h+a,f+e,h+a-c,f+e);l.lineTo(h+c,f+e);l.quadraticCurveTo(h,f+e,h,f+e-d);l.lineTo(h,

f+d);l.quadraticCurveTo(h,f,h+c,f)}else l.rect(h,f,a,e)},drawPoint:function(l,h,f,a,e){if(h&&"object"===typeof h){var d=h.toString();if("[object HTMLImageElement]"===d||"[object HTMLCanvasElement]"===d){l.drawImage(h,a-h.width/2,e-h.height/2,h.width,h.height);return}}if(!(isNaN(f)||0>=f)){switch(h){default:l.beginPath();l.arc(a,e,f,0,2*Math.PI);l.closePath();l.fill();break;case "triangle":l.beginPath();f=3*f/Math.sqrt(3);h=f*Math.sqrt(3)/2;l.moveTo(a-f/2,e+h/3);l.lineTo(a+f/2,e+h/3);l.lineTo(a,e-

2*h/3);l.closePath();l.fill();break;case "rect":f*=1/Math.SQRT2;l.beginPath();l.fillRect(a-f,e-f,2*f,2*f);l.strokeRect(a-f,e-f,2*f,2*f);break;case "rectRounded":h=f/Math.SQRT2;a-=h;e-=h;h=Math.SQRT2*f;l.beginPath();this.roundedRect(l,a,e,h,h,f/2);l.closePath();l.fill();break;case "rectRot":f*=1/Math.SQRT2;l.beginPath();l.moveTo(a-f,e);l.lineTo(a,e+f);l.lineTo(a+f,e);l.lineTo(a,e-f);l.closePath();l.fill();break;case "cross":l.beginPath();l.moveTo(a,e+f);l.lineTo(a,e-f);l.moveTo(a-f,e);l.lineTo(a+f,

e);l.closePath();break;case "crossRot":l.beginPath();h=Math.cos(Math.PI/4)*f;f*=Math.sin(Math.PI/4);l.moveTo(a-h,e-f);l.lineTo(a+h,e+f);l.moveTo(a-h,e+f);l.lineTo(a+h,e-f);l.closePath();break;case "star":l.beginPath();l.moveTo(a,e+f);l.lineTo(a,e-f);l.moveTo(a-f,e);l.lineTo(a+f,e);h=Math.cos(Math.PI/4)*f;f*=Math.sin(Math.PI/4);l.moveTo(a-h,e-f);l.lineTo(a+h,e+f);l.moveTo(a-h,e+f);l.lineTo(a+h,e-f);l.closePath();break;case "line":l.beginPath();l.moveTo(a-f,e);l.lineTo(a+f,e);l.closePath();break;case "dash":l.beginPath(),

l.moveTo(a,e),l.lineTo(a+f,e),l.closePath()}l.stroke()}},clipArea:function(l,h){l.save();l.beginPath();l.rect(h.left,h.top,h.right-h.left,h.bottom-h.top);l.clip()},unclipArea:function(l){l.restore()},lineTo:function(l,h,f,a){f.steppedLine?("after"===f.steppedLine&&!a||"after"!==f.steppedLine&&a?l.lineTo(h.x,f.y):l.lineTo(f.x,h.y),l.lineTo(f.x,f.y)):f.tension?l.bezierCurveTo(a?h.controlPointPreviousX:h.controlPointNextX,a?h.controlPointPreviousY:h.controlPointNextY,a?f.controlPointNextX:f.controlPointPreviousX,

a?f.controlPointNextY:f.controlPointPreviousY,f.x,f.y):l.lineTo(f.x,f.y)}};n.clear=t.clear;n.drawRoundedRectangle=function(l){l.beginPath();t.roundedRect.apply(t,arguments);l.closePath()}},{42:42}],42:[function(n,u,t){var l={noop:function(){},uid:function(){var h=0;return function(){return h++}}(),isNullOrUndef:function(h){return null===h||"undefined"===typeof h},isArray:Array.isArray?Array.isArray:function(h){return"[object Array]"===Object.prototype.toString.call(h)},isObject:function(h){return null!==

h&&"[object Object]"===Object.prototype.toString.call(h)},valueOrDefault:function(h,f){return"undefined"===typeof h?f:h},valueAtIndexOrDefault:function(h,f,a){return l.valueOrDefault(l.isArray(h)?h[f]:h,a)},callback:function(h,f,a){if(h&&"function"===typeof h.call)return h.apply(a,f)},each:function(h,f,a,e){if(l.isArray(h)){var d=h.length;if(e)for(e=d-1;0<=e;e--)f.call(a,h[e],e);else for(e=0;e<d;e++)f.call(a,h[e],e)}else if(l.isObject(h)){var c=Object.keys(h);d=c.length;for(e=0;e<d;e++)f.call(a,h[c[e]],

c[e])}},arrayEquals:function(h,f){var a;if(!h||!f||h.length!==f.length)return!1;var e=0;for(a=h.length;e<a;++e){var d=h[e];var c=f[e];if(d instanceof Array&&c instanceof Array){if(!l.arrayEquals(d,c))return!1}else if(d!==c)return!1}return!0},clone:function(h){if(l.isArray(h))return h.map(l.clone);if(l.isObject(h)){for(var f={},a=Object.keys(h),e=a.length,d=0;d<e;++d)f[a[d]]=l.clone(h[a[d]]);return f}return h},_merger:function(h,f,a,e){var d=f[h];a=a[h];l.isObject(d)&&l.isObject(a)?l.merge(d,a,e):

f[h]=l.clone(a)},_mergerIf:function(h,f,a){var e=f[h];a=a[h];l.isObject(e)&&l.isObject(a)?l.mergeIf(e,a):f.hasOwnProperty(h)||(f[h]=l.clone(a))},merge:function(h,f,a){var e=l.isArray(f)?f:[f],d=e.length,c,k;if(!l.isObject(h))return h;a=a||{};var n=a.merger||l._merger;for(c=0;c<d;++c)if(f=e[c],l.isObject(f)){var v=Object.keys(f);var m=0;for(k=v.length;m<k;++m)n(v[m],h,f,a)}return h},mergeIf:function(h,f){return l.merge(h,f,{merger:l._mergerIf})},extend:function(h){for(var f=function(a,c){h[c]=a},a=

1,e=arguments.length;a<e;++a)l.each(arguments[a],f);return h},inherits:function(h){var f=this,a=h&&h.hasOwnProperty("constructor")?h.constructor:function(){return f.apply(this,arguments)},e=function(){this.constructor=a};e.prototype=f.prototype;a.prototype=new e;a.extend=l.inherits;h&&l.extend(a.prototype,h);a.__super__=f.prototype;return a}};u.exports=l;l.callCallback=l.callback;l.indexOf=function(h,f,a){return Array.prototype.indexOf.call(h,f,a)};l.getValueOrDefault=l.valueOrDefault;l.getValueAtIndexOrDefault=

l.valueAtIndexOrDefault},{}],43:[function(n,u,t){n=n(42);var l={linear:function(h){return h},easeInQuad:function(h){return h*h},easeOutQuad:function(h){return-h*(h-2)},easeInOutQuad:function(h){return 1>(h/=.5)?.5*h*h:-.5*(--h*(h-2)-1)},easeInCubic:function(h){return h*h*h},easeOutCubic:function(h){return--h*h*h+1},easeInOutCubic:function(h){return 1>(h/=.5)?.5*h*h*h:.5*((h-=2)*h*h+2)},easeInQuart:function(h){return h*h*h*h},easeOutQuart:function(h){return-(--h*h*h*h-1)},easeInOutQuart:function(h){return 1>

(h/=.5)?.5*h*h*h*h:-.5*((h-=2)*h*h*h-2)},easeInQuint:function(h){return h*h*h*h*h},easeOutQuint:function(h){return--h*h*h*h*h+1},easeInOutQuint:function(h){return 1>(h/=.5)?.5*h*h*h*h*h:.5*((h-=2)*h*h*h*h+2)},easeInSine:function(h){return-Math.cos(Math.PI/2*h)+1},easeOutSine:function(h){return Math.sin(Math.PI/2*h)},easeInOutSine:function(h){return-.5*(Math.cos(Math.PI*h)-1)},easeInExpo:function(h){return 0===h?0:Math.pow(2,10*(h-1))},easeOutExpo:function(h){return 1===h?1:-Math.pow(2,-10*h)+1},easeInOutExpo:function(h){return 0===

h?0:1===h?1:1>(h/=.5)?.5*Math.pow(2,10*(h-1)):.5*(-Math.pow(2,-10*--h)+2)},easeInCirc:function(h){return 1<=h?h:-(Math.sqrt(1-h*h)-1)},easeOutCirc:function(h){return Math.sqrt(1- --h*h)},easeInOutCirc:function(h){return 1>(h/=.5)?-.5*(Math.sqrt(1-h*h)-1):.5*(Math.sqrt(1-(h-=2)*h)+1)},easeInElastic:function(h){var f=0,a=1;if(0===h)return 0;if(1===h)return 1;f||(f=.3);if(1>a){a=1;var e=f/4}else e=f/(2*Math.PI)*Math.asin(1/a);return-(a*Math.pow(2,10*--h)*Math.sin(2*(h-e)*Math.PI/f))},easeOutElastic:function(h){var f=

0,a=1;if(0===h)return 0;if(1===h)return 1;f||(f=.3);if(1>a){a=1;var e=f/4}else e=f/(2*Math.PI)*Math.asin(1/a);return a*Math.pow(2,-10*h)*Math.sin(2*(h-e)*Math.PI/f)+1},easeInOutElastic:function(h){var f=0,a=1;if(0===h)return 0;if(2===(h/=.5))return 1;f||(f=.45);if(1>a){a=1;var e=f/4}else e=f/(2*Math.PI)*Math.asin(1/a);return 1>h?-.5*a*Math.pow(2,10*--h)*Math.sin(2*(h-e)*Math.PI/f):a*Math.pow(2,-10*--h)*Math.sin(2*(h-e)*Math.PI/f)*.5+1},easeInBack:function(h){return h*h*(2.70158*h-1.70158)},easeOutBack:function(h){return--h*

h*(2.70158*h+1.70158)+1},easeInOutBack:function(h){var f=1.70158;return 1>(h/=.5)?.5*h*h*(((f*=1.525)+1)*h-f):.5*((h-=2)*h*(((f*=1.525)+1)*h+f)+2)},easeInBounce:function(h){return 1-l.easeOutBounce(1-h)},easeOutBounce:function(h){return h<1/2.75?7.5625*h*h:h<2/2.75?7.5625*(h-=1.5/2.75)*h+.75:h<2.5/2.75?7.5625*(h-=2.25/2.75)*h+.9375:7.5625*(h-=2.625/2.75)*h+.984375},easeInOutBounce:function(h){return.5>h?.5*l.easeInBounce(2*h):.5*l.easeOutBounce(2*h-1)+.5}};u.exports={effects:l};n.easingEffects=l},

{42:42}],44:[function(n,u,t){var l=n(42);u.exports={toLineHeight:function(h,f){var a=(""+h).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);if(!a||"normal"===a[1])return 1.2*f;h=+a[2];switch(a[3]){case "px":return h;case "%":h/=100}return f*h},toPadding:function(h){if(l.isObject(h)){var f=+h.top||0;var a=+h.right||0;var e=+h.bottom||0;h=+h.left||0}else f=a=e=h=+h||0;return{top:f,right:a,bottom:e,left:h,height:f+e,width:h+a}},resolve:function(h,f,a){var e;var d=0;for(e=h.length;d<e;++d){var c=h[d];if(void 0!==

c&&(void 0!==f&&"function"===typeof c&&(c=c(f)),void 0!==a&&l.isArray(c)&&(c=c[a]),void 0!==c))return c}}}},{42:42}],45:[function(n,u,t){u.exports=n(42);u.exports.easing=n(43);u.exports.canvas=n(41);u.exports.options=n(44)},{41:41,42:42,43:43,44:44}],46:[function(n,u,t){u.exports={acquireContext:function(l){l&&l.canvas&&(l=l.canvas);return l&&l.getContext("2d")||null}}},{}],47:[function(n,u,t){function l(a,c){var d=v.getStyle(a,c);return(d=d&&d.match(/^(\d+)(\.\d+)?px$/))?Number(d[1]):void 0}function h(a,

c,d){a.addEventListener(c,d,q)}function f(a,c,d){a.removeEventListener(c,d,q)}function a(a,c,d,e,f){return{type:a,chart:c,"native":f||null,x:void 0!==d?d:null,y:void 0!==e?e:null}}function e(a,c){var d=!1,e=[];return function(){e=Array.prototype.slice.call(arguments);c=c||this;d||(d=!0,v.requestAnimFrame.call(window,function(){d=!1;a.apply(c,e)}))}}function d(a){var c=document.createElement("div");c.style.cssText="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;";

c.className="chartjs-size-monitor";c.innerHTML='<div class="chartjs-size-monitor-expand" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div></div><div class="chartjs-size-monitor-shrink" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:200%;height:200%;left:0; top:0"></div></div>';

var d=c.childNodes[0],e=c.childNodes[1];c._reset=function(){d.scrollLeft=1E6;d.scrollTop=1E6;e.scrollLeft=1E6;e.scrollTop=1E6};var f=function(){c._reset();a()};h(d,"scroll",f.bind(d,"expand"));h(e,"scroll",f.bind(e,"shrink"));return c}function c(a,c){var d=a.$chartjs||(a.$chartjs={}),e=d.renderProxy=function(a){"chartjs-render-animation"===a.animationName&&c()};v.each(m,function(c){h(a,c,e)});d.reflow=!!a.offsetParent;a.classList.add("chartjs-render-monitor")}function k(a){var c=a.$chartjs||{},d=

c.renderProxy;d&&(v.each(m,function(c){f(a,c,d)}),delete c.renderProxy);a.classList.remove("chartjs-render-monitor")}function C(f,h,k){var m=f.$chartjs||(f.$chartjs={}),l=m.resizer=d(e(function(){if(m.resizer)return h(a("resize",k))}));c(f,function(){if(m.resizer){var a=f.parentNode;a&&a!==l.parentNode&&a.insertBefore(l,a.firstChild);l._reset()}})}var v=n(45),m=["animationstart","webkitAnimationStart"],p={touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup",pointerenter:"mouseenter",pointerdown:"mousedown",

pointermove:"mousemove",pointerup:"mouseup",pointerleave:"mouseout",pointerout:"mouseout"},q=function(){var a=!1;try{var c=Object.defineProperty({},"passive",{get:function(){a=!0}});window.addEventListener("e",null,c)}catch(w){}return a}()?{passive:!0}:!1;u.exports={_enabled:"undefined"!==typeof window&&"undefined"!==typeof document,initialize:function(){var a="@-webkit-keyframes chartjs-render-animation{from{opacity:0.99}to{opacity:1}}@keyframes chartjs-render-animation{from{opacity:0.99}to{opacity:1}}.chartjs-render-monitor{-webkit-animation:chartjs-render-animation 0.001s;animation:chartjs-render-animation 0.001s;}",

c=this._style||document.createElement("style");this._style||(this._style=c,a="/* Chart.js */\n"+a,c.setAttribute("type","text/css"),document.getElementsByTagName("head")[0].appendChild(c));c.appendChild(document.createTextNode(a))},acquireContext:function(a,c){"string"===typeof a?a=document.getElementById(a):a.length&&(a=a[0]);a&&a.canvas&&(a=a.canvas);var d=a&&a.getContext&&a.getContext("2d");if(d&&d.canvas===a){var e=a,f=e.style,h=e.getAttribute("height"),k=e.getAttribute("width");e.$chartjs={initial:{height:h,

width:k,style:{display:f.display,height:f.height,width:f.width}}};f.display=f.display||"block";if(null===k||""===k){var m=l(e,"width");void 0!==m&&(e.width=m)}if(null===h||""===h)""===e.style.height?e.height=e.width/(c.options.aspectRatio||2):(f=l(e,"height"),void 0!==m&&(e.height=f));return d}return null},releaseContext:function(a){var c=a.canvas;if(c.$chartjs){var d=c.$chartjs.initial;["height","width"].forEach(function(a){var e=d[a];v.isNullOrUndef(e)?c.removeAttribute(a):c.setAttribute(a,e)});

v.each(d.style||{},function(a,d){c.style[d]=a});c.width=c.width;delete c.$chartjs}},addEventListener:function(c,d,e){var f=c.canvas;if("resize"===d)C(f,e,c);else{var k=e.$chartjs||(e.$chartjs={});k=(k.proxies||(k.proxies={}))[c.id+"_"+d]=function(d){var f=p[d.type]||d.type,h=v.getRelativePosition(d,c);d=a(f,c,h.x,h.y,d);e(d)};h(f,d,k)}},removeEventListener:function(a,c,d){var e=a.canvas;"resize"===c?(c=e.$chartjs||{},a=c.resizer,delete c.resizer,k(e),a&&a.parentNode&&a.parentNode.removeChild(a)):

(a=((d.$chartjs||{}).proxies||{})[a.id+"_"+c])&&f(e,c,a)}};v.addEvent=h;v.removeEvent=f},{45:45}],48:[function(n,u,t){t=n(45);var l=n(46);n=n(47);u.exports=t.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},n._enabled?n:l)},{45:45,46:46,47:47}],49:[function(n,u,t){u.exports={};u.exports.filler=n(50);u.exports.legend=n(51);u.exports.title=n(52)},{50:50,51:51,52:52}],50:[function(n,u,t){function l(a,

c,d){var e=a._model||{};a=e.fill;void 0===a&&(a=!!e.backgroundColor);if(!1===a||null===a)return!1;if(!0===a)return"origin";e=parseFloat(a,10);if(isFinite(e)&&Math.floor(e)===e){if("-"===a[0]||"+"===a[0])e=c+e;return e===c||0>e||e>=d?!1:e}switch(a){case "bottom":return"start";case "top":return"end";case "zero":return"origin";case "origin":case "start":case "end":return a;default:return!1}}function h(a){var c=a.el._model||{},d=a.el._scale||{},e=a.fill;a=null;if(isFinite(e))return null;"start"===e?a=

void 0===c.scaleBottom?d.bottom:c.scaleBottom:"end"===e?a=void 0===c.scaleTop?d.top:c.scaleTop:void 0!==c.scaleZero?a=c.scaleZero:d.getBasePosition?a=d.getBasePosition():d.getBasePixel&&(a=d.getBasePixel());if(void 0!==a&&null!==a){if(void 0!==a.x&&void 0!==a.y)return a;if("number"===typeof a&&isFinite(a))return c=d.isHorizontal(),{x:c?a:null,y:c?null:a}}return null}function f(a,c,e,f,h){var k;if(f&&h){a.moveTo(c[0].x,c[0].y);for(k=1;k<f;++k)d.canvas.lineTo(a,c[k-1],c[k]);a.lineTo(e[h-1].x,e[h-1].y);

for(k=h-1;0<k;--k)d.canvas.lineTo(a,e[k],e[k-1],!0)}}var a=n(25),e=n(40),d=n(45);a._set("global",{plugins:{filler:{propagate:!0}}});var c={dataset:function(a){var c=a.fill;a=a.chart;var d=a.getDatasetMeta(c),e=d&&a.isDatasetVisible(c)&&d.dataset._children||[],f=e.length||0;return f?function(a,c){return c<f&&e[c]._view||null}:null},boundary:function(a){var c=(a=a.boundary)?a.x:null,d=a?a.y:null;return function(a){return{x:null===c?a.x:c,y:null===d?a.y:d}}}};u.exports={id:"filler",afterDatasetsUpdate:function(a,

d){var f=(a.data.datasets||[]).length,k=d.propagate,p=[],q;for(q=0;q<f;++q){var n=a.getDatasetMeta(q);var y=n.dataset;var w=null;y&&y._model&&y instanceof e.Line&&(w={visible:a.isDatasetVisible(q),fill:l(y,q,f),chart:a,el:y});n.$filler=w;p.push(w)}for(q=0;q<f;++q)if(w=p[q]){n=w;a:{var t=p,A=t[q].fill,u=[q];if(k){for(;!1!==A&&-1===u.indexOf(A);){if(!isFinite(A)){y=A;break a}y=t[A];if(!y)break;if(y.visible){y=A;break a}u.push(A);A=y.fill}y=!1}else y=A}n.fill=y;w.boundary=h(w);n=w;y=w.fill;t="dataset";

!1===y?w=null:(isFinite(y)||(t="boundary"),w=c[t](w));n.mapper=w}},beforeDatasetDraw:function(c,e){var h=e.meta.$filler;if(h){var k=c.ctx,l=h.el,q=l._view,n=l._children||[];h=h.mapper;var y=q.backgroundColor||a.global.defaultColor;if(h&&y&&n.length){d.canvas.clipArea(k,c.chartArea);var w=l._loop;l=n.length;var t=q.spanGaps,A=[],u=[],C=0,L=0;k.beginPath();var ba=0;for(w=l+!!w;ba<w;++ba){var J=ba%l;var W=n[J]._view;J=h(W,J,q);var G=W&&!W.skip;var I=J&&!J.skip;G&&I?(C=A.push(W),L=u.push(J)):C&&L&&(t?

(G&&A.push(W),I&&u.push(J)):(f(k,A,u,C,L),C=L=0,A=[],u=[]))}f(k,A,u,C,L);k.closePath();k.fillStyle=y;k.fill();d.canvas.unclipArea(k)}}}}},{25:25,40:40,45:45}],51:[function(n,u,t){function l(d,c){var f=new e({ctx:d.ctx,options:c,chart:d});a.configure(d,f,c);a.addBox(d,f);d.legend=f}var h=n(25);t=n(26);var f=n(45),a=n(30);n=f.noop;h._set("global",{legend:{display:!0,position:"top",fullWidth:!0,reverse:!1,weight:1E3,onClick:function(a,c){var d=c.datasetIndex,e=this.chart,f=e.getDatasetMeta(d);f.hidden=

null===f.hidden?!e.data.datasets[d].hidden:null;e.update()},onHover:null,labels:{boxWidth:40,padding:10,generateLabels:function(a){var c=a.data;return f.isArray(c.datasets)?c.datasets.map(function(c,d){return{text:c.label,fillStyle:f.isArray(c.backgroundColor)?c.backgroundColor[0]:c.backgroundColor,hidden:!a.isDatasetVisible(d),lineCap:c.borderCapStyle,lineDash:c.borderDash,lineDashOffset:c.borderDashOffset,lineJoin:c.borderJoinStyle,lineWidth:c.borderWidth,strokeStyle:c.borderColor,pointStyle:c.pointStyle,

datasetIndex:d}},this):[]}}},legendCallback:function(a){var c=[];c.push('<ul class="'+a.id+'-legend">');for(var d=0;d<a.data.datasets.length;d++)c.push('<li><span style="background-color:'+a.data.datasets[d].backgroundColor+'"></span>'),a.data.datasets[d].label&&c.push(a.data.datasets[d].label),c.push("</li>");c.push("</ul>");return c.join("")}});var e=t.extend({initialize:function(a){f.extend(this,a);this.legendHitBoxes=[];this.doughnutMode=!1},beforeUpdate:n,update:function(a,c,e){this.beforeUpdate();

this.maxWidth=a;this.maxHeight=c;this.margins=e;this.beforeSetDimensions();this.setDimensions();this.afterSetDimensions();this.beforeBuildLabels();this.buildLabels();this.afterBuildLabels();this.beforeFit();this.fit();this.afterFit();this.afterUpdate();return this.minSize},afterUpdate:n,beforeSetDimensions:n,setDimensions:function(){this.isHorizontal()?(this.width=this.maxWidth,this.left=0,this.right=this.width):(this.height=this.maxHeight,this.top=0,this.bottom=this.height);this.paddingBottom=this.paddingRight=

this.paddingTop=this.paddingLeft=0;this.minSize={width:0,height:0}},afterSetDimensions:n,beforeBuildLabels:n,buildLabels:function(){var a=this,c=a.options.labels||{},e=f.callback(c.generateLabels,[a.chart],a)||[];c.filter&&(e=e.filter(function(d){return c.filter(d,a.chart.data)}));a.options.reverse&&e.reverse();a.legendItems=e},afterBuildLabels:n,beforeFit:n,fit:function(){var a=this,c=a.options,e=c.labels;c=c.display;var l=a.ctx,n=h.global,m=f.valueOrDefault,p=m(e.fontSize,n.defaultFontSize),q=m(e.fontStyle,

n.defaultFontStyle);n=m(e.fontFamily,n.defaultFontFamily);q=f.fontString(p,q,n);var x=a.legendHitBoxes=[],y=a.minSize;(n=a.isHorizontal())?(y.width=a.maxWidth,y.height=c?10:0):(y.width=c?10:0,y.height=a.maxHeight);if(c)if(l.font=q,n){var w=a.lineWidths=[0],t=a.legendItems.length?p+e.padding:0;l.textAlign="left";l.textBaseline="top";f.each(a.legendItems,function(c,d){var f=(e.usePointStyle?p*Math.SQRT2:e.boxWidth)+p/2+l.measureText(c.text).width;w[w.length-1]+f+e.padding>=a.width&&(t+=p+e.padding,

w[w.length]=a.left);x[d]={left:0,top:0,width:f,height:p};w[w.length-1]+=f+e.padding});y.height+=t}else{c=e.padding;var A=a.columnWidths=[],u=e.padding,M=0,L=0,ba=p+c;f.each(a.legendItems,function(a,c){var d=(e.usePointStyle?p*Math.SQRT2:e.boxWidth)+p/2+l.measureText(a.text).width;L+ba>y.height&&(u+=M+e.padding,A.push(M),L=M=0);M=Math.max(M,d);L+=ba;x[c]={left:0,top:0,width:d,height:p}});u+=M;A.push(M);y.width+=u}a.width=y.width;a.height=y.height},afterFit:n,isHorizontal:function(){return"top"===this.options.position||

"bottom"===this.options.position},draw:function(){var a,c,e,l=this,n=l.options,m=n.labels,p=h.global,q=p.elements.line,x=l.width,y=l.lineWidths;if(n.display){var w=l.ctx,t=f.valueOrDefault,A=t(m.fontColor,p.defaultFontColor),u=t(m.fontSize,p.defaultFontSize),M=t(m.fontStyle,p.defaultFontStyle),L=t(m.fontFamily,p.defaultFontFamily);M=f.fontString(u,M,L);w.textAlign="left";w.textBaseline="middle";w.lineWidth=.5;w.strokeStyle=A;w.fillStyle=A;w.font=M;var ba=m.usePointStyle?u*Math.SQRT2:m.boxWidth,J=

l.legendHitBoxes,W=l.isHorizontal();W?(a=l.left+(x-y[0])/2,c=l.top+m.padding,e=0):(a=l.left+m.padding,c=l.top+m.padding,e=0);var G=u+m.padding;f.each(l.legendItems,function(d,h){var k=w.measureText(d.text).width,v=ba+u/2+k,A=a,F=c;W?A+v>=x&&(F=c+=G,e++,A=a=l.left+(x-y[e])/2):F+G>l.bottom&&(A=a=A+l.columnWidths[e]+m.padding,F=c=l.top+m.padding,e++);var K=A,C=F;if(!(isNaN(ba)||0>=ba)){w.save();w.fillStyle=t(d.fillStyle,p.defaultColor);w.lineCap=t(d.lineCap,q.borderCapStyle);w.lineDashOffset=t(d.lineDashOffset,

q.borderDashOffset);w.lineJoin=t(d.lineJoin,q.borderJoinStyle);w.lineWidth=t(d.lineWidth,q.borderWidth);w.strokeStyle=t(d.strokeStyle,p.defaultColor);var L=0===t(d.lineWidth,q.borderWidth);w.setLineDash&&w.setLineDash(t(d.lineDash,q.borderDash));if(n.labels&&n.labels.usePointStyle){L=u*Math.SQRT2/2;var M=L/Math.SQRT2;f.canvas.drawPoint(w,d.pointStyle,L,K+M,C+M)}else L||w.strokeRect(K,C,ba,u),w.fillRect(K,C,ba,u);w.restore()}J[h].left=A;J[h].top=F;K=u/2;A=ba+K+A;F+=K;w.fillText(d.text,A,F);d.hidden&&

(w.beginPath(),w.lineWidth=2,w.moveTo(A,F),w.lineTo(A+k,F),w.stroke());W?a+=v+m.padding:c+=G})}},handleEvent:function(a){var c=this.options,d="mouseup"===a.type?"click":a.type,e=!1;if("mousemove"===d){if(!c.onHover)return}else if("click"===d){if(!c.onClick)return}else return;var f=a.x,h=a.y;if(f>=this.left&&f<=this.right&&h>=this.top&&h<=this.bottom)for(var l=this.legendHitBoxes,q=0;q<l.length;++q){var n=l[q];if(f>=n.left&&f<=n.left+n.width&&h>=n.top&&h<=n.top+n.height)if("click"===d){c.onClick.call(this,

a["native"],this.legendItems[q]);e=!0;break}else if("mousemove"===d){c.onHover.call(this,a["native"],this.legendItems[q]);e=!0;break}}return e}});u.exports={id:"legend",_element:e,beforeInit:function(a){var c=a.options.legend;c&&l(a,c)},beforeUpdate:function(d){var c=d.options.legend,e=d.legend;c?(f.mergeIf(c,h.global.legend),e?(a.configure(d,e,c),e.options=c):l(d,c)):e&&(a.removeBox(d,e),delete d.legend)},afterEvent:function(a,c){var d=a.legend;d&&d.handleEvent(c)}}},{25:25,26:26,30:30,45:45}],52:[function(n,

u,t){function l(d,c){var f=new e({ctx:d.ctx,options:c,chart:d});a.configure(d,f,c);a.addBox(d,f);d.titleBlock=f}var h=n(25);t=n(26);var f=n(45),a=n(30);n=f.noop;h._set("global",{title:{display:!1,fontStyle:"bold",fullWidth:!0,lineHeight:1.2,padding:10,position:"top",text:"",weight:2E3}});var e=t.extend({initialize:function(a){f.extend(this,a);this.legendHitBoxes=[]},beforeUpdate:n,update:function(a,c,e){this.beforeUpdate();this.maxWidth=a;this.maxHeight=c;this.margins=e;this.beforeSetDimensions();

this.setDimensions();this.afterSetDimensions();this.beforeBuildLabels();this.buildLabels();this.afterBuildLabels();this.beforeFit();this.fit();this.afterFit();this.afterUpdate();return this.minSize},afterUpdate:n,beforeSetDimensions:n,setDimensions:function(){this.isHorizontal()?(this.width=this.maxWidth,this.left=0,this.right=this.width):(this.height=this.maxHeight,this.top=0,this.bottom=this.height);this.paddingBottom=this.paddingRight=this.paddingTop=this.paddingLeft=0;this.minSize={width:0,height:0}},

afterSetDimensions:n,beforeBuildLabels:n,buildLabels:n,afterBuildLabels:n,beforeFit:n,fit:function(){var a=f.valueOrDefault,c=this.options,e=c.display,l=a(c.fontSize,h.global.defaultFontSize);a=this.minSize;var n=f.isArray(c.text)?c.text.length:1;l=f.options.toLineHeight(c.lineHeight,l);c=e?n*l+2*c.padding:0;this.isHorizontal()?(a.width=this.maxWidth,a.height=c):(a.width=c,a.height=this.maxHeight);this.width=a.width;this.height=a.height},afterFit:n,isHorizontal:function(){var a=this.options.position;

return"top"===a||"bottom"===a},draw:function(){var a=this.ctx,c=f.valueOrDefault,e=this.options,l=h.global;if(e.display){var n=c(e.fontSize,l.defaultFontSize),m=c(e.fontStyle,l.defaultFontStyle),p=c(e.fontFamily,l.defaultFontFamily),q=f.fontString(n,m,p);n=f.options.toLineHeight(e.lineHeight,n);var x=n/2+e.padding;m=0;p=this.top;var t=this.left,w=this.bottom,u=this.right;a.fillStyle=c(e.fontColor,l.defaultFontColor);a.font=q;this.isHorizontal()?(c=t+(u-t)/2,l=p+x,p=u-t):(c="left"===e.position?t+x:

u-x,l=p+(w-p)/2,p=w-p,m=Math.PI*("left"===e.position?-.5:.5));a.save();a.translate(c,l);a.rotate(m);a.textAlign="center";a.textBaseline="middle";e=e.text;if(f.isArray(e))for(l=c=0;l<e.length;++l)a.fillText(e[l],0,c,p),c+=n;else a.fillText(e,0,0,p);a.restore()}}});u.exports={id:"title",_element:e,beforeInit:function(a){var c=a.options.title;c&&l(a,c)},beforeUpdate:function(d){var c=d.options.title,e=d.titleBlock;c?(f.mergeIf(c,h.global.title),e?(a.configure(d,e,c),e.options=c):l(d,c)):e&&(a.removeBox(d,

e),delete d.titleBlock)}}},{25:25,26:26,30:30,45:45}],53:[function(n,u,t){u.exports=function(l){var h=l.Scale.extend({getLabels:function(){var f=this.chart.data;return this.options.labels||(this.isHorizontal()?f.xLabels:f.yLabels)||f.labels},determineDataLimits:function(){var f=this.getLabels();this.minIndex=0;this.maxIndex=f.length-1;if(void 0!==this.options.ticks.min){var a=f.indexOf(this.options.ticks.min);this.minIndex=-1!==a?a:this.minIndex}void 0!==this.options.ticks.max&&(a=f.indexOf(this.options.ticks.max),

this.maxIndex=-1!==a?a:this.maxIndex);this.min=f[this.minIndex];this.max=f[this.maxIndex]},buildTicks:function(){var f=this.getLabels();this.ticks=0===this.minIndex&&this.maxIndex===f.length-1?f:f.slice(this.minIndex,this.maxIndex+1)},getLabelForIndex:function(f,a){var e=this.chart.data,d=this.isHorizontal();return e.yLabels&&!d?this.getRightValue(e.datasets[a].data[f]):this.ticks[f-this.minIndex]},getPixelForValue:function(f,a){var e=this.options.offset,d=Math.max(this.maxIndex+1-this.minIndex-(e?

0:1),1),c;void 0!==f&&null!==f&&(c=this.isHorizontal()?f.x:f.y);if(void 0!==c||void 0!==f&&isNaN(a))c=this.getLabels().indexOf(c||f),a=-1!==c?c:a;if(this.isHorizontal())return d=this.width/d,c=d*(a-this.minIndex),e&&(c+=d/2),this.left+Math.round(c);d=this.height/d;c=d*(a-this.minIndex);e&&(c+=d/2);return this.top+Math.round(c)},getPixelForTick:function(f){return this.getPixelForValue(this.ticks[f],f+this.minIndex,null)},getValueForPixel:function(f){var a=this.options.offset,e=Math.max(this._ticks.length-

(a?0:1),1),d=this.isHorizontal();e=(d?this.width:this.height)/e;f-=d?this.left:this.top;a&&(f-=e/2);return(0>=f?0:Math.round(f/e))+this.minIndex},getBasePixel:function(){return this.bottom}});l.scaleService.registerScaleType("category",h,{position:"bottom"})}},{}],54:[function(n,u,t){var l=n(25),h=n(45),f=n(34);u.exports=function(a){var e={position:"left",ticks:{callback:f.formatters.linear}},d=a.LinearScaleBase.extend({determineDataLimits:function(){function a(a){return n?a.xAxisID===d.id:a.yAxisID===

d.id}var d=this,e=d.options,f=d.chart,l=f.data.datasets,n=d.isHorizontal();d.min=null;d.max=null;var q=e.stacked;void 0===q&&h.each(l,function(c,d){if(!q){var e=f.getDatasetMeta(d);f.isDatasetVisible(d)&&a(e)&&void 0!==e.stack&&(q=!0)}});if(e.stacked||q){var x={};h.each(l,function(c,k){var l=f.getDatasetMeta(k),m=[l.type,void 0===e.stacked&&void 0===l.stack?k:"",l.stack].join(".");void 0===x[m]&&(x[m]={positiveValues:[],negativeValues:[]});var q=x[m].positiveValues,n=x[m].negativeValues;f.isDatasetVisible(k)&&

a(l)&&h.each(c.data,function(a,c){var f=+d.getRightValue(a);isNaN(f)||l.data[c].hidden||(q[c]=q[c]||0,n[c]=n[c]||0,e.relativePoints?q[c]=100:0>f?n[c]+=f:q[c]+=f)})});h.each(x,function(a){var c=a.positiveValues.concat(a.negativeValues);a=h.min(c);c=h.max(c);d.min=null===d.min?a:Math.min(d.min,a);d.max=null===d.max?c:Math.max(d.max,c)})}else h.each(l,function(c,e){var k=f.getDatasetMeta(e);f.isDatasetVisible(e)&&a(k)&&h.each(c.data,function(a,c){var e=+d.getRightValue(a);isNaN(e)||k.data[c].hidden||

(null===d.min?d.min=e:e<d.min&&(d.min=e),null===d.max?d.max=e:e>d.max&&(d.max=e))})});d.min=isFinite(d.min)&&!isNaN(d.min)?d.min:0;d.max=isFinite(d.max)&&!isNaN(d.max)?d.max:1;this.handleTickRangeOptions()},getTickLimit:function(){var a=this.options.ticks;if(this.isHorizontal())a=Math.min(a.maxTicksLimit?a.maxTicksLimit:11,Math.ceil(this.width/50));else{var d=h.valueOrDefault(a.fontSize,l.global.defaultFontSize);a=Math.min(a.maxTicksLimit?a.maxTicksLimit:11,Math.ceil(this.height/(2*d)))}return a},

handleDirectionalChanges:function(){this.isHorizontal()||this.ticks.reverse()},getLabelForIndex:function(a,d){return+this.getRightValue(this.chart.data.datasets[d].data[a])},getPixelForValue:function(a){var c=this.start;a=+this.getRightValue(a);var d=this.end-c;return this.isHorizontal()?this.left+this.width/d*(a-c):this.bottom-this.height/d*(a-c)},getValueForPixel:function(a){var c=this.isHorizontal();return this.start+(c?a-this.left:this.bottom-a)/(c?this.width:this.height)*(this.end-this.start)},

getPixelForTick:function(a){return this.getPixelForValue(this.ticksAsNumbers[a])}});a.scaleService.registerScaleType("linear",d,e)}},{25:25,34:34,45:45}],55:[function(n,u,t){var l=n(45);u.exports=function(h){var f=l.noop;h.LinearScaleBase=h.Scale.extend({getRightValue:function(a){return"string"===typeof a?+a:h.Scale.prototype.getRightValue.call(this,a)},handleTickRangeOptions:function(){var a=this.options.ticks;if(a.beginAtZero){var e=l.sign(this.min),d=l.sign(this.max);0>e&&0>d?this.max=0:0<e&&0<

d&&(this.min=0)}e=void 0!==a.min||void 0!==a.suggestedMin;d=void 0!==a.max||void 0!==a.suggestedMax;void 0!==a.min?this.min=a.min:void 0!==a.suggestedMin&&(this.min=null===this.min?a.suggestedMin:Math.min(this.min,a.suggestedMin));void 0!==a.max?this.max=a.max:void 0!==a.suggestedMax&&(this.max=null===this.max?a.suggestedMax:Math.max(this.max,a.suggestedMax));e!==d&&this.min>=this.max&&(e?this.max=this.min+1:this.min=this.max-1);this.min===this.max&&(this.max++,a.beginAtZero||this.min--)},getTickLimit:f,

handleDirectionalChanges:f,buildTicks:function(){var a=this.options.ticks,e=this.getTickLimit(),d=e=Math.max(2,e),c=a.min;e=a.max;var f=l.valueOrDefault(a.fixedStepSize,a.stepSize),h=[];if(f&&0<f)d=f;else{var n=l.niceNum(this.max-this.min,!1);d=l.niceNum(n/(d-1),!0)}n=Math.floor(this.min/d)*d;var m=Math.ceil(this.max/d)*d;c&&e&&f&&l.almostWhole((e-c)/f,d/1E3)&&(n=c,m=e);f=(m-n)/d;f=l.almostEquals(f,Math.round(f),d/1E3)?Math.round(f):Math.ceil(f);var p=1;1>d&&(p=Math.pow(10,d.toString().length-2),

n=Math.round(n*p)/p,m=Math.round(m*p)/p);h.push(void 0!==c?c:n);for(c=1;c<f;++c)h.push(Math.round((n+c*d)*p)/p);h.push(void 0!==e?e:m);e=this.ticks=h;this.handleDirectionalChanges();this.max=l.max(e);this.min=l.min(e);a.reverse?(e.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max)},convertTicksToLabels:function(){this.ticksAsNumbers=this.ticks.slice();this.zeroLineIndex=this.ticks.indexOf(0);h.Scale.prototype.convertTicksToLabels.call(this)}})}},{45:45}],56:[function(n,

u,t){var l=n(45),h=n(34);u.exports=function(f){var a={position:"left",ticks:{callback:h.formatters.logarithmic}},e=f.Scale.extend({determineDataLimits:function(){function a(a){return m?a.xAxisID===c.id:a.yAxisID===c.id}var c=this,e=c.options,f=c.chart,h=f.data.datasets,m=c.isHorizontal();c.min=null;c.max=null;c.minNotZero=null;var n=e.stacked;void 0===n&&l.each(h,function(c,d){if(!n){var e=f.getDatasetMeta(d);f.isDatasetVisible(d)&&a(e)&&void 0!==e.stack&&(n=!0)}});if(e.stacked||n){var q={};l.each(h,

function(d,h){var k=f.getDatasetMeta(h),m=[k.type,void 0===e.stacked&&void 0===k.stack?h:"",k.stack].join(".");f.isDatasetVisible(h)&&a(k)&&(void 0===q[m]&&(q[m]=[]),l.each(d.data,function(a,d){var e=q[m],f=+c.getRightValue(a);isNaN(f)||k.data[d].hidden||0>f||(e[d]=e[d]||0,e[d]+=f)}))});l.each(q,function(a){if(0<a.length){var d=l.min(a);a=l.max(a);c.min=null===c.min?d:Math.min(c.min,d);c.max=null===c.max?a:Math.max(c.max,a)}})}else l.each(h,function(d,e){var h=f.getDatasetMeta(e);f.isDatasetVisible(e)&&

a(h)&&l.each(d.data,function(a,d){var e=+c.getRightValue(a);isNaN(e)||h.data[d].hidden||0>e||(null===c.min?c.min=e:e<c.min&&(c.min=e),null===c.max?c.max=e:e>c.max&&(c.max=e),0!==e&&(null===c.minNotZero||e<c.minNotZero)&&(c.minNotZero=e))})});this.handleTickRangeOptions()},handleTickRangeOptions:function(){var a=this.options.ticks,c=l.valueOrDefault;this.min=c(a.min,this.min);this.max=c(a.max,this.max);this.min===this.max&&(0!==this.min&&null!==this.min?(this.min=Math.pow(10,Math.floor(l.log10(this.min))-

1),this.max=Math.pow(10,Math.floor(l.log10(this.max))+1)):(this.min=1,this.max=10));null===this.min&&(this.min=Math.pow(10,Math.floor(l.log10(this.max))-1));null===this.max&&(this.max=0!==this.min?Math.pow(10,Math.floor(l.log10(this.min))+1):10);null===this.minNotZero&&(this.minNotZero=0<this.min?this.min:1>this.max?Math.pow(10,Math.floor(l.log10(this.max))):1)},buildTicks:function(){var a=this.options.ticks,c=!this.isHorizontal(),e=a.max,f=[],h=l.valueOrDefault,m=h(a.min,Math.pow(10,Math.floor(l.log10(this.min)))),

n=Math.floor(l.log10(this.max)),q=Math.ceil(this.max/Math.pow(10,n));if(0===m){var x=Math.floor(l.log10(this.minNotZero));var t=Math.floor(this.minNotZero/Math.pow(10,x));f.push(m);m=t*Math.pow(10,x)}else x=Math.floor(l.log10(m)),t=Math.floor(m/Math.pow(10,x));var w=0>x?Math.pow(10,Math.abs(x)):1;do f.push(m),++t,10===t&&(t=1,++x,w=0<=x?1:w),m=Math.round(t*Math.pow(10,x)*w)/w;while(x<n||x===n&&t<q);e=h(e,m);f.push(e);f=this.ticks=f;this.max=l.max(f);this.min=l.min(f);a.reverse?(c=!c,this.start=this.max,

this.end=this.min):(this.start=this.min,this.end=this.max);c&&f.reverse()},convertTicksToLabels:function(){this.tickValues=this.ticks.slice();f.Scale.prototype.convertTicksToLabels.call(this)},getLabelForIndex:function(a,c){return+this.getRightValue(this.chart.data.datasets[c].data[a])},getPixelForTick:function(a){return this.getPixelForValue(this.tickValues[a])},_getFirstTickValue:function(a){var c=Math.floor(l.log10(a));return Math.floor(a/Math.pow(10,c))*Math.pow(10,c)},getPixelForValue:function(a){var c=

this.options.ticks.reverse,d=l.log10,e=this._getFirstTickValue(this.minNotZero),h=0;a=+this.getRightValue(a);if(c){var m=this.end;var n=this.start;var q=-1}else m=this.start,n=this.end,q=1;if(this.isHorizontal()){var x=this.width;c=c?this.right:this.left}else x=this.height,q*=-1,c=c?this.top:this.bottom;a!==m&&(0===m&&(h=l.getValueOrDefault(this.options.ticks.fontSize,f.defaults.global.defaultFontSize),x-=h,m=e),0!==a&&(h+=x/(d(n)-d(m))*(d(a)-d(m))),c+=q*h);return c},getValueForPixel:function(a){var c=

this.options.ticks.reverse,d=l.log10,e=this._getFirstTickValue(this.minNotZero);if(c){var h=this.end;var m=this.start}else h=this.start,m=this.end;if(this.isHorizontal()){var n=this.width;a=c?this.right-a:a-this.left}else n=this.height,a=c?a-this.top:this.bottom-a;a!==h&&(0===h&&(h=l.getValueOrDefault(this.options.ticks.fontSize,f.defaults.global.defaultFontSize),a-=h,n-=h,h=e),a*=d(m)-d(h),a/=n,a=Math.pow(10,d(h)+a));return a}});f.scaleService.registerScaleType("logarithmic",e,a)}},{34:34,45:45}],

57:[function(n,u,t){var l=n(25),h=n(45),f=n(34);u.exports=function(a){function e(a){var c=a.options;return c.angleLines.display||c.pointLabels.display?a.chart.data.labels.length:0}function d(a){var c=a.options.pointLabels;a=h.valueOrDefault(c.fontSize,t.defaultFontSize);var d=h.valueOrDefault(c.fontStyle,t.defaultFontStyle);c=h.valueOrDefault(c.fontFamily,t.defaultFontFamily);var e=h.fontString(a,d,c);return{size:a,style:d,family:c,font:e}}function c(a,c,d,e,f){return a===e||a===f?{start:c-d/2,end:c+

d/2}:a<e||a>f?{start:c-d-5,end:c}:{start:c,end:c+d+5}}function k(a){var c=a.ctx,f=a.options,k=f.angleLines,l=f.pointLabels;c.lineWidth=k.lineWidth;c.strokeStyle=k.color;f=a.getDistanceFromCenterForValue(f.ticks.reverse?a.min:a.max);var m=d(a);c.textBaseline="top";for(var n=e(a)-1;0<=n;n--){if(k.display){var q=a.getPointPosition(n,f);c.beginPath();c.moveTo(a.xCenter,a.yCenter);c.lineTo(q.x,q.y);c.stroke();c.closePath()}if(l.display){q=a.getPointPosition(n,f+5);var p=h.valueAtIndexOrDefault(l.fontColor,

n,t.defaultFontColor);c.font=m.font;c.fillStyle=p;p=a.getIndexAngle(n);p=h.toDegrees(p);var u=0===p||180===p?"center":180>p?"left":"right";c.textAlign=u;u=a._pointLabelSizes[n];var v=q;if(90===p||270===p)v.y-=u.h/2;else if(270<p||90>p)v.y-=u.h;p=c;u=a.pointLabels[n]||"";var C=m.size;if(h.isArray(u)){v=q.y;C*=1.5;for(var G=0;G<u.length;++G)p.fillText(u[G],q.x,v),v+=C}else p.fillText(u,q.x,q.y)}}}function n(a){return h.isNumber(a)?a:0}var t=l.global,m={display:!0,animate:!0,position:"chartArea",angleLines:{display:!0,

color:"rgba(0, 0, 0, 0.1)",lineWidth:1},gridLines:{circular:!1},ticks:{showLabelBackdrop:!0,backdropColor:"rgba(255,255,255,0.75)",backdropPaddingY:2,backdropPaddingX:2,callback:f.formatters.linear},pointLabels:{display:!0,fontSize:10,callback:function(a){return a}}},p=a.LinearScaleBase.extend({setDimensions:function(){var a=this.options,c=a.ticks;this.width=this.maxWidth;this.height=this.maxHeight;this.xCenter=Math.round(this.width/2);this.yCenter=Math.round(this.height/2);var d=h.min([this.height,

this.width]),e=h.valueOrDefault(c.fontSize,t.defaultFontSize);this.drawingArea=a.display?d/2-(e/2+c.backdropPaddingY):d/2},determineDataLimits:function(){var a=this,c=a.chart,d=Number.POSITIVE_INFINITY,e=Number.NEGATIVE_INFINITY;h.each(c.data.datasets,function(f,k){if(c.isDatasetVisible(k)){var l=c.getDatasetMeta(k);h.each(f.data,function(c,f){var h=+a.getRightValue(c);isNaN(h)||l.data[f].hidden||(d=Math.min(h,d),e=Math.max(h,e))})}});a.min=d===Number.POSITIVE_INFINITY?0:d;a.max=e===Number.NEGATIVE_INFINITY?

0:e;a.handleTickRangeOptions()},getTickLimit:function(){var a=this.options.ticks,c=h.valueOrDefault(a.fontSize,t.defaultFontSize);return Math.min(a.maxTicksLimit?a.maxTicksLimit:11,Math.ceil(this.drawingArea/(1.5*c)))},convertTicksToLabels:function(){a.LinearScaleBase.prototype.convertTicksToLabels.call(this);this.pointLabels=this.chart.data.labels.map(this.options.pointLabels.callback,this)},getLabelForIndex:function(a,c){return+this.getRightValue(this.chart.data.datasets[c].data[a])},fit:function(){if(this.options.pointLabels.display){var a=

d(this),f=Math.min(this.height/2,this.width/2),k={r:this.width,l:0,t:this.height,b:0},l={},m;this.ctx.font=a.font;this._pointLabelSizes=[];var n=e(this);for(m=0;m<n;m++){var p=this.getPointPosition(m,f);var t=this.ctx,u=a.size;var v=this.pointLabels[m]||"";v=h.isArray(v)?{w:h.longestText(t,t.font,v),h:v.length*u+1.5*(v.length-1)*u}:{w:t.measureText(v).width,h:u};this._pointLabelSizes[m]=v;t=this.getIndexAngle(m);var J=h.toDegrees(t)%360;u=c(J,p.x,v.w,0,180);p=c(J,p.y,v.h,90,270);u.start<k.l&&(k.l=

u.start,l.l=t);u.end>k.r&&(k.r=u.end,l.r=t);p.start<k.t&&(k.t=p.start,l.t=t);p.end>k.b&&(k.b=p.end,l.b=t)}this.setReductions(f,k,l)}else this.drawingArea=Math.round(Math.min(this.height/2,this.width/2)),this.setCenterPoint(0,0,0,0)},setReductions:function(a,c,d){var e=c.l/Math.sin(d.l),f=Math.max(c.r-this.width,0)/Math.sin(d.r),h=-c.t/Math.cos(d.t);c=-Math.max(c.b-this.height,0)/Math.cos(d.b);e=n(e);f=n(f);h=n(h);c=n(c);this.drawingArea=Math.min(Math.round(a-(e+f)/2),Math.round(a-(h+c)/2));this.setCenterPoint(e,

f,h,c)},setCenterPoint:function(a,c,d,e){d+=this.drawingArea;e=this.height-e-this.drawingArea;this.xCenter=Math.round((a+this.drawingArea+(this.width-c-this.drawingArea))/2+this.left);this.yCenter=Math.round((d+e)/2+this.top)},getIndexAngle:function(a){var c=2*Math.PI/e(this);return a*c+(this.chart.options&&this.chart.options.startAngle?this.chart.options.startAngle:0)*Math.PI*2/360},getDistanceFromCenterForValue:function(a){if(null===a)return 0;var c=this.drawingArea/(this.max-this.min);return this.options.ticks.reverse?

(this.max-a)*c:(a-this.min)*c},getPointPosition:function(a,c){var d=this.getIndexAngle(a)-Math.PI/2;return{x:Math.round(Math.cos(d)*c)+this.xCenter,y:Math.round(Math.sin(d)*c)+this.yCenter}},getPointPositionForValue:function(a,c){return this.getPointPosition(a,this.getDistanceFromCenterForValue(c))},getBasePosition:function(){var a=this.min,c=this.max;return this.getPointPositionForValue(0,this.beginAtZero?0:0>a&&0>c?c:0<a&&0<c?a:0)},draw:function(){var a=this,c=a.options,d=c.gridLines,f=c.ticks,

l=h.valueOrDefault;if(c.display){var m=a.ctx,n=this.getIndexAngle(0),p=l(f.fontSize,t.defaultFontSize),u=l(f.fontStyle,t.defaultFontStyle),v=l(f.fontFamily,t.defaultFontFamily),J=h.fontString(p,u,v);h.each(a.ticks,function(c,k){if(0<k||f.reverse){var q=a.getDistanceFromCenterForValue(a.ticksAsNumbers[k]);if(d.display&&0!==k)a:{var w=a.ctx;w.strokeStyle=h.valueAtIndexOrDefault(d.color,k-1);w.lineWidth=h.valueAtIndexOrDefault(d.lineWidth,k-1);if(a.options.gridLines.circular)w.beginPath(),w.arc(a.xCenter,

a.yCenter,q,0,2*Math.PI);else{var u=e(a);if(0===u)break a;w.beginPath();var v=a.getPointPosition(0,q);w.moveTo(v.x,v.y);for(var A=1;A<u;A++)v=a.getPointPosition(A,q),w.lineTo(v.x,v.y)}w.closePath();w.stroke()}f.display&&(w=l(f.fontColor,t.defaultFontColor),m.font=J,m.save(),m.translate(a.xCenter,a.yCenter),m.rotate(n),f.showLabelBackdrop&&(u=m.measureText(c).width,m.fillStyle=f.backdropColor,m.fillRect(-u/2-f.backdropPaddingX,-q-p/2-f.backdropPaddingY,u+2*f.backdropPaddingX,p+2*f.backdropPaddingY)),

m.textAlign="center",m.textBaseline="middle",m.fillStyle=w,m.fillText(c,0,-q),m.restore())}});(c.angleLines.display||c.pointLabels.display)&&k(a)}}});a.scaleService.registerScaleType("radialLinear",p,m)}},{25:25,34:34,45:45}],58:[function(n,u,t){function l(a,c){return a-c}function h(a){var c={},d=[],e;var f=0;for(e=a.length;f<e;++f){var h=a[f];c[h]||(c[h]=!0,d.push(h))}return d}function f(a,c,d,e){a:{var f=0;var h=a.length-1;for(var k,l,m;0<=f&&f<=h;)if(k=f+h>>1,l=a[k-1]||null,m=a[k],l)if(m[c]<d)f=

k+1;else if(l[c]>d)h=k-1;else{f=l;h=m;break a}else{f=null;h=m;break a}f=m;h=null}m=f?h?f:a[a.length-2]:a[0];a=f?h?h:a[a.length-1]:a[1];f=a[c]-m[c];return m[e]+(a[e]-m[e])*(f?(d-m[c])/f:0)}function a(a,d){var e=d.parser,f=d.parser||d.format;if("function"===typeof e)return e(a);if("string"===typeof a&&"string"===typeof f)return c(a,f);a instanceof c||(a=c(a));return a.isValid()?a:"function"===typeof f?f(a):a}function e(c,d){if(C.isNullOrUndef(c))return null;var e=d.options.time,f=a(d.getRightValue(c),

e);if(!f.isValid())return null;e.round&&f.startOf(e.round);return f.valueOf()}function d(a){a=q.indexOf(a)+1;for(var c=q.length;a<c;++a)if(p[q[a]].common)return q[a]}var c=n(6);c="function"===typeof c?c:window.moment;var k=n(25),C=n(45),v=Number.MIN_SAFE_INTEGER||-9007199254740991,m=Number.MAX_SAFE_INTEGER||9007199254740991,p={millisecond:{common:!0,size:1,steps:[1,2,5,10,20,50,100,250,500]},second:{common:!0,size:1E3,steps:[1,2,5,10,30]},minute:{common:!0,size:6E4,steps:[1,2,5,10,30]},hour:{common:!0,

size:36E5,steps:[1,2,3,6,12]},day:{common:!0,size:864E5,steps:[1,2,5]},week:{common:!1,size:6048E5,steps:[1,2,3,4]},month:{common:!0,size:2628E6,steps:[1,2,3]},quarter:{common:!1,size:7884E6,steps:[1,2,3,4]},year:{common:!0,size:3154E7}},q=Object.keys(p);u.exports=function(n){var t=n.Scale.extend({initialize:function(){if(!c)throw Error("Chart.js - Moment.js could not be found! You must include it before Chart.js to use the time scale. Download at https://momentjs.com");this.mergeTicksOptions();n.Scale.prototype.initialize.call(this)},

update:function(){var a=this.options;a.time&&a.time.format&&console.warn("options.time.format is deprecated and replaced by options.time.parser.");return n.Scale.prototype.update.apply(this,arguments)},getRightValue:function(a){a&&void 0!==a.t&&(a=a.t);return n.Scale.prototype.getRightValue.call(this,a)},determineDataLimits:function(){var a=this.chart,d=this.options.time,f=d.unit||"day",k=m,n=v,p=[],q=[],t=[],u,x;var y=0;for(u=a.data.labels.length;y<u;++y)t.push(e(a.data.labels[y],this));y=0;for(u=

(a.data.datasets||[]).length;y<u;++y)if(a.isDatasetVisible(y)){var H=a.data.datasets[y].data;if(C.isObject(H[0])){q[y]=[];var N=0;for(x=H.length;N<x;++N){var Q=e(H[N],this);p.push(Q);q[y][N]=Q}}else p.push.apply(p,t),q[y]=t.slice(0)}else q[y]=[];t.length&&(t=h(t).sort(l),k=Math.min(k,t[0]),n=Math.max(n,t[t.length-1]));p.length&&(p=h(p).sort(l),k=Math.min(k,p[0]),n=Math.max(n,p[p.length-1]));k=e(d.min,this)||k;n=e(d.max,this)||n;k=k===m?+c().startOf(f):k;n=n===v?+c().endOf(f)+1:n;this.min=Math.min(k,

n);this.max=Math.max(k+1,n);this._horizontal=this.isHorizontal();this._table=[];this._timestamps={data:p,datasets:q,labels:t}},buildTicks:function(){var h=this.min,k=this.max,l=this.options,n=l.time,t=[];switch(l.ticks.source){case "data":var u=this._timestamps.data;break;case "labels":u=this._timestamps.labels;break;default:var v=h;var x=k;var y=this.getLabelCapacity(h);u=l.time;var G;if(!(G=u.unit))a:{G=q.length;var I;for(I=q.indexOf(u.minUnit);I<G-1;++I){var H=p[q[I]];var N=H.steps?H.steps[H.steps.length-

1]:m;if(H.common&&Math.ceil((x-v)/(N*H.size))<=y){G=q[I];break a}}G=q[G-1]}I=d(G);var Q=C.valueOrDefault(u.stepSize,u.unitStepSize);H="week"===G?u.isoWeekday:!1;N=l.ticks.major.enabled;var V=p[G],D=c(v),X=c(x),la=[];if(!Q){v=x-v;var ca=p[G];Q=ca.size;ca=ca.steps;var ha;if(ca){var E=0;for(ha=ca.length;E<ha;++E){var P=ca[E];if(Math.ceil(v/(Q*P))<=y)break}Q=P}else Q=Math.ceil(v/(y*Q))}H&&(D=D.isoWeekday(H),X=X.isoWeekday(H));D=D.startOf(H?"day":G);X=X.startOf(H?"day":G);X<x&&X.add(1,G);x=c(D);N&&I&&

!H&&!u.round&&(x.startOf(I),x.add(~~((D-x)/(V.size*Q))*Q,G));for(;x<X;x.add(Q,G))la.push(+x);la.push(+x);u=la}"ticks"===l.bounds&&u.length&&(h=u[0],k=u[u.length-1]);h=e(n.min,this)||h;k=e(n.max,this)||k;x=0;for(y=u.length;x<y;++x)P=u[x],P>=h&&P<=k&&t.push(P);this.min=h;this.max=k;if(!(u=n.unit))a:{u=n.minUnit;x=this.min;x=c.duration(c(this.max).diff(c(x)));for(y=q.length-1;y>=q.indexOf(u);y--)if(P=q[y],p[P].common&&x.as(P)>=t.length){u=P;break a}u=q[u?q.indexOf(u):0]}this._unit=u;this._majorUnit=

d(this._unit);I=this._timestamps.data;H=h;N=k;if("linear"!==l.distribution&&I.length){u=[];x=[H];y=0;for(P=I.length;y<P;++y)G=I[y],G>H&&G<N&&x.push(G);x.push(N);y=0;for(P=x.length;y<P;++y)H=x[y+1],I=x[y-1],G=x[y],void 0!==I&&void 0!==H&&Math.round((H+I)/2)===G||u.push({time:G,pos:y/(P-1)})}else u=[{time:H,pos:0},{time:N,pos:1}];u=this._table=u;y=x=0;l.offset&&t.length&&(l.time.min||(k=1<t.length?t[1]:k,P=t[0],x=(f(u,"time",k,"pos")-f(u,"time",P,"pos"))/2),l.time.max||(k=t[t.length-1],P=1<t.length?

t[t.length-2]:h,y=(f(u,"time",k,"pos")-f(u,"time",P,"pos"))/2));this._offsets={left:x,right:y};a:{l=this._timestamps.data;u=l.length;for(k=0;k<u;k++){h=a(l[k],n);if(0!==h.millisecond()){n="MMM D, YYYY h:mm:ss.SSS a";break a}if(0!==h.second()||0!==h.minute()||0!==h.hour())var ea=!0}n=ea?"MMM D, YYYY h:mm:ss a":"MMM D, YYYY"}this._labelFormat=n;n=this._majorUnit;ea=[];l=0;for(k=t.length;l<k;++l)h=t[l],u=n?h===+c(h).startOf(n):!1,ea.push({value:h,major:u});return ea},getLabelForIndex:function(c,d){var e=

this.chart.data,f=this.options.time,h=e.labels&&c<e.labels.length?e.labels[c]:"";e=e.datasets[d].data[c];C.isObject(e)&&(h=this.getRightValue(e));return f.tooltipFormat?a(h,f).format(f.tooltipFormat):"string"===typeof h?h:a(h,f).format(this._labelFormat)},tickFormatFunction:function(a,c,d,e){var f=this.options,h=a.valueOf(),k=f.time.displayFormats,l=k[this._unit],m=this._majorUnit,n=k[m],p=a.clone().startOf(m).valueOf();k=f.ticks.major;h=k.enabled&&m&&n&&h===p;a=a.format(e?e:h?n:l);f=h?k:f.ticks.minor;

return(f=C.valueOrDefault(f.callback,f.userCallback))?f(a,c,d):a},convertTicksToLabels:function(a){var d=[],e;var f=0;for(e=a.length;f<e;++f)d.push(this.tickFormatFunction(c(a[f].value),f,a));return d},getPixelForOffset:function(a){var c=this._horizontal?this.width:this.height,d=this._horizontal?this.left:this.top;a=f(this._table,"time",a,"pos");return d+c*(this._offsets.left+a)/(this._offsets.left+1+this._offsets.right)},getPixelForValue:function(a,c,d){var f=null;void 0!==c&&void 0!==d&&(f=this._timestamps.datasets[d][c]);

null===f&&(f=e(a,this));if(null!==f)return this.getPixelForOffset(f)},getPixelForTick:function(a){var c=this.getTicks();return 0<=a&&a<c.length?this.getPixelForOffset(c[a].value):null},getValueForPixel:function(a){var d=this._horizontal?this.width:this.height,e=this._horizontal?this.left:this.top;a=f(this._table,"pos",(d?(a-e)/d:0)*(this._offsets.left+1+this._offsets.left)-this._offsets.right,"time");return c(a)},getLabelWidth:function(a){var c=this.options.ticks;a=this.ctx.measureText(a).width;var d=

C.toRadians(c.maxRotation),e=Math.cos(d);d=Math.sin(d);c=C.valueOrDefault(c.fontSize,k.global.defaultFontSize);return a*e+c*d},getLabelCapacity:function(a){var d=this.options.time.displayFormats.millisecond;a=this.tickFormatFunction(c(a),0,[],d);a=this.getLabelWidth(a);d=this.isHorizontal()?this.width:this.height;a=Math.floor(d/a);return 0<a?a:1}});n.scaleService.registerScaleType("time",t,{position:"bottom",distribution:"linear",bounds:"data",time:{parser:!1,format:!1,unit:!1,round:!1,displayFormat:!1,

isoWeekday:!1,minUnit:"millisecond",displayFormats:{millisecond:"h:mm:ss.SSS a",second:"h:mm:ss a",minute:"h:mm a",hour:"hA",day:"MMM D",week:"ll",month:"MMM YYYY",quarter:"[Q]Q - YYYY",year:"YYYY"}},ticks:{autoSkip:!1,source:"auto",major:{enabled:!1}}})}},{25:25,45:45,6:6}]},{},[7])(7)});